/*
 * Emby Server REST API (BETA)
 * 
 */

package embyclient.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

/**
 * Gets or Sets DataExplorer2.Model.Enums.LanguageSources
 */
@JsonAdapter(DataExplorer2ModelEnumsLanguageSources.Adapter.class)
public enum DataExplorer2ModelEnumsLanguageSources {
  THISITEM("ThisItem"),
  PARENTITEM("ParentItem"),
  LIBRARYOPTIONS("LibraryOptions"),
  SERVERCONFIGURATION("ServerConfiguration");

  private String value;

  DataExplorer2ModelEnumsLanguageSources(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  public static DataExplorer2ModelEnumsLanguageSources fromValue(String input) {
    for (DataExplorer2ModelEnumsLanguageSources b : DataExplorer2ModelEnumsLanguageSources.values()) {
      if (b.value.equals(input)) {
        return b;
      }
    }
    return null;
  }

  public static class Adapter extends TypeAdapter<DataExplorer2ModelEnumsLanguageSources> {
    @Override
    public void write(final JsonWriter jsonWriter, final DataExplorer2ModelEnumsLanguageSources enumeration) throws IOException {
      jsonWriter.value(String.valueOf(enumeration.getValue()));
    }

    @Override
    public DataExplorer2ModelEnumsLanguageSources read(final JsonReader jsonReader) throws IOException {
      Object value = jsonReader.nextString();
      return DataExplorer2ModelEnumsLanguageSources.fromValue((String)(value));
    }
  }
}
