/*
 * Emby Server REST API (BETA)
 * 
 */

package embyclient.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

/**
 * Gets or Sets DataExplorer2.Model.Enums.RowContentTypes
 */
@JsonAdapter(DataExplorer2ModelEnumsRowContentTypes.Adapter.class)
public enum DataExplorer2ModelEnumsRowContentTypes {
  NONE("None"),
  LOCALFILE("LocalFile"),
  LOCALFOLDER("LocalFolder"),
  ITEMID("ItemId"),
  ITEMLINK("ItemLink"),
  ITEMLINKARRAY("ItemLinkArray"),
  URL("Url"),
  IMAGEINFO("ImageInfo");

  private String value;

  DataExplorer2ModelEnumsRowContentTypes(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  public static DataExplorer2ModelEnumsRowContentTypes fromValue(String input) {
    for (DataExplorer2ModelEnumsRowContentTypes b : DataExplorer2ModelEnumsRowContentTypes.values()) {
      if (b.value.equals(input)) {
        return b;
      }
    }
    return null;
  }

  public static class Adapter extends TypeAdapter<DataExplorer2ModelEnumsRowContentTypes> {
    @Override
    public void write(final JsonWriter jsonWriter, final DataExplorer2ModelEnumsRowContentTypes enumeration) throws IOException {
      jsonWriter.value(String.valueOf(enumeration.getValue()));
    }

    @Override
    public DataExplorer2ModelEnumsRowContentTypes read(final JsonReader jsonReader) throws IOException {
      Object value = jsonReader.nextString();
      return DataExplorer2ModelEnumsRowContentTypes.fromValue((String)(value));
    }
  }
}
