/*
 * Emby Server REST API (BETA)
 * 
 */

package embyclient.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

/**
 * Gets or Sets DataExplorer2.Model.Enums.ShowProviders
 */
@JsonAdapter(DataExplorer2ModelEnumsShowProviders.Adapter.class)
public enum DataExplorer2ModelEnumsShowProviders {
  ALL("all"),
  REMOTE("remote"),
  ENABLED("enabled"),
  ENABLEDREMOTE("enabledremote"),
  NONE("none");

  private String value;

  DataExplorer2ModelEnumsShowProviders(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  public static DataExplorer2ModelEnumsShowProviders fromValue(String input) {
    for (DataExplorer2ModelEnumsShowProviders b : DataExplorer2ModelEnumsShowProviders.values()) {
      if (b.value.equals(input)) {
        return b;
      }
    }
    return null;
  }

  public static class Adapter extends TypeAdapter<DataExplorer2ModelEnumsShowProviders> {
    @Override
    public void write(final JsonWriter jsonWriter, final DataExplorer2ModelEnumsShowProviders enumeration) throws IOException {
      jsonWriter.value(String.valueOf(enumeration.getValue()));
    }

    @Override
    public DataExplorer2ModelEnumsShowProviders read(final JsonReader jsonReader) throws IOException {
      Object value = jsonReader.nextString();
      return DataExplorer2ModelEnumsShowProviders.fromValue((String)(value));
    }
  }
}
