/*
 * Emby Server REST API (BETA)
 * 
 */

package embyclient.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import embyclient.model.CollectionsGenericKeyValuePairStringObject;
import embyclient.model.DataExplorer2ModelEnumsLanguageSources;
import embyclient.model.DataExplorer2ModelItemDataTableItemDataRow;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * DataExplorer2ModelItemDataTable
 */


public class DataExplorer2ModelItemDataTable {
  @SerializedName("Headers")
  private List<String> headers = null;

  @SerializedName("LookupData")
  private List<CollectionsGenericKeyValuePairStringObject> lookupData = null;

  @SerializedName("Rows")
  private List<DataExplorer2ModelItemDataTableItemDataRow> rows = null;

  @SerializedName("ItemType")
  private String itemType = null;

  @SerializedName("ItemName")
  private String itemName = null;

  @SerializedName("UsedMetadatalanguage")
  private String usedMetadatalanguage = null;

  @SerializedName("ConfiguredMetadatalanguage")
  private String configuredMetadatalanguage = null;

  @SerializedName("LanguageSource")
  private DataExplorer2ModelEnumsLanguageSources languageSource = null;

  @SerializedName("ProviderCount")
  private Integer providerCount = null;

  @SerializedName("RelationTableRows")
  private List<DataExplorer2ModelItemDataTableItemDataRow> relationTableRows = null;

  @SerializedName("ImageTableRows")
  private List<DataExplorer2ModelItemDataTableItemDataRow> imageTableRows = null;

  public DataExplorer2ModelItemDataTable headers(List<String> headers) {
    this.headers = headers;
    return this;
  }

  public DataExplorer2ModelItemDataTable addHeadersItem(String headersItem) {
    if (this.headers == null) {
      this.headers = new ArrayList<>();
    }
    this.headers.add(headersItem);
    return this;
  }

   /**
   * Get headers
   * @return headers
  **/
  @Schema(description = "")
  public List<String> getHeaders() {
    return headers;
  }

  public void setHeaders(List<String> headers) {
    this.headers = headers;
  }

  public DataExplorer2ModelItemDataTable lookupData(List<CollectionsGenericKeyValuePairStringObject> lookupData) {
    this.lookupData = lookupData;
    return this;
  }

  public DataExplorer2ModelItemDataTable addLookupDataItem(CollectionsGenericKeyValuePairStringObject lookupDataItem) {
    if (this.lookupData == null) {
      this.lookupData = new ArrayList<>();
    }
    this.lookupData.add(lookupDataItem);
    return this;
  }

   /**
   * Get lookupData
   * @return lookupData
  **/
  @Schema(description = "")
  public List<CollectionsGenericKeyValuePairStringObject> getLookupData() {
    return lookupData;
  }

  public void setLookupData(List<CollectionsGenericKeyValuePairStringObject> lookupData) {
    this.lookupData = lookupData;
  }

  public DataExplorer2ModelItemDataTable rows(List<DataExplorer2ModelItemDataTableItemDataRow> rows) {
    this.rows = rows;
    return this;
  }

  public DataExplorer2ModelItemDataTable addRowsItem(DataExplorer2ModelItemDataTableItemDataRow rowsItem) {
    if (this.rows == null) {
      this.rows = new ArrayList<>();
    }
    this.rows.add(rowsItem);
    return this;
  }

   /**
   * Get rows
   * @return rows
  **/
  @Schema(description = "")
  public List<DataExplorer2ModelItemDataTableItemDataRow> getRows() {
    return rows;
  }

  public void setRows(List<DataExplorer2ModelItemDataTableItemDataRow> rows) {
    this.rows = rows;
  }

  public DataExplorer2ModelItemDataTable itemType(String itemType) {
    this.itemType = itemType;
    return this;
  }

   /**
   * Get itemType
   * @return itemType
  **/
  @Schema(description = "")
  public String getItemType() {
    return itemType;
  }

  public void setItemType(String itemType) {
    this.itemType = itemType;
  }

  public DataExplorer2ModelItemDataTable itemName(String itemName) {
    this.itemName = itemName;
    return this;
  }

   /**
   * Get itemName
   * @return itemName
  **/
  @Schema(description = "")
  public String getItemName() {
    return itemName;
  }

  public void setItemName(String itemName) {
    this.itemName = itemName;
  }

  public DataExplorer2ModelItemDataTable usedMetadatalanguage(String usedMetadatalanguage) {
    this.usedMetadatalanguage = usedMetadatalanguage;
    return this;
  }

   /**
   * Get usedMetadatalanguage
   * @return usedMetadatalanguage
  **/
  @Schema(description = "")
  public String getUsedMetadatalanguage() {
    return usedMetadatalanguage;
  }

  public void setUsedMetadatalanguage(String usedMetadatalanguage) {
    this.usedMetadatalanguage = usedMetadatalanguage;
  }

  public DataExplorer2ModelItemDataTable configuredMetadatalanguage(String configuredMetadatalanguage) {
    this.configuredMetadatalanguage = configuredMetadatalanguage;
    return this;
  }

   /**
   * Get configuredMetadatalanguage
   * @return configuredMetadatalanguage
  **/
  @Schema(description = "")
  public String getConfiguredMetadatalanguage() {
    return configuredMetadatalanguage;
  }

  public void setConfiguredMetadatalanguage(String configuredMetadatalanguage) {
    this.configuredMetadatalanguage = configuredMetadatalanguage;
  }

  public DataExplorer2ModelItemDataTable languageSource(DataExplorer2ModelEnumsLanguageSources languageSource) {
    this.languageSource = languageSource;
    return this;
  }

   /**
   * Get languageSource
   * @return languageSource
  **/
  @Schema(description = "")
  public DataExplorer2ModelEnumsLanguageSources getLanguageSource() {
    return languageSource;
  }

  public void setLanguageSource(DataExplorer2ModelEnumsLanguageSources languageSource) {
    this.languageSource = languageSource;
  }

  public DataExplorer2ModelItemDataTable providerCount(Integer providerCount) {
    this.providerCount = providerCount;
    return this;
  }

   /**
   * Get providerCount
   * @return providerCount
  **/
  @Schema(description = "")
  public Integer getProviderCount() {
    return providerCount;
  }

  public void setProviderCount(Integer providerCount) {
    this.providerCount = providerCount;
  }

  public DataExplorer2ModelItemDataTable relationTableRows(List<DataExplorer2ModelItemDataTableItemDataRow> relationTableRows) {
    this.relationTableRows = relationTableRows;
    return this;
  }

  public DataExplorer2ModelItemDataTable addRelationTableRowsItem(DataExplorer2ModelItemDataTableItemDataRow relationTableRowsItem) {
    if (this.relationTableRows == null) {
      this.relationTableRows = new ArrayList<>();
    }
    this.relationTableRows.add(relationTableRowsItem);
    return this;
  }

   /**
   * Get relationTableRows
   * @return relationTableRows
  **/
  @Schema(description = "")
  public List<DataExplorer2ModelItemDataTableItemDataRow> getRelationTableRows() {
    return relationTableRows;
  }

  public void setRelationTableRows(List<DataExplorer2ModelItemDataTableItemDataRow> relationTableRows) {
    this.relationTableRows = relationTableRows;
  }

  public DataExplorer2ModelItemDataTable imageTableRows(List<DataExplorer2ModelItemDataTableItemDataRow> imageTableRows) {
    this.imageTableRows = imageTableRows;
    return this;
  }

  public DataExplorer2ModelItemDataTable addImageTableRowsItem(DataExplorer2ModelItemDataTableItemDataRow imageTableRowsItem) {
    if (this.imageTableRows == null) {
      this.imageTableRows = new ArrayList<>();
    }
    this.imageTableRows.add(imageTableRowsItem);
    return this;
  }

   /**
   * Get imageTableRows
   * @return imageTableRows
  **/
  @Schema(description = "")
  public List<DataExplorer2ModelItemDataTableItemDataRow> getImageTableRows() {
    return imageTableRows;
  }

  public void setImageTableRows(List<DataExplorer2ModelItemDataTableItemDataRow> imageTableRows) {
    this.imageTableRows = imageTableRows;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DataExplorer2ModelItemDataTable dataExplorer2ModelItemDataTable = (DataExplorer2ModelItemDataTable) o;
    return Objects.equals(this.headers, dataExplorer2ModelItemDataTable.headers) &&
        Objects.equals(this.lookupData, dataExplorer2ModelItemDataTable.lookupData) &&
        Objects.equals(this.rows, dataExplorer2ModelItemDataTable.rows) &&
        Objects.equals(this.itemType, dataExplorer2ModelItemDataTable.itemType) &&
        Objects.equals(this.itemName, dataExplorer2ModelItemDataTable.itemName) &&
        Objects.equals(this.usedMetadatalanguage, dataExplorer2ModelItemDataTable.usedMetadatalanguage) &&
        Objects.equals(this.configuredMetadatalanguage, dataExplorer2ModelItemDataTable.configuredMetadatalanguage) &&
        Objects.equals(this.languageSource, dataExplorer2ModelItemDataTable.languageSource) &&
        Objects.equals(this.providerCount, dataExplorer2ModelItemDataTable.providerCount) &&
        Objects.equals(this.relationTableRows, dataExplorer2ModelItemDataTable.relationTableRows) &&
        Objects.equals(this.imageTableRows, dataExplorer2ModelItemDataTable.imageTableRows);
  }

  @Override
  public int hashCode() {
    return Objects.hash(headers, lookupData, rows, itemType, itemName, usedMetadatalanguage, configuredMetadatalanguage, languageSource, providerCount, relationTableRows, imageTableRows);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DataExplorer2ModelItemDataTable {\n");
    
    sb.append("    headers: ").append(toIndentedString(headers)).append("\n");
    sb.append("    lookupData: ").append(toIndentedString(lookupData)).append("\n");
    sb.append("    rows: ").append(toIndentedString(rows)).append("\n");
    sb.append("    itemType: ").append(toIndentedString(itemType)).append("\n");
    sb.append("    itemName: ").append(toIndentedString(itemName)).append("\n");
    sb.append("    usedMetadatalanguage: ").append(toIndentedString(usedMetadatalanguage)).append("\n");
    sb.append("    configuredMetadatalanguage: ").append(toIndentedString(configuredMetadatalanguage)).append("\n");
    sb.append("    languageSource: ").append(toIndentedString(languageSource)).append("\n");
    sb.append("    providerCount: ").append(toIndentedString(providerCount)).append("\n");
    sb.append("    relationTableRows: ").append(toIndentedString(relationTableRows)).append("\n");
    sb.append("    imageTableRows: ").append(toIndentedString(imageTableRows)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
