/*
 * Emby Server REST API (BETA)
 * 
 */

package embyclient.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import embyclient.model.DataExplorer2ModelEnumsRowContentTypes;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * DataExplorer2ModelItemDataTableItemDataRow
 */


public class DataExplorer2ModelItemDataTableItemDataRow {
  @SerializedName("Caption")
  private String caption = null;

  @SerializedName("IsLocked")
  private Boolean isLocked = null;

  @SerializedName("ContentType")
  private DataExplorer2ModelEnumsRowContentTypes contentType = null;

  @SerializedName("Values")
  private List<Object> values = null;

  public DataExplorer2ModelItemDataTableItemDataRow caption(String caption) {
    this.caption = caption;
    return this;
  }

   /**
   * Get caption
   * @return caption
  **/
  @Schema(description = "")
  public String getCaption() {
    return caption;
  }

  public void setCaption(String caption) {
    this.caption = caption;
  }

  public DataExplorer2ModelItemDataTableItemDataRow isLocked(Boolean isLocked) {
    this.isLocked = isLocked;
    return this;
  }

   /**
   * Get isLocked
   * @return isLocked
  **/
  @Schema(description = "")
  public Boolean isIsLocked() {
    return isLocked;
  }

  public void setIsLocked(Boolean isLocked) {
    this.isLocked = isLocked;
  }

  public DataExplorer2ModelItemDataTableItemDataRow contentType(DataExplorer2ModelEnumsRowContentTypes contentType) {
    this.contentType = contentType;
    return this;
  }

   /**
   * Get contentType
   * @return contentType
  **/
  @Schema(description = "")
  public DataExplorer2ModelEnumsRowContentTypes getContentType() {
    return contentType;
  }

  public void setContentType(DataExplorer2ModelEnumsRowContentTypes contentType) {
    this.contentType = contentType;
  }

  public DataExplorer2ModelItemDataTableItemDataRow values(List<Object> values) {
    this.values = values;
    return this;
  }

  public DataExplorer2ModelItemDataTableItemDataRow addValuesItem(Object valuesItem) {
    if (this.values == null) {
      this.values = new ArrayList<>();
    }
    this.values.add(valuesItem);
    return this;
  }

   /**
   * Get values
   * @return values
  **/
  @Schema(description = "")
  public List<Object> getValues() {
    return values;
  }

  public void setValues(List<Object> values) {
    this.values = values;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DataExplorer2ModelItemDataTableItemDataRow dataExplorer2ModelItemDataTableItemDataRow = (DataExplorer2ModelItemDataTableItemDataRow) o;
    return Objects.equals(this.caption, dataExplorer2ModelItemDataTableItemDataRow.caption) &&
        Objects.equals(this.isLocked, dataExplorer2ModelItemDataTableItemDataRow.isLocked) &&
        Objects.equals(this.contentType, dataExplorer2ModelItemDataTableItemDataRow.contentType) &&
        Objects.equals(this.values, dataExplorer2ModelItemDataTableItemDataRow.values);
  }

  @Override
  public int hashCode() {
    return Objects.hash(caption, isLocked, contentType, values);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DataExplorer2ModelItemDataTableItemDataRow {\n");
    
    sb.append("    caption: ").append(toIndentedString(caption)).append("\n");
    sb.append("    isLocked: ").append(toIndentedString(isLocked)).append("\n");
    sb.append("    contentType: ").append(toIndentedString(contentType)).append("\n");
    sb.append("    values: ").append(toIndentedString(values)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
