/*
 * Emby Server REST API (BETA)
 * 
 */

package embyclient.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * FolderSyncConfigurationSyncAccount
 */


public class FolderSyncConfigurationSyncAccount {
  @SerializedName("Id")
  private String id = null;

  @SerializedName("Name")
  private String name = null;

  @SerializedName("Path")
  private String path = null;

  @SerializedName("EnableAllUsers")
  private Boolean enableAllUsers = null;

  @SerializedName("UserIds")
  private List<String> userIds = null;

  public FolderSyncConfigurationSyncAccount id(String id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @Schema(description = "")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public FolderSyncConfigurationSyncAccount name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @Schema(description = "")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public FolderSyncConfigurationSyncAccount path(String path) {
    this.path = path;
    return this;
  }

   /**
   * Get path
   * @return path
  **/
  @Schema(description = "")
  public String getPath() {
    return path;
  }

  public void setPath(String path) {
    this.path = path;
  }

  public FolderSyncConfigurationSyncAccount enableAllUsers(Boolean enableAllUsers) {
    this.enableAllUsers = enableAllUsers;
    return this;
  }

   /**
   * Get enableAllUsers
   * @return enableAllUsers
  **/
  @Schema(description = "")
  public Boolean isEnableAllUsers() {
    return enableAllUsers;
  }

  public void setEnableAllUsers(Boolean enableAllUsers) {
    this.enableAllUsers = enableAllUsers;
  }

  public FolderSyncConfigurationSyncAccount userIds(List<String> userIds) {
    this.userIds = userIds;
    return this;
  }

  public FolderSyncConfigurationSyncAccount addUserIdsItem(String userIdsItem) {
    if (this.userIds == null) {
      this.userIds = new ArrayList<>();
    }
    this.userIds.add(userIdsItem);
    return this;
  }

   /**
   * Get userIds
   * @return userIds
  **/
  @Schema(description = "")
  public List<String> getUserIds() {
    return userIds;
  }

  public void setUserIds(List<String> userIds) {
    this.userIds = userIds;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FolderSyncConfigurationSyncAccount folderSyncConfigurationSyncAccount = (FolderSyncConfigurationSyncAccount) o;
    return Objects.equals(this.id, folderSyncConfigurationSyncAccount.id) &&
        Objects.equals(this.name, folderSyncConfigurationSyncAccount.name) &&
        Objects.equals(this.path, folderSyncConfigurationSyncAccount.path) &&
        Objects.equals(this.enableAllUsers, folderSyncConfigurationSyncAccount.enableAllUsers) &&
        Objects.equals(this.userIds, folderSyncConfigurationSyncAccount.userIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, path, enableAllUsers, userIds);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FolderSyncConfigurationSyncAccount {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    path: ").append(toIndentedString(path)).append("\n");
    sb.append("    enableAllUsers: ").append(toIndentedString(enableAllUsers)).append("\n");
    sb.append("    userIds: ").append(toIndentedString(userIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
