/*
 * Decompiled with CFR 0.152.
 */
package io.kamel.core.cache;

import androidx.compose.runtime.internal.StabilityInferred;
import io.github.reactivecircus.cache4k.Cache;
import io.kamel.core.cache.Cache;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0001\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u000f\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0010\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0011J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u0015J\u0015\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u0013H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u001a"}, d2={"Lio/kamel/core/cache/LruCache;", "K", "", "V", "Lio/kamel/core/cache/Cache;", "maxSize", "", "<init>", "(I)V", "getMaxSize", "()I", "cache", "Lio/github/reactivecircus/cache4k/Cache;", "size", "getSize", "get", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "set", "", "value", "(Ljava/lang/Object;Ljava/lang/Object;)V", "remove", "", "(Ljava/lang/Object;)Z", "clear", "kamel-core_debug"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LruCache.kt\nio/kamel/core/cache/LruCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,30:1\n1#2:31\n*E\n"})
public final class LruCache<K, V>
implements Cache<K, V> {
    private final int maxSize;
    @NotNull
    private final io.github.reactivecircus.cache4k.Cache<K, V> cache;
    public static final int $stable = 8;

    public LruCache(int maxSize) {
        this.maxSize = maxSize;
        this.cache = Cache.Builder.Companion.invoke().maximumCacheSize((long)this.getMaxSize()).build();
        if (!(this.getMaxSize() >= 0)) {
            boolean bl = false;
            String string2 = "Cache max size must be positive number";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public int getSize() {
        return this.cache.asMap().size();
    }

    @Override
    @Nullable
    public V get(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return (V)this.cache.get(key);
    }

    @Override
    public void set(@NotNull K key, @NotNull V value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.cache.put(key, value);
    }

    @Override
    public boolean remove(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        this.cache.invalidate(key);
        return true;
    }

    @Override
    public void clear() {
        this.cache.invalidateAll();
    }
}

