/*
 * Decompiled with CFR 0.152.
 */
package io.kamel.core.cache.disk;

import androidx.compose.runtime.internal.StabilityInferred;
import io.kamel.core.cache.disk.DiskCacheStorage;
import io.kamel.core.cache.disk.DiskCacheStorageKt;
import io.kamel.core.cache.disk.DiskLruCache;
import io.kamel.core.utils.JvmPlatformKt;
import io.ktor.client.plugins.cache.storage.CacheStorage;
import io.ktor.client.plugins.cache.storage.CachedResponseData;
import io.ktor.http.HeadersBuilder;
import io.ktor.http.HttpProtocolVersion;
import io.ktor.http.HttpStatusCode;
import io.ktor.http.URLUtilsKt;
import io.ktor.http.Url;
import io.ktor.util.StringValues;
import io.ktor.util.StringValuesKt;
import io.ktor.util.date.DateJvmKt;
import io.ktor.util.date.GMTDate;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.ExceptionsKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Dispatchers;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0096@\u00a2\u0006\u0002\u0010\u0018J,\u0010\u0019\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c0\u001bH\u0096@\u00a2\u0006\u0002\u0010\u001dJ\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00170\u001f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0096@\u00a2\u0006\u0002\u0010 J*\u0010!\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c0\u001bH\u0096@\u00a2\u0006\u0002\u0010\u001dJ\u0016\u0010\"\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0096@\u00a2\u0006\u0002\u0010 J\u0010\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006*"}, d2={"Lio/kamel/core/cache/disk/DiskCacheStorage;", "Lio/ktor/client/plugins/cache/storage/CacheStorage;", "fileSystem", "Lokio/FileSystem;", "directory", "Lokio/Path;", "maxSize", "", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "<init>", "(Lokio/FileSystem;Lokio/Path;JLkotlinx/coroutines/CoroutineDispatcher;)V", "diskLruCache", "Lio/kamel/core/cache/disk/DiskLruCache;", "getDiskLruCache", "()Lio/kamel/core/cache/disk/DiskLruCache;", "diskLruCache$delegate", "Lkotlin/Lazy;", "store", "", "url", "Lio/ktor/http/Url;", "data", "Lio/ktor/client/plugins/cache/storage/CachedResponseData;", "(Lio/ktor/http/Url;Lio/ktor/client/plugins/cache/storage/CachedResponseData;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "find", "varyKeys", "", "", "(Lio/ktor/http/Url;Ljava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findAll", "", "(Lio/ktor/http/Url;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "remove", "removeAll", "readCache", "source", "Lokio/BufferedSource;", "writeCache", "channel", "Lokio/BufferedSink;", "cache", "kamel-core_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDiskCacheStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskCacheStorage.kt\nio/kamel/core/cache/disk/DiskCacheStorage\n+ 2 FileSystem.kt\nokio/FileSystem\n+ 3 Okio.kt\nokio/Okio__OkioKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,140:1\n84#2:141\n191#2:142\n95#2:143\n96#2:148\n73#2:178\n74#2:183\n58#3,4:144\n66#3,10:149\n62#3,18:159\n72#3:177\n58#3,4:179\n66#3,10:184\n62#3,3:194\n77#3,3:197\n1#4:200\n*S KotlinDebug\n*F\n+ 1 DiskCacheStorage.kt\nio/kamel/core/cache/disk/DiskCacheStorage\n*L\n45#1:141\n45#1:142\n45#1:143\n45#1:148\n58#1:178\n58#1:183\n45#1:144,4\n45#1:149,10\n45#1:159,18\n58#1:177\n58#1:179,4\n58#1:184,10\n58#1:194,3\n58#1:197,3\n*E\n"})
public final class DiskCacheStorage
implements CacheStorage {
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final Lazy diskLruCache$delegate;
    public static final int $stable = 8;

    public DiskCacheStorage(@NotNull FileSystem fileSystem2, @NotNull Path directory, long maxSize, @NotNull CoroutineDispatcher dispatcher) {
        Intrinsics.checkNotNullParameter((Object)fileSystem2, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        this.fileSystem = fileSystem2;
        this.diskLruCache$delegate = LazyKt.lazy(() -> DiskCacheStorage.diskLruCache_delegate$lambda$0(this, directory, dispatcher, maxSize));
    }

    public /* synthetic */ DiskCacheStorage(FileSystem fileSystem2, Path path, long l, CoroutineDispatcher coroutineDispatcher, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            coroutineDispatcher = JvmPlatformKt.getKamel(Dispatchers.INSTANCE);
        }
        this(fileSystem2, path, l, coroutineDispatcher);
    }

    private final DiskLruCache getDiskLruCache() {
        Lazy lazy = this.diskLruCache$delegate;
        return (DiskLruCache)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public Object store(@NotNull Url url, @NotNull CachedResponseData data, @NotNull Continuation<? super Unit> $completion) {
        DiskLruCache.Editor editor = this.getDiskLruCache().edit(DiskCacheStorageKt.access$hash(url));
        if (editor == null) return Unit.INSTANCE;
        DiskLruCache.Editor editor2 = editor;
        boolean bl = false;
        try {
            Unit unit;
            Throwable thrown$iv$iv;
            block17: {
                void $this$iv;
                FileSystem fileSystem2 = this.fileSystem;
                Path file$iv = editor2.file();
                boolean mustCreate$iv = false;
                boolean bl2 = false;
                Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)$this$iv.sink(file$iv, mustCreate$iv));
                boolean $i$f$use = false;
                thrown$iv$iv = null;
                try {
                    BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
                    boolean bl3 = false;
                    BufferedSink $this$store_u24lambda_u242_u24lambda_u241 = it$iv;
                    boolean bl4 = false;
                    this.writeCache($this$store_u24lambda_u242_u24lambda_u241, data);
                    unit = Unit.INSTANCE;
                }
                catch (Throwable t$iv$iv) {
                    try {
                        thrown$iv$iv = t$iv$iv;
                        unit = null;
                        break block17;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        block18: {
                            try {
                                Closeable closeable = $this$use$iv$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv$iv2) {
                                if (thrown$iv$iv == null) {
                                    thrown$iv$iv = t$iv$iv2;
                                    break block18;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                            }
                        }
                    }
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv$iv) {
                    thrown$iv$iv = t$iv$iv;
                }
            }
            Unit result$iv$iv = unit;
            Throwable throwable = thrown$iv$iv;
            if (throwable != null) {
                throw throwable;
            }
            editor2.commit();
            return Unit.INSTANCE;
        }
        catch (Exception exception) {
            DiskCacheStorageKt.access$abortQuietly(editor2);
            return Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public Object find(@NotNull Url url, @NotNull Map<String, String> varyKeys, @NotNull Continuation<? super CachedResponseData> $completion) {
        DiskLruCache.Snapshot snapshot = this.getDiskLruCache().get(DiskCacheStorageKt.access$hash(url));
        if (snapshot == null) {
            return null;
        }
        Closeable closeable = snapshot;
        Throwable throwable = null;
        try {
            FileSystem fileSystem3;
            DiskLruCache.Snapshot it = (DiskLruCache.Snapshot)closeable;
            boolean bl = false;
            try {
                CachedResponseData cachedResponseData;
                Throwable thrown$iv$iv;
                block23: {
                    void this_$iv;
                    fileSystem3 = this.fileSystem;
                    Path file$iv = it.file();
                    boolean bl2 = false;
                    Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source(file$iv));
                    boolean $i$f$use = false;
                    thrown$iv$iv = null;
                    try {
                        BufferedSource it$iv = (BufferedSource)$this$use$iv$iv;
                        boolean bl3 = false;
                        BufferedSource $this$find_u24lambda_u244_u24lambda_u243 = it$iv;
                        boolean bl4 = false;
                        cachedResponseData = this.readCache($this$find_u24lambda_u244_u24lambda_u243);
                    }
                    catch (Throwable t$iv$iv) {
                        try {
                            thrown$iv$iv = t$iv$iv;
                            cachedResponseData = null;
                            break block23;
                        }
                        catch (Throwable throwable2) {
                            throw throwable2;
                        }
                        finally {
                            block24: {
                                try {
                                    Closeable closeable2 = $this$use$iv$iv;
                                    if (closeable2 != null) {
                                        closeable2.close();
                                    }
                                }
                                catch (Throwable t$iv$iv2) {
                                    if (thrown$iv$iv == null) {
                                        thrown$iv$iv = t$iv$iv2;
                                        break block24;
                                    }
                                    ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                                }
                            }
                        }
                    }
                    try {
                        Closeable closeable3 = $this$use$iv$iv;
                        if (closeable3 != null) {
                            closeable3.close();
                        }
                    }
                    catch (Throwable t$iv$iv) {
                        thrown$iv$iv = t$iv$iv;
                    }
                }
                CachedResponseData result$iv$iv = cachedResponseData;
                Throwable throwable2 = thrown$iv$iv;
                if (throwable2 != null) {
                    throw throwable2;
                }
                fileSystem3 = result$iv$iv;
            }
            catch (Exception exception) {
                fileSystem3 = null;
            }
            FileSystem fileSystem4 = fileSystem3;
            FileSystem fileSystem2 = fileSystem4;
            return fileSystem2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public Object findAll(@NotNull Url url, @NotNull Continuation<? super Set<CachedResponseData>> $completion) {
        if (!($completion instanceof findAll.1)) ** GOTO lbl-1000
        var6_3 = $completion;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ DiskCacheStorage this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.findAll(null, (Continuation<? super Set<CachedResponseData>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)url);
                $continuation.label = 1;
                v0 = this.find(url, MapsKt.emptyMap(), (Continuation<? super CachedResponseData>)$continuation);
                if (v0 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                url = (Url)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                if ((v1 /* !! */  = (CachedResponseData)v0) == null) ** GOTO lbl29
                p0 = v1 /* !! */ ;
                $i$a$-let-DiskCacheStorage$findAll$2 = false;
                v2 = SetsKt.setOf((Object)p0);
                v1 /* !! */  = v2;
                if (v2 != null) ** GOTO lbl30
lbl29:
                // 2 sources

                v1 /* !! */  = SetsKt.emptySet();
lbl30:
                // 2 sources

                return v1 /* !! */ ;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public Object remove(@NotNull Url url, @NotNull Map<String, String> varyKeys, @NotNull Continuation<? super Unit> $completion) {
        this.getDiskLruCache().remove(DiskCacheStorageKt.access$hash(url));
        return Unit.INSTANCE;
    }

    @Nullable
    public Object removeAll(@NotNull Url url, @NotNull Continuation<? super Unit> $completion) {
        this.getDiskLruCache().remove(DiskCacheStorageKt.access$hash(url));
        return Unit.INSTANCE;
    }

    private final CachedResponseData readCache(BufferedSource source) {
        Map map2;
        String string2 = source.readUtf8Line();
        Intrinsics.checkNotNull((Object)string2);
        String url = string2;
        int n = source.readInt();
        String string3 = source.readUtf8Line();
        Intrinsics.checkNotNull((Object)string3);
        HttpStatusCode status = new HttpStatusCode(n, string3);
        String string4 = source.readUtf8Line();
        Intrinsics.checkNotNull((Object)string4);
        HttpProtocolVersion version = HttpProtocolVersion.Companion.parse((CharSequence)string4);
        int headersCount = source.readInt();
        HeadersBuilder headers = new HeadersBuilder(0, 1, null);
        for (int j = 0; j < headersCount; ++j) {
            String value;
            String key;
            Intrinsics.checkNotNull((Object)source.readUtf8Line());
            Intrinsics.checkNotNull((Object)source.readUtf8Line());
            headers.append(key, value);
        }
        GMTDate requestTime = DateJvmKt.GMTDate((Long)source.readLong());
        GMTDate responseTime = DateJvmKt.GMTDate((Long)source.readLong());
        GMTDate expirationTime = DateJvmKt.GMTDate((Long)source.readLong());
        int varyKeysCount = source.readInt();
        Map $this$readCache_u24lambda_u245 = map2 = MapsKt.createMapBuilder();
        boolean bl = false;
        for (int j = 0; j < varyKeysCount; ++j) {
            String value;
            String key;
            Intrinsics.checkNotNull((Object)source.readUtf8Line());
            Intrinsics.checkNotNull((Object)source.readUtf8Line());
            $this$readCache_u24lambda_u245.put(key, value);
        }
        Map varyKeys = MapsKt.build((Map)map2);
        int bodyCount = source.readInt();
        byte[] body = new byte[bodyCount];
        source.readFully(body);
        return new CachedResponseData(URLUtilsKt.Url((String)url), status, requestTime, responseTime, version, expirationTime, headers.build(), varyKeys, body);
    }

    private final void writeCache(BufferedSink channel, CachedResponseData cache) {
        String value;
        String key;
        channel.writeUtf8(cache.getUrl() + "\n");
        channel.writeInt(cache.getStatusCode().getValue());
        channel.writeUtf8(cache.getStatusCode().getDescription() + "\n");
        channel.writeUtf8(cache.getVersion() + "\n");
        List headers = StringValuesKt.flattenEntries((StringValues)((StringValues)cache.getHeaders()));
        channel.writeInt(headers.size());
        for (Pair object : headers) {
            key = (String)object.component1();
            value = (String)object.component2();
            channel.writeUtf8(key + "\n");
            channel.writeUtf8(value + "\n");
        }
        channel.writeLong(cache.getRequestTime().getTimestamp());
        channel.writeLong(cache.getResponseTime().getTimestamp());
        channel.writeLong(cache.getExpires().getTimestamp());
        channel.writeInt(cache.getVaryKeys().size());
        for (Map.Entry entry : cache.getVaryKeys().entrySet()) {
            key = (String)entry.getKey();
            value = (String)entry.getValue();
            channel.writeUtf8(key + "\n");
            channel.writeUtf8(value + "\n");
        }
        channel.writeInt(cache.getBody().length);
        channel.write(cache.getBody());
    }

    private static final DiskLruCache diskLruCache_delegate$lambda$0(DiskCacheStorage this$0, Path $directory, CoroutineDispatcher $dispatcher, long $maxSize) {
        return new DiskLruCache(this$0.fileSystem, $directory, $dispatcher, $maxSize, 0, 0, 48, null);
    }
}

