/*
 * Decompiled with CFR 0.152.
 */
package io.kamel.core.fetcher;

import io.kamel.core.DataSource;
import io.kamel.core.Resource;
import io.kamel.core.config.ResourceConfig;
import io.kamel.core.fetcher.Fetcher;
import io.kamel.core.fetcher.JvmFileFetcherKt;
import io.ktor.http.URLUtilsJvmKt;
import io.ktor.http.Url;
import io.ktor.utils.io.ByteReadChannel;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\"\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"FileUrlFetcher", "Lio/kamel/core/fetcher/Fetcher;", "Lio/ktor/http/Url;", "getFileUrlFetcher", "()Lio/kamel/core/fetcher/Fetcher;", "kamel-core_release"})
public final class FileUrlFetcher_commonJvmKt {
    @NotNull
    private static final Fetcher<Url> FileUrlFetcher = new Fetcher<Url>(){
        private final KClass<Url> inputDataKClass;
        private final DataSource source;
        {
            this.inputDataKClass = Reflection.getOrCreateKotlinClass(Url.class);
            this.source = DataSource.Disk;
        }

        public KClass<Url> getInputDataKClass() {
            return this.inputDataKClass;
        }

        public DataSource getSource() {
            return this.source;
        }

        public boolean isSupported(Url $this$isSupported) {
            Intrinsics.checkNotNullParameter((Object)$this$isSupported, (String)"<this>");
            return Intrinsics.areEqual((Object)$this$isSupported.getProtocol().getName(), (Object)"file");
        }

        public Flow<Resource<ByteReadChannel>> fetch(Url data, ResourceConfig resourceConfig) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)resourceConfig, (String)"resourceConfig");
            return JvmFileFetcherKt.getFileFetcher().fetch(new File(URLUtilsJvmKt.toURI((Url)data)), resourceConfig);
        }
    };

    @NotNull
    public static final Fetcher<Url> getFileUrlFetcher() {
        return FileUrlFetcher;
    }
}

