/*
 * Decompiled with CFR 0.152.
 */
package io.kamel.core.cache;

import io.kamel.core.cache.Cache;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0010\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0011J\u0015\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0014J\u001e\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u0017R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0018"}, d2={"Lio/kamel/core/cache/LruCache;", "K", "V", "Lio/kamel/core/cache/Cache;", "maxSize", "", "(I)V", "cache", "", "getMaxSize", "()I", "size", "getSize", "clear", "", "get", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "remove", "", "(Ljava/lang/Object;)Z", "set", "value", "(Ljava/lang/Object;Ljava/lang/Object;)V", "kamel-core"})
@SourceDebugExtension(value={"SMAP\nJvmLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmLruCache.kt\nio/kamel/core/cache/LruCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,29:1\n1#2:30\n*E\n"})
public final class LruCache<K, V>
implements Cache<K, V> {
    private final int maxSize;
    @NotNull
    private final Map<K, V> cache;

    public LruCache(int maxSize) {
        this.maxSize = maxSize;
        int n = this.getMaxSize();
        this.cache = new LinkedHashMap<K, V>(this, n){
            final /* synthetic */ LruCache<K, V> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, 0.75f, true);
            }

            protected boolean removeEldestEntry(@Nullable Map.Entry<K, V> eldest) {
                return this.size() > this.this$0.getMaxSize();
            }
        };
        if (!(this.getMaxSize() >= 0)) {
            boolean bl = false;
            String string = "Cache max size must be positive number";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public int getSize() {
        return this.cache.size();
    }

    @Override
    @Nullable
    public V get(K key) {
        return this.cache.get(key);
    }

    @Override
    public void set(K key, V value) {
        this.cache.put(key, value);
    }

    @Override
    public boolean remove(K key) {
        return this.cache.remove(key) != null;
    }

    @Override
    public void clear() {
        this.cache.clear();
    }
}

