/*
 * Decompiled with CFR 0.152.
 */
package io.kamel.core.cache.disk;

import io.kamel.core.cache.disk.DiskLruCache;
import io.kamel.core.cache.disk.FaultHidingSink;
import io.kamel.core.utils.FileSystemKt;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.SupervisorKt;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.FileSystem;
import okio.ForwardingFileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000}\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011*\u0001\u0014\b\u0000\u0018\u0000 C2\u00020\u00012\u00060\u0002j\u0002`\u0003:\u0004CDEFB9\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000fJ\b\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020'H\u0016J\u001c\u0010)\u001a\u00020'2\n\u0010*\u001a\u00060+R\u00020\u00002\u0006\u0010,\u001a\u00020\u0013H\u0002J\b\u0010-\u001a\u00020'H\u0002J\u0014\u0010.\u001a\b\u0018\u00010+R\u00020\u00002\u0006\u0010/\u001a\u00020\u001fJ\u0006\u00100\u001a\u00020'J\u0014\u00101\u001a\b\u0018\u000102R\u00020\u00002\u0006\u0010/\u001a\u00020\u001fJ\b\u00103\u001a\u00020'H\u0002J\b\u00104\u001a\u00020\u0013H\u0002J\b\u00105\u001a\u000206H\u0002J\b\u00107\u001a\u00020\u001cH\u0002J\b\u00108\u001a\u00020'H\u0002J\b\u00109\u001a\u00020'H\u0002J\u0010\u0010:\u001a\u00020'2\u0006\u0010;\u001a\u00020\u001fH\u0002J\u000e\u0010<\u001a\u00020\u00132\u0006\u0010/\u001a\u00020\u001fJ\u0014\u0010=\u001a\u00020\u00132\n\u0010>\u001a\u00060 R\u00020\u0000H\u0002J\b\u0010?\u001a\u00020\u0013H\u0002J\u0006\u0010%\u001a\u00020\u000bJ\b\u0010@\u001a\u00020'H\u0002J\u0010\u0010A\u001a\u00020'2\u0006\u0010/\u001a\u00020\u001fH\u0002J\b\u0010B\u001a\u00020'H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R2\u0010\u001d\u001a&\u0012\u0004\u0012\u00020\u001f\u0012\b\u0012\u00060 R\u00020\u00000\u001ej\u0012\u0012\u0004\u0012\u00020\u001f\u0012\b\u0012\u00060 R\u00020\u0000`!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lio/kamel/core/cache/disk/DiskLruCache;", "Ljava/lang/AutoCloseable;", "", "Lkotlinx/coroutines/internal/SynchronizedObject;", "fileSystem", "Lokio/FileSystem;", "directory", "Lokio/Path;", "cleanupDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "maxSize", "", "appVersion", "", "valueCount", "(Lokio/FileSystem;Lokio/Path;Lkotlinx/coroutines/CoroutineDispatcher;JII)V", "cleanupScope", "Lkotlinx/coroutines/CoroutineScope;", "closed", "", "io/kamel/core/cache/disk/DiskLruCache$fileSystem$1", "Lio/kamel/core/cache/disk/DiskLruCache$fileSystem$1;", "hasJournalErrors", "initialized", "journalFile", "journalFileBackup", "journalFileTmp", "journalWriter", "Lokio/BufferedSink;", "lruEntries", "Ljava/util/LinkedHashMap;", "", "Lio/kamel/core/cache/disk/DiskLruCache$Entry;", "Lkotlin/collections/LinkedHashMap;", "mostRecentRebuildFailed", "mostRecentTrimFailed", "operationsSinceRewrite", "size", "checkNotClosed", "", "close", "completeEdit", "editor", "Lio/kamel/core/cache/disk/DiskLruCache$Editor;", "success", "delete", "edit", "key", "evictAll", "get", "Lio/kamel/core/cache/disk/DiskLruCache$Snapshot;", "initialize", "journalRewriteRequired", "launchCleanup", "Lkotlinx/coroutines/Job;", "newJournalWriter", "processJournal", "readJournal", "readJournalLine", "line", "remove", "removeEntry", "entry", "removeOldestEntry", "trimToSize", "validateKey", "writeJournal", "Companion", "Editor", "Entry", "Snapshot", "kamel-core"})
@SourceDebugExtension(value={"SMAP\nDiskLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskLruCache.kt\nio/kamel/core/cache/disk/DiskLruCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Synchronized.common.kt\nkotlinx/coroutines/internal/Synchronized_commonKt\n+ 4 Synchronized.kt\nkotlinx/coroutines/internal/SynchronizedKt\n+ 5 Okio.kt\nokio/Okio__OkioKt\n+ 6 FileSystem.kt\nokio/FileSystem\n+ 7 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 8 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,865:1\n1#2:866\n28#3,4:867\n28#3,4:901\n28#3,4:941\n28#3,4:946\n28#3,4:951\n28#3,4:956\n28#3,4:961\n28#3,4:970\n20#4:871\n20#4:905\n20#4:945\n20#4:950\n20#4:955\n20#4:960\n20#4:965\n20#4:974\n66#5:872\n52#5,5:874\n60#5,10:880\n57#5,2:890\n71#5,2:892\n52#5,5:909\n60#5,10:915\n57#5,16:925\n67#6:873\n68#6:879\n80#6:906\n165#6:907\n81#6:908\n82#6:914\n372#7,7:894\n37#8,2:966\n37#8,2:968\n*S KotlinDebug\n*F\n+ 1 DiskLruCache.kt\nio/kamel/core/cache/disk/DiskLruCache\n*L\n168#1:867,4\n328#1:901,4\n373#1:941,4\n396#1:946,4\n452#1:951,4\n539#1:956,4\n585#1:961,4\n648#1:970,4\n168#1:871\n328#1:905\n373#1:945\n396#1:950\n452#1:955\n539#1:960\n585#1:965\n648#1:974\n214#1:872\n214#1:874,5\n214#1:880,10\n214#1:890,2\n214#1:892,2\n331#1:909,5\n331#1:915,10\n331#1:925,16\n214#1:873\n214#1:879\n331#1:906\n331#1:907\n331#1:908\n331#1:914\n278#1:894,7\n592#1:966,2\n639#1:968,2\n*E\n"})
public final class DiskLruCache
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path directory;
    private final long maxSize;
    private final int appVersion;
    private final int valueCount;
    @NotNull
    private final Path journalFile;
    @NotNull
    private final Path journalFileTmp;
    @NotNull
    private final Path journalFileBackup;
    @NotNull
    private final LinkedHashMap<String, Entry> lruEntries;
    @NotNull
    private final CoroutineScope cleanupScope;
    private long size;
    private int operationsSinceRewrite;
    @Nullable
    private BufferedSink journalWriter;
    private boolean hasJournalErrors;
    private boolean initialized;
    private boolean closed;
    private boolean mostRecentTrimFailed;
    private boolean mostRecentRebuildFailed;
    @NotNull
    private final fileSystem.1 fileSystem;
    @NotNull
    public static final String JOURNAL_FILE = "journal";
    @NotNull
    public static final String JOURNAL_FILE_TMP = "journal.tmp";
    @NotNull
    public static final String JOURNAL_FILE_BACKUP = "journal.bkp";
    @NotNull
    public static final String MAGIC = "libcore.io.DiskLruCache";
    @NotNull
    public static final String VERSION = "1";
    @NotNull
    private static final String CLEAN = "CLEAN";
    @NotNull
    private static final String DIRTY = "DIRTY";
    @NotNull
    private static final String REMOVE = "REMOVE";
    @NotNull
    private static final String READ = "READ";
    @NotNull
    private static final Regex LEGAL_KEY_PATTERN = new Regex("[a-z0-9_-]{1,120}");

    public DiskLruCache(@NotNull FileSystem fileSystem2, @NotNull Path directory, @NotNull CoroutineDispatcher cleanupDispatcher, long maxSize, int appVersion, int valueCount) {
        Intrinsics.checkNotNullParameter((Object)fileSystem2, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)cleanupDispatcher, (String)"cleanupDispatcher");
        this.directory = directory;
        this.maxSize = maxSize;
        this.appVersion = appVersion;
        this.valueCount = valueCount;
        if (!(this.maxSize > 0L)) {
            boolean $i$a$-require-DiskLruCache$32 = false;
            String $i$a$-require-DiskLruCache$32 = "maxSize <= 0";
            throw new IllegalArgumentException($i$a$-require-DiskLruCache$32.toString());
        }
        if (!(this.valueCount > 0)) {
            boolean bl = false;
            String string = "valueCount <= 0";
            throw new IllegalArgumentException(string.toString());
        }
        this.journalFile = this.directory.resolve(JOURNAL_FILE);
        this.journalFileTmp = this.directory.resolve(JOURNAL_FILE_TMP);
        this.journalFileBackup = this.directory.resolve(JOURNAL_FILE_BACKUP);
        this.lruEntries = new LinkedHashMap(0, 0.75f);
        this.cleanupScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)cleanupDispatcher));
        this.fileSystem = new ForwardingFileSystem(fileSystem2){

            @NotNull
            public Sink sink(@NotNull Path file, boolean mustCreate) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    Path path = file.parent();
                    if (path == null) break block0;
                    Path p0 = path;
                    boolean bl = false;
                    this.createDirectories(p0);
                }
                return super.sink(file, mustCreate);
            }
        };
    }

    public /* synthetic */ DiskLruCache(FileSystem fileSystem2, Path path, CoroutineDispatcher coroutineDispatcher, long l, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x10) != 0) {
            n = 1;
        }
        if ((n3 & 0x20) != 0) {
            n2 = 1;
        }
        this(fileSystem2, path, coroutineDispatcher, l, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void initialize() {
        boolean $i$f$synchronized = false;
        boolean $i$f$synchronizedImpl = false;
        DiskLruCache diskLruCache2 = this;
        synchronized (diskLruCache2) {
            boolean bl = false;
            if (this.initialized) {
                return;
            }
            this.fileSystem.delete(this.journalFileTmp);
            if (this.fileSystem.exists(this.journalFileBackup)) {
                if (this.fileSystem.exists(this.journalFile)) {
                    this.fileSystem.delete(this.journalFileBackup);
                } else {
                    this.fileSystem.atomicMove(this.journalFileBackup, this.journalFile);
                }
            }
            if (this.fileSystem.exists(this.journalFile)) {
                try {
                    this.readJournal();
                    this.processJournal();
                    this.initialized = true;
                    return;
                }
                catch (IOException iOException) {
                    try {
                        this.delete();
                    }
                    finally {
                        this.closed = false;
                    }
                }
            }
            this.writeJournal();
            this.initialized = true;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void readJournal() {
        Throwable thrown$iv$iv;
        Unit result$iv$iv;
        block20: {
            void this_$iv;
            FileSystem fileSystem2 = (FileSystem)this.fileSystem;
            Path file$iv = this.journalFile;
            boolean bl = false;
            Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source(file$iv));
            boolean $i$f$use = false;
            result$iv$iv = null;
            thrown$iv$iv = null;
            try {
                BufferedSource it$iv = (BufferedSource)$this$use$iv$iv;
                boolean bl2 = false;
                BufferedSource $this$readJournal_u24lambda_u243 = it$iv;
                boolean bl3 = false;
                String magic = $this$readJournal_u24lambda_u243.readUtf8LineStrict();
                String version = $this$readJournal_u24lambda_u243.readUtf8LineStrict();
                String appVersionString = $this$readJournal_u24lambda_u243.readUtf8LineStrict();
                String valueCountString = $this$readJournal_u24lambda_u243.readUtf8LineStrict();
                String blank = $this$readJournal_u24lambda_u243.readUtf8LineStrict();
                if (!Intrinsics.areEqual((Object)MAGIC, (Object)magic)) throw new IOException("unexpected journal header: [" + magic + ", " + version + ", " + appVersionString + ", " + valueCountString + ", " + blank + ']');
                if (!Intrinsics.areEqual((Object)VERSION, (Object)version)) throw new IOException("unexpected journal header: [" + magic + ", " + version + ", " + appVersionString + ", " + valueCountString + ", " + blank + ']');
                if (!Intrinsics.areEqual((Object)String.valueOf(this.appVersion), (Object)appVersionString)) throw new IOException("unexpected journal header: [" + magic + ", " + version + ", " + appVersionString + ", " + valueCountString + ", " + blank + ']');
                if (!Intrinsics.areEqual((Object)String.valueOf(this.valueCount), (Object)valueCountString)) throw new IOException("unexpected journal header: [" + magic + ", " + version + ", " + appVersionString + ", " + valueCountString + ", " + blank + ']');
                if (((CharSequence)blank).length() > 0) {
                    throw new IOException("unexpected journal header: [" + magic + ", " + version + ", " + appVersionString + ", " + valueCountString + ", " + blank + ']');
                }
                int lineCount = 0;
                try {
                    while (true) {
                        this.readJournalLine($this$readJournal_u24lambda_u243.readUtf8LineStrict());
                        ++lineCount;
                    }
                }
                catch (EOFException _) {
                    this.operationsSinceRewrite = lineCount - this.lruEntries.size();
                    if (!$this$readJournal_u24lambda_u243.exhausted()) {
                        this.writeJournal();
                    } else {
                        this.journalWriter = this.newJournalWriter();
                    }
                    result$iv$iv = Unit.INSTANCE;
                    try {
                        Closeable closeable = $this$use$iv$iv;
                        if (closeable != null) {
                            closeable.close();
                        }
                    }
                    catch (Throwable t$iv$iv) {
                        thrown$iv$iv = t$iv$iv;
                    }
                }
            }
            catch (Throwable t$iv$iv) {
                try {
                    thrown$iv$iv = t$iv$iv;
                }
                catch (Throwable throwable) {
                    try {
                        Closeable closeable = $this$use$iv$iv;
                        if (closeable == null) throw throwable;
                        closeable.close();
                        throw throwable;
                    }
                    catch (Throwable t$iv$iv2) {
                        thrown$iv$iv = t$iv$iv2;
                    }
                    throw throwable;
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv$iv3) {
                    if (thrown$iv$iv == null) {
                        thrown$iv$iv = t$iv$iv3;
                        break block20;
                    }
                    ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv3);
                }
            }
        }
        Throwable throwable = thrown$iv$iv;
        if (throwable != null) {
            throw throwable;
        }
        Intrinsics.checkNotNull(result$iv$iv);
    }

    private final BufferedSink newJournalWriter() {
        Sink fileSink = this.fileSystem.appendingSink(this.journalFile);
        FaultHidingSink faultHidingSink2 = new FaultHidingSink(fileSink, (Function1<? super IOException, Unit>)((Function1)new Function1<IOException, Unit>(this){
            final /* synthetic */ DiskLruCache this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull IOException it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                DiskLruCache.access$setHasJournalErrors$p(this.this$0, true);
            }
        }));
        return Okio.buffer((Sink)faultHidingSink2);
    }

    private final void readJournalLine(String line) {
        Object object;
        int firstSpace = StringsKt.indexOf$default((CharSequence)line, (char)' ', (int)0, (boolean)false, (int)6, null);
        if (firstSpace == -1) {
            throw new IOException("unexpected journal line: " + line);
        }
        int keyBegin = firstSpace + 1;
        int secondSpace = StringsKt.indexOf$default((CharSequence)line, (char)' ', (int)keyBegin, (boolean)false, (int)4, null);
        String key = null;
        if (secondSpace == -1) {
            String string = line.substring(keyBegin);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            key = string;
            if (firstSpace == 6 && StringsKt.startsWith$default((String)line, (String)REMOVE, (boolean)false, (int)2, null)) {
                this.lruEntries.remove(key);
                return;
            }
        } else {
            String string = line.substring(keyBegin, secondSpace);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            key = string;
        }
        Map $this$getOrPut$iv = this.lruEntries;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key);
        if (value$iv == null) {
            boolean bl = false;
            Entry answer$iv = new Entry(key);
            $this$getOrPut$iv.put(key, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        Entry entry = (Entry)object;
        if (secondSpace != -1 && firstSpace == 5 && StringsKt.startsWith$default((String)line, (String)CLEAN, (boolean)false, (int)2, null)) {
            String string = line.substring(secondSpace + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            char[] cArray = new char[]{' '};
            List parts = StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            entry.setReadable(true);
            entry.setCurrentEditor(null);
            entry.setLengths(parts);
        } else if (secondSpace == -1 && firstSpace == 5 && StringsKt.startsWith$default((String)line, (String)DIRTY, (boolean)false, (int)2, null)) {
            entry.setCurrentEditor(new Editor(entry));
        } else if (secondSpace != -1 || firstSpace != 4 || !StringsKt.startsWith$default((String)line, (String)READ, (boolean)false, (int)2, null)) {
            throw new IOException("unexpected journal line: " + line);
        }
    }

    private final void processJournal() {
        long size = 0L;
        Iterator<Entry> iterator = this.lruEntries.values().iterator();
        while (iterator.hasNext()) {
            int i;
            int n;
            Entry entry;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            if (entry.getCurrentEditor() == null) {
                n = this.valueCount;
                for (i = 0; i < n; ++i) {
                    size += entry.getLengths()[i];
                }
                continue;
            }
            entry.setCurrentEditor(null);
            n = this.valueCount;
            for (i = 0; i < n; ++i) {
                Path path = entry.getCleanFiles().get(i);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                this.fileSystem.delete(path);
                Path path2 = entry.getDirtyFiles().get(i);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                this.fileSystem.delete(path2);
            }
            iterator.remove();
        }
        this.size = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     */
    private final void writeJournal() {
        boolean $i$f$synchronized = false;
        boolean $i$f$synchronizedImpl = false;
        DiskLruCache diskLruCache2 = this;
        synchronized (diskLruCache2) {
            Throwable thrown$iv$iv;
            Unit result$iv$iv;
            block23: {
                void $this$iv;
                boolean bl = false;
                BufferedSink bufferedSink = this.journalWriter;
                if (bufferedSink != null) {
                    bufferedSink.close();
                }
                FileSystem fileSystem2 = (FileSystem)this.fileSystem;
                Path file$iv = this.journalFileTmp;
                boolean mustCreate$iv = false;
                boolean bl2 = false;
                Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)$this$iv.sink(file$iv, mustCreate$iv));
                boolean $i$f$use = false;
                result$iv$iv = null;
                thrown$iv$iv = null;
                BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
                boolean bl3 = false;
                BufferedSink $this$writeJournal_u24lambda_u246_u24lambda_u245 = it$iv;
                boolean bl4 = false;
                $this$writeJournal_u24lambda_u246_u24lambda_u245.writeUtf8(MAGIC).writeByte(10);
                $this$writeJournal_u24lambda_u246_u24lambda_u245.writeUtf8(VERSION).writeByte(10);
                $this$writeJournal_u24lambda_u246_u24lambda_u245.writeDecimalLong((long)this.appVersion).writeByte(10);
                $this$writeJournal_u24lambda_u246_u24lambda_u245.writeDecimalLong((long)this.valueCount).writeByte(10);
                $this$writeJournal_u24lambda_u246_u24lambda_u245.writeByte(10);
                for (Entry entry : this.lruEntries.values()) {
                    if (entry.getCurrentEditor() != null) {
                        $this$writeJournal_u24lambda_u246_u24lambda_u245.writeUtf8(DIRTY);
                        $this$writeJournal_u24lambda_u246_u24lambda_u245.writeByte(32);
                        $this$writeJournal_u24lambda_u246_u24lambda_u245.writeUtf8(entry.getKey());
                        $this$writeJournal_u24lambda_u246_u24lambda_u245.writeByte(10);
                        continue;
                    }
                    $this$writeJournal_u24lambda_u246_u24lambda_u245.writeUtf8(CLEAN);
                    $this$writeJournal_u24lambda_u246_u24lambda_u245.writeByte(32);
                    $this$writeJournal_u24lambda_u246_u24lambda_u245.writeUtf8(entry.getKey());
                    entry.writeLengths($this$writeJournal_u24lambda_u246_u24lambda_u245);
                    $this$writeJournal_u24lambda_u246_u24lambda_u245.writeByte(10);
                }
                result$iv$iv = Unit.INSTANCE;
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                    break block23;
                }
                catch (Throwable t$iv$iv) {
                    thrown$iv$iv = t$iv$iv;
                }
                break block23;
                catch (Throwable t$iv$iv) {
                    try {
                        thrown$iv$iv = t$iv$iv;
                    }
                    catch (Throwable throwable) {
                        try {
                            Closeable closeable = $this$use$iv$iv;
                            if (closeable != null) {
                                closeable.close();
                            }
                        }
                        catch (Throwable t$iv$iv2) {
                            thrown$iv$iv = t$iv$iv2;
                        }
                        throw throwable;
                    }
                    try {
                        Closeable closeable = $this$use$iv$iv;
                        if (closeable != null) {
                            closeable.close();
                        }
                    }
                    catch (Throwable t$iv$iv3) {
                        if (thrown$iv$iv == null) {
                            thrown$iv$iv = t$iv$iv3;
                            break block23;
                        }
                        ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv3);
                    }
                }
            }
            Throwable throwable = thrown$iv$iv;
            if (throwable != null) {
                throw throwable;
            }
            Intrinsics.checkNotNull(result$iv$iv);
            if (this.fileSystem.exists(this.journalFile)) {
                this.fileSystem.atomicMove(this.journalFile, this.journalFileBackup);
                this.fileSystem.atomicMove(this.journalFileTmp, this.journalFile);
                this.fileSystem.delete(this.journalFileBackup);
            } else {
                this.fileSystem.atomicMove(this.journalFileTmp, this.journalFile);
            }
            this.journalWriter = this.newJournalWriter();
            this.operationsSinceRewrite = 0;
            this.hasJournalErrors = false;
            this.mostRecentRebuildFailed = false;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Snapshot get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        boolean $i$f$synchronized = false;
        boolean $i$f$synchronizedImpl = false;
        DiskLruCache diskLruCache2 = this;
        synchronized (diskLruCache2) {
            BufferedSink bufferedSink;
            Object object;
            block5: {
                boolean bl = false;
                this.checkNotClosed();
                this.validateKey(key);
                this.initialize();
                object = this.lruEntries.get(key);
                if (object != null && (object = ((Entry)object).snapshot()) != null) break block5;
                Snapshot snapshot = null;
                return snapshot;
            }
            Object snapshot = object;
            int n = this.operationsSinceRewrite;
            this.operationsSinceRewrite = n + 1;
            BufferedSink bufferedSink2 = this.journalWriter;
            Intrinsics.checkNotNull((Object)bufferedSink2);
            BufferedSink $this$get_u24lambda_u248_u24lambda_u247 = bufferedSink = bufferedSink2;
            boolean bl = false;
            $this$get_u24lambda_u248_u24lambda_u247.writeUtf8(READ);
            $this$get_u24lambda_u248_u24lambda_u247.writeByte(32);
            $this$get_u24lambda_u248_u24lambda_u247.writeUtf8(key);
            $this$get_u24lambda_u248_u24lambda_u247.writeByte(10);
            if (this.journalRewriteRequired()) {
                this.launchCleanup();
            }
            Object object2 = snapshot;
            return object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Editor edit(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        boolean $i$f$synchronized = false;
        boolean $i$f$synchronizedImpl = false;
        DiskLruCache diskLruCache2 = this;
        synchronized (diskLruCache2) {
            Entry entry;
            block11: {
                BufferedSink bufferedSink;
                block10: {
                    block9: {
                        block8: {
                            boolean bl = false;
                            this.checkNotClosed();
                            this.validateKey(key);
                            this.initialize();
                            Entry entry2 = entry = this.lruEntries.get(key);
                            if ((entry2 != null ? entry2.getCurrentEditor() : null) == null) break block8;
                            Editor editor = null;
                            return editor;
                        }
                        if (entry == null || entry.getLockingSnapshotCount() == 0) break block9;
                        Editor editor = null;
                        return editor;
                    }
                    if (!this.mostRecentTrimFailed && !this.mostRecentRebuildFailed) break block10;
                    this.launchCleanup();
                    Editor editor = null;
                    return editor;
                }
                BufferedSink bufferedSink2 = this.journalWriter;
                Intrinsics.checkNotNull((Object)bufferedSink2);
                BufferedSink $this$edit_u24lambda_u2410_u24lambda_u249 = bufferedSink = bufferedSink2;
                boolean bl = false;
                $this$edit_u24lambda_u2410_u24lambda_u249.writeUtf8(DIRTY);
                $this$edit_u24lambda_u2410_u24lambda_u249.writeByte(32);
                $this$edit_u24lambda_u2410_u24lambda_u249.writeUtf8(key);
                $this$edit_u24lambda_u2410_u24lambda_u249.writeByte(10);
                $this$edit_u24lambda_u2410_u24lambda_u249.flush();
                if (!this.hasJournalErrors) break block11;
                Editor editor = null;
                return editor;
            }
            if (entry == null) {
                entry = new Entry(key);
                ((Map)this.lruEntries).put(key, entry);
            }
            Editor editor = new Editor(entry);
            entry.setCurrentEditor(editor);
            Editor editor2 = editor;
            return editor2;
        }
    }

    public final long size() {
        this.initialize();
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void completeEdit(Editor editor, boolean success) {
        boolean $i$f$synchronized = false;
        boolean $i$f$synchronizedImpl = false;
        DiskLruCache diskLruCache2 = this;
        synchronized (diskLruCache2) {
            BufferedSink bufferedSink;
            int i;
            int n;
            boolean bl = false;
            Entry entry = editor.getEntry();
            if (!Intrinsics.areEqual((Object)entry.getCurrentEditor(), (Object)editor)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            if (success && !entry.getZombie()) {
                n = this.valueCount;
                for (i = 0; i < n; ++i) {
                    if (!editor.getWritten()[i]) continue;
                    Path path = entry.getDirtyFiles().get(i);
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                    if (this.fileSystem.exists(path)) continue;
                    editor.abort();
                    return;
                }
                n = this.valueCount;
                for (i = 0; i < n; ++i) {
                    long newLength;
                    Path clean;
                    Path dirty;
                    Intrinsics.checkNotNullExpressionValue((Object)entry.getDirtyFiles().get(i), (String)"get(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)entry.getCleanFiles().get(i), (String)"get(...)");
                    if (this.fileSystem.exists(dirty)) {
                        this.fileSystem.atomicMove(dirty, clean);
                    } else {
                        FileSystem fileSystem2 = (FileSystem)this.fileSystem;
                        Path path = entry.getCleanFiles().get(i);
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                        FileSystemKt.createFile(fileSystem2, path);
                    }
                    long oldLength = entry.getLengths()[i];
                    Long l = this.fileSystem.metadata(clean).getSize();
                    entry.getLengths()[i] = newLength = l != null ? l : 0L;
                    this.size = this.size - oldLength + newLength;
                }
            } else {
                n = this.valueCount;
                for (i = 0; i < n; ++i) {
                    Path path = entry.getDirtyFiles().get(i);
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                    this.fileSystem.delete(path);
                }
            }
            entry.setCurrentEditor(null);
            if (entry.getZombie()) {
                this.removeEntry(entry);
                return;
            }
            int n2 = this.operationsSinceRewrite;
            this.operationsSinceRewrite = n2 + 1;
            BufferedSink bufferedSink2 = this.journalWriter;
            Intrinsics.checkNotNull((Object)bufferedSink2);
            BufferedSink $this$completeEdit_u24lambda_u2412_u24lambda_u2411 = bufferedSink = bufferedSink2;
            boolean bl2 = false;
            if (success || entry.getReadable()) {
                entry.setReadable(true);
                $this$completeEdit_u24lambda_u2412_u24lambda_u2411.writeUtf8(CLEAN);
                $this$completeEdit_u24lambda_u2412_u24lambda_u2411.writeByte(32);
                $this$completeEdit_u24lambda_u2412_u24lambda_u2411.writeUtf8(entry.getKey());
                entry.writeLengths($this$completeEdit_u24lambda_u2412_u24lambda_u2411);
                $this$completeEdit_u24lambda_u2412_u24lambda_u2411.writeByte(10);
            } else {
                this.lruEntries.remove(entry.getKey());
                $this$completeEdit_u24lambda_u2412_u24lambda_u2411.writeUtf8(REMOVE);
                $this$completeEdit_u24lambda_u2412_u24lambda_u2411.writeByte(32);
                $this$completeEdit_u24lambda_u2412_u24lambda_u2411.writeUtf8(entry.getKey());
                $this$completeEdit_u24lambda_u2412_u24lambda_u2411.writeByte(10);
            }
            $this$completeEdit_u24lambda_u2412_u24lambda_u2411.flush();
            if (this.size > this.maxSize || this.journalRewriteRequired()) {
                this.launchCleanup();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final boolean journalRewriteRequired() {
        return this.operationsSinceRewrite >= 2000;
    }

    public final boolean remove(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.checkNotClosed();
        this.validateKey(key);
        this.initialize();
        Entry entry = this.lruEntries.get(key);
        if (entry == null) {
            return false;
        }
        Entry entry2 = entry;
        boolean removed = this.removeEntry(entry2);
        if (removed && this.size <= this.maxSize) {
            this.mostRecentTrimFailed = false;
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean removeEntry(Entry entry) {
        boolean $i$f$synchronized = false;
        boolean $i$f$synchronizedImpl = false;
        DiskLruCache diskLruCache2 = this;
        synchronized (diskLruCache2) {
            block9: {
                boolean bl = false;
                if (entry.getLockingSnapshotCount() > 0) {
                    BufferedSink bufferedSink = this.journalWriter;
                    if (bufferedSink != null) {
                        BufferedSink bufferedSink2;
                        BufferedSink $this$removeEntry_u24lambda_u2415_u24lambda_u2413 = bufferedSink2 = bufferedSink;
                        boolean bl2 = false;
                        $this$removeEntry_u24lambda_u2415_u24lambda_u2413.writeUtf8(DIRTY);
                        $this$removeEntry_u24lambda_u2415_u24lambda_u2413.writeByte(32);
                        $this$removeEntry_u24lambda_u2415_u24lambda_u2413.writeUtf8(entry.getKey());
                        $this$removeEntry_u24lambda_u2415_u24lambda_u2413.writeByte(10);
                        $this$removeEntry_u24lambda_u2415_u24lambda_u2413.flush();
                    }
                }
                if (entry.getLockingSnapshotCount() <= 0 && entry.getCurrentEditor() == null) break block9;
                entry.setZombie(true);
                boolean bl3 = true;
                return bl3;
            }
            int n = this.valueCount;
            for (int i = 0; i < n; ++i) {
                Path path = entry.getCleanFiles().get(i);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                this.fileSystem.delete(path);
                this.size -= entry.getLengths()[i];
                entry.getLengths()[i] = 0L;
            }
            int n2 = this.operationsSinceRewrite;
            this.operationsSinceRewrite = n2 + 1;
            BufferedSink bufferedSink = this.journalWriter;
            if (bufferedSink != null) {
                BufferedSink bufferedSink3;
                BufferedSink $this$removeEntry_u24lambda_u2415_u24lambda_u2414 = bufferedSink3 = bufferedSink;
                boolean bl = false;
                $this$removeEntry_u24lambda_u2415_u24lambda_u2414.writeUtf8(REMOVE);
                $this$removeEntry_u24lambda_u2415_u24lambda_u2414.writeByte(32);
                $this$removeEntry_u24lambda_u2415_u24lambda_u2414.writeUtf8(entry.getKey());
                $this$removeEntry_u24lambda_u2415_u24lambda_u2414.writeByte(10);
            }
            this.lruEntries.remove(entry.getKey());
            if (this.journalRewriteRequired()) {
                this.launchCleanup();
            }
            boolean bl = true;
            return bl;
        }
    }

    private final void checkNotClosed() {
        if (!(!this.closed)) {
            boolean bl = false;
            String string = "cache is closed";
            throw new IllegalStateException(string.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        boolean $i$f$synchronized = false;
        boolean $i$f$synchronizedImpl = false;
        DiskLruCache diskLruCache2 = this;
        synchronized (diskLruCache2) {
            boolean bl = false;
            if (!this.initialized || this.closed) {
                this.closed = true;
            } else {
                Collection<Entry> collection = this.lruEntries.values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                Collection<Entry> $this$toTypedArray$iv = collection;
                boolean $i$f$toTypedArray = false;
                Collection<Entry> thisCollection$iv = $this$toTypedArray$iv;
                for (Entry entry : thisCollection$iv.toArray(new Entry[0])) {
                    Editor editor = entry.getCurrentEditor();
                    if (editor == null) continue;
                    editor.detach();
                }
                this.trimToSize();
                CoroutineScopeKt.cancel$default((CoroutineScope)this.cleanupScope, null, (int)1, null);
                BufferedSink bufferedSink = this.journalWriter;
                Intrinsics.checkNotNull((Object)bufferedSink);
                bufferedSink.close();
                this.journalWriter = null;
                this.closed = true;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void trimToSize() {
        while (this.size > this.maxSize) {
            if (this.removeOldestEntry()) continue;
            return;
        }
        this.mostRecentTrimFailed = false;
    }

    private final boolean removeOldestEntry() {
        for (Entry toEvict : this.lruEntries.values()) {
            if (toEvict.getZombie()) continue;
            Intrinsics.checkNotNull((Object)toEvict);
            this.removeEntry(toEvict);
            return true;
        }
        return false;
    }

    private final void delete() {
        this.close();
        FileSystemKt.deleteContents((FileSystem)this.fileSystem, this.directory);
    }

    public final void evictAll() {
        this.initialize();
        Collection<Entry> collection = this.lruEntries.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Collection<Entry> $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection<Entry> thisCollection$iv = $this$toTypedArray$iv;
        for (Entry entry : thisCollection$iv.toArray(new Entry[0])) {
            Intrinsics.checkNotNull((Object)entry);
            this.removeEntry(entry);
        }
        this.mostRecentTrimFailed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Job launchCleanup() {
        Job job;
        boolean $i$f$synchronized = false;
        boolean $i$f$synchronizedImpl = false;
        DiskLruCache diskLruCache2 = this;
        synchronized (diskLruCache2) {
            boolean bl = false;
            job = BuildersKt.launch$default((CoroutineScope)this.cleanupScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ DiskLruCache this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            if (!DiskLruCache.access$getInitialized$p(this.this$0) || DiskLruCache.access$getClosed$p(this.this$0)) {
                                return Unit.INSTANCE;
                            }
                            try {
                                DiskLruCache.access$trimToSize(this.this$0);
                            }
                            catch (IOException iOException) {
                                DiskLruCache.access$setMostRecentTrimFailed$p(this.this$0, true);
                            }
                            try {
                                if (DiskLruCache.access$journalRewriteRequired(this.this$0)) {
                                    DiskLruCache.access$writeJournal(this.this$0);
                                }
                            }
                            catch (IOException iOException) {
                                DiskLruCache.access$setMostRecentRebuildFailed$p(this.this$0, true);
                                DiskLruCache.access$setJournalWriter$p(this.this$0, Okio.buffer((Sink)Okio.blackhole()));
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
        return job;
    }

    private final void validateKey(String key) {
        if (!LEGAL_KEY_PATTERN.matches((CharSequence)key)) {
            boolean bl = false;
            String string = "keys must match regex [a-z0-9_-]{1,120}: \"" + key + '\"';
            throw new IllegalArgumentException(string.toString());
        }
    }

    public static final /* synthetic */ void access$setHasJournalErrors$p(DiskLruCache $this, boolean bl) {
        $this.hasJournalErrors = bl;
    }

    public static final /* synthetic */ boolean access$getInitialized$p(DiskLruCache $this) {
        return $this.initialized;
    }

    public static final /* synthetic */ boolean access$getClosed$p(DiskLruCache $this) {
        return $this.closed;
    }

    public static final /* synthetic */ void access$trimToSize(DiskLruCache $this) {
        $this.trimToSize();
    }

    public static final /* synthetic */ void access$setMostRecentTrimFailed$p(DiskLruCache $this, boolean bl) {
        $this.mostRecentTrimFailed = bl;
    }

    public static final /* synthetic */ boolean access$journalRewriteRequired(DiskLruCache $this) {
        return $this.journalRewriteRequired();
    }

    public static final /* synthetic */ void access$writeJournal(DiskLruCache $this) {
        $this.writeJournal();
    }

    public static final /* synthetic */ void access$setMostRecentRebuildFailed$p(DiskLruCache $this, boolean bl) {
        $this.mostRecentRebuildFailed = bl;
    }

    public static final /* synthetic */ void access$setJournalWriter$p(DiskLruCache $this, BufferedSink bufferedSink) {
        $this.journalWriter = bufferedSink;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/kamel/core/cache/disk/DiskLruCache$Companion;", "", "()V", "CLEAN", "", "DIRTY", "JOURNAL_FILE", "JOURNAL_FILE_BACKUP", "JOURNAL_FILE_TMP", "LEGAL_KEY_PATTERN", "Lkotlin/text/Regex;", "MAGIC", "READ", "REMOVE", "VERSION", "kamel-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0018\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0011\u0012\n\u0010\u0003\u001a\u00060\u0004R\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0010J\f\u0010\u0012\u001a\b\u0018\u00010\u0013R\u00020\u0005J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\bH\u0002J\u0006\u0010\u0016\u001a\u00020\u0010J\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0003\u001a\u00060\u0004R\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lio/kamel/core/cache/disk/DiskLruCache$Editor;", "", "Lkotlinx/coroutines/internal/SynchronizedObject;", "entry", "Lio/kamel/core/cache/disk/DiskLruCache$Entry;", "Lio/kamel/core/cache/disk/DiskLruCache;", "(Lio/kamel/core/cache/disk/DiskLruCache;Lio/kamel/core/cache/disk/DiskLruCache$Entry;)V", "closed", "", "getEntry", "()Lio/kamel/core/cache/disk/DiskLruCache$Entry;", "written", "", "getWritten", "()[Z", "abort", "", "commit", "commitAndGet", "Lio/kamel/core/cache/disk/DiskLruCache$Snapshot;", "complete", "success", "detach", "file", "Lokio/Path;", "index", "", "kamel-core"})
    @SourceDebugExtension(value={"SMAP\nDiskLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskLruCache.kt\nio/kamel/core/cache/disk/DiskLruCache$Editor\n+ 2 Synchronized.common.kt\nkotlinx/coroutines/internal/Synchronized_commonKt\n+ 3 Synchronized.kt\nkotlinx/coroutines/internal/SynchronizedKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,865:1\n28#2,4:866\n28#2,4:872\n28#2,4:877\n20#3:870\n20#3:876\n20#3:881\n1#4:871\n*S KotlinDebug\n*F\n+ 1 DiskLruCache.kt\nio/kamel/core/cache/disk/DiskLruCache$Editor\n*L\n720#1:866,4\n747#1:872,4\n761#1:877,4\n720#1:870\n747#1:876\n761#1:881\n*E\n"})
    public final class Editor {
        @NotNull
        private final Entry entry;
        private boolean closed;
        @NotNull
        private final boolean[] written;

        public Editor(Entry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            this.entry = entry;
            this.written = new boolean[DiskLruCache.this.valueCount];
        }

        @NotNull
        public final Entry getEntry() {
            return this.entry;
        }

        @NotNull
        public final boolean[] getWritten() {
            return this.written;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Path file(int index) {
            DiskLruCache diskLruCache2 = DiskLruCache.this;
            boolean $i$f$synchronized = false;
            boolean $i$f$synchronizedImpl = false;
            Editor editor = this;
            synchronized (editor) {
                boolean bl = false;
                if (!(!this.closed)) {
                    boolean bl2 = false;
                    String string = "editor is closed";
                    throw new IllegalStateException(string.toString());
                }
                this.written[index] = true;
                Path path = this.entry.getDirtyFiles().get(index);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                Path path2 = path;
                fileSystem.1 var7_9 = diskLruCache2.fileSystem;
                Path p0 = path2;
                boolean bl3 = false;
                FileSystemKt.createFile((FileSystem)var7_9, p0);
                Path path3 = path2;
                return path3;
            }
        }

        @NotNull
        public final Path file() {
            return this.file(0);
        }

        public final void detach() {
            if (Intrinsics.areEqual((Object)this.entry.getCurrentEditor(), (Object)this)) {
                this.entry.setZombie(true);
            }
        }

        public final void commit() {
            this.complete(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final Snapshot commitAndGet() {
            DiskLruCache diskLruCache2 = DiskLruCache.this;
            boolean $i$f$synchronized = false;
            boolean $i$f$synchronizedImpl = false;
            Editor editor = this;
            synchronized (editor) {
                boolean bl = false;
                this.commit();
                Snapshot snapshot = diskLruCache2.get(this.entry.getKey());
                return snapshot;
            }
        }

        public final void abort() {
            this.complete(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void complete(boolean success) {
            DiskLruCache diskLruCache2 = DiskLruCache.this;
            boolean $i$f$synchronized = false;
            boolean $i$f$synchronizedImpl = false;
            Editor editor = this;
            synchronized (editor) {
                boolean bl = false;
                if (!(!this.closed)) {
                    boolean bl2 = false;
                    String string = "editor is closed";
                    throw new IllegalStateException(string.toString());
                }
                if (Intrinsics.areEqual((Object)this.entry.getCurrentEditor(), (Object)this)) {
                    diskLruCache2.completeEdit(this, success);
                }
                this.closed = true;
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00030,J\f\u0010-\u001a\b\u0018\u00010.R\u00020\rJ\u000e\u0010/\u001a\u00020*2\u0006\u00100\u001a\u000201R!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR \u0010\u000b\u001a\b\u0018\u00010\fR\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R!\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010#\"\u0004\b(\u0010%\u00a8\u00062"}, d2={"Lio/kamel/core/cache/disk/DiskLruCache$Entry;", "", "key", "", "(Lio/kamel/core/cache/disk/DiskLruCache;Ljava/lang/String;)V", "cleanFiles", "Ljava/util/ArrayList;", "Lokio/Path;", "Lkotlin/collections/ArrayList;", "getCleanFiles", "()Ljava/util/ArrayList;", "currentEditor", "Lio/kamel/core/cache/disk/DiskLruCache$Editor;", "Lio/kamel/core/cache/disk/DiskLruCache;", "getCurrentEditor", "()Lio/kamel/core/cache/disk/DiskLruCache$Editor;", "setCurrentEditor", "(Lio/kamel/core/cache/disk/DiskLruCache$Editor;)V", "dirtyFiles", "getDirtyFiles", "getKey", "()Ljava/lang/String;", "lengths", "", "getLengths", "()[J", "lockingSnapshotCount", "", "getLockingSnapshotCount", "()I", "setLockingSnapshotCount", "(I)V", "readable", "", "getReadable", "()Z", "setReadable", "(Z)V", "zombie", "getZombie", "setZombie", "setLengths", "", "strings", "", "snapshot", "Lio/kamel/core/cache/disk/DiskLruCache$Snapshot;", "writeLengths", "writer", "Lokio/BufferedSink;", "kamel-core"})
    @SourceDebugExtension(value={"SMAP\nDiskLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskLruCache.kt\nio/kamel/core/cache/disk/DiskLruCache$Entry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,865:1\n1855#2,2:866\n*S KotlinDebug\n*F\n+ 1 DiskLruCache.kt\nio/kamel/core/cache/disk/DiskLruCache$Entry\n*L\n837#1:866,2\n*E\n"})
    public final class Entry {
        @NotNull
        private final String key;
        @NotNull
        private final long[] lengths;
        @NotNull
        private final ArrayList<Path> cleanFiles;
        @NotNull
        private final ArrayList<Path> dirtyFiles;
        private boolean readable;
        private boolean zombie;
        @Nullable
        private Editor currentEditor;
        private int lockingSnapshotCount;

        public Entry(String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.key = key;
            this.lengths = new long[DiskLruCache.this.valueCount];
            this.cleanFiles = new ArrayList(DiskLruCache.this.valueCount);
            this.dirtyFiles = new ArrayList(DiskLruCache.this.valueCount);
            StringBuilder fileBuilder = new StringBuilder(this.key).append('.');
            int truncateTo = fileBuilder.length();
            int n = DiskLruCache.this.valueCount;
            for (int i = 0; i < n; ++i) {
                fileBuilder.append(i);
                Collection collection = this.cleanFiles;
                Path path = DiskLruCache.this.directory;
                String string = fileBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                collection.add(path.resolve(string));
                fileBuilder.append(".tmp");
                collection = this.dirtyFiles;
                Path path2 = DiskLruCache.this.directory;
                String string2 = fileBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                collection.add(path2.resolve(string2));
                fileBuilder.setLength(truncateTo);
            }
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @NotNull
        public final long[] getLengths() {
            return this.lengths;
        }

        @NotNull
        public final ArrayList<Path> getCleanFiles() {
            return this.cleanFiles;
        }

        @NotNull
        public final ArrayList<Path> getDirtyFiles() {
            return this.dirtyFiles;
        }

        public final boolean getReadable() {
            return this.readable;
        }

        public final void setReadable(boolean bl) {
            this.readable = bl;
        }

        public final boolean getZombie() {
            return this.zombie;
        }

        public final void setZombie(boolean bl) {
            this.zombie = bl;
        }

        @Nullable
        public final Editor getCurrentEditor() {
            return this.currentEditor;
        }

        public final void setCurrentEditor(@Nullable Editor editor) {
            this.currentEditor = editor;
        }

        public final int getLockingSnapshotCount() {
            return this.lockingSnapshotCount;
        }

        public final void setLockingSnapshotCount(int n) {
            this.lockingSnapshotCount = n;
        }

        public final void setLengths(@NotNull List<String> strings) {
            Intrinsics.checkNotNullParameter(strings, (String)"strings");
            if (strings.size() != DiskLruCache.this.valueCount) {
                throw new IOException("unexpected journal line: " + strings);
            }
            try {
                int n = strings.size();
                for (int i = 0; i < n; ++i) {
                    this.lengths[i] = Long.parseLong(strings.get(i));
                }
            }
            catch (NumberFormatException _) {
                throw new IOException("unexpected journal line: " + strings);
            }
        }

        public final void writeLengths(@NotNull BufferedSink writer) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            for (long length : this.lengths) {
                writer.writeByte(32).writeDecimalLong(length);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final Snapshot snapshot() {
            void $this$forEach$iv;
            if (!this.readable) {
                return null;
            }
            if (this.currentEditor != null || this.zombie) {
                return null;
            }
            Iterable iterable = this.cleanFiles;
            DiskLruCache diskLruCache2 = DiskLruCache.this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Path file = (Path)element$iv;
                boolean bl = false;
                if (diskLruCache2.fileSystem.exists(file)) continue;
                try {
                    diskLruCache2.removeEntry(this);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
            int n = this.lockingSnapshotCount;
            this.lockingSnapshotCount = n + 1;
            return new Snapshot(this);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0011\u0012\n\u0010\u0003\u001a\u00060\u0004R\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\f\u0010\u000b\u001a\b\u0018\u00010\fR\u00020\u0005J\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0003\u001a\u00060\u0004R\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/kamel/core/cache/disk/DiskLruCache$Snapshot;", "Ljava/io/Closeable;", "Lio/ktor/utils/io/core/Closeable;", "entry", "Lio/kamel/core/cache/disk/DiskLruCache$Entry;", "Lio/kamel/core/cache/disk/DiskLruCache;", "(Lio/kamel/core/cache/disk/DiskLruCache;Lio/kamel/core/cache/disk/DiskLruCache$Entry;)V", "closed", "", "close", "", "closeAndEdit", "Lio/kamel/core/cache/disk/DiskLruCache$Editor;", "file", "Lokio/Path;", "index", "", "kamel-core"})
    @SourceDebugExtension(value={"SMAP\nDiskLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskLruCache.kt\nio/kamel/core/cache/disk/DiskLruCache$Snapshot\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Synchronized.common.kt\nkotlinx/coroutines/internal/Synchronized_commonKt\n+ 4 Synchronized.kt\nkotlinx/coroutines/internal/SynchronizedKt\n*L\n1#1,865:1\n1#2:866\n28#3,4:867\n28#3,4:872\n20#4:871\n20#4:876\n*S KotlinDebug\n*F\n+ 1 DiskLruCache.kt\nio/kamel/core/cache/disk/DiskLruCache$Snapshot\n*L\n685#1:867,4\n700#1:872,4\n685#1:871\n700#1:876\n*E\n"})
    public final class Snapshot
    implements Closeable {
        @NotNull
        private final Entry entry;
        private boolean closed;

        public Snapshot(Entry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            this.entry = entry;
        }

        private final Path file(int index) {
            if (!(!this.closed)) {
                boolean bl = false;
                String string = "snapshot is closed";
                throw new IllegalStateException(string.toString());
            }
            Path path = this.entry.getCleanFiles().get(index);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            return path;
        }

        @NotNull
        public final Path file() {
            return this.file(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void close() {
            void lock$iv;
            DiskLruCache diskLruCache2 = DiskLruCache.this;
            DiskLruCache diskLruCache3 = DiskLruCache.this;
            boolean $i$f$synchronized = false;
            boolean $i$f$synchronizedImpl = false;
            void var5_5 = lock$iv;
            synchronized (var5_5) {
                boolean bl = false;
                if (!this.closed) {
                    this.closed = true;
                    BuildersKt.launch$default((CoroutineScope)diskLruCache3.cleanupScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, diskLruCache3, null){
                        int label;
                        final /* synthetic */ Snapshot this$0;
                        final /* synthetic */ DiskLruCache this$1;
                        {
                            this.this$0 = $receiver;
                            this.this$1 = $receiver2;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    Entry entry = Snapshot.access$getEntry$p(this.this$0);
                                    int n = entry.getLockingSnapshotCount();
                                    entry.setLockingSnapshotCount(n + -1);
                                    if (Snapshot.access$getEntry$p(this.this$0).getLockingSnapshotCount() == 0 && Snapshot.access$getEntry$p(this.this$0).getZombie()) {
                                        BuildersKt.launch$default((CoroutineScope)DiskLruCache.access$getCleanupScope$p(this.this$1), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$1, this.this$0, null){
                                            int label;
                                            final /* synthetic */ DiskLruCache this$0;
                                            final /* synthetic */ Snapshot this$1;
                                            {
                                                this.this$0 = $receiver;
                                                this.this$1 = $receiver2;
                                                super(2, $completion);
                                            }

                                            @Nullable
                                            public final Object invokeSuspend(@NotNull Object object) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)object);
                                                        DiskLruCache.access$removeEntry(this.this$0, Snapshot.access$getEntry$p(this.this$1));
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            @NotNull
                                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            @Nullable
                                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (int)3, null);
                                    }
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Nullable
        public final Editor closeAndEdit() {
            void lock$iv;
            DiskLruCache diskLruCache2 = DiskLruCache.this;
            DiskLruCache diskLruCache3 = DiskLruCache.this;
            boolean $i$f$synchronized = false;
            boolean $i$f$synchronizedImpl = false;
            void var5_5 = lock$iv;
            synchronized (var5_5) {
                boolean bl = false;
                this.close();
                Editor editor = diskLruCache3.edit(this.entry.getKey());
                return editor;
            }
        }

        public static final /* synthetic */ Entry access$getEntry$p(Snapshot $this) {
            return $this.entry;
        }
    }
}

