/*
 * Decompiled with CFR 0.152.
 */
package io.kamel.core.utils;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u0001*\u00060\u0002j\u0002`\u0003H\u0000\u001a\u0014\u0010\u0004\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0014\u0010\b\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0000\u00a8\u0006\n"}, d2={"closeQuietly", "", "Ljava/io/Closeable;", "Lokio/Closeable;", "createFile", "Lokio/FileSystem;", "file", "Lokio/Path;", "deleteContents", "directory", "kamel-core"})
public final class FileSystemKt {
    public static final void closeQuietly(@NotNull Closeable $this$closeQuietly) {
        Intrinsics.checkNotNullParameter((Object)$this$closeQuietly, (String)"<this>");
        try {
            $this$closeQuietly.close();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public static final void createFile(@NotNull FileSystem $this$createFile, @NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)$this$createFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!$this$createFile.exists(file)) {
            FileSystemKt.closeQuietly((Closeable)$this$createFile.sink(file));
        }
    }

    public static final void deleteContents(@NotNull FileSystem $this$deleteContents, @NotNull Path directory) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$deleteContents, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        IOException exception = null;
        try {
            list = $this$deleteContents.list(directory);
        }
        catch (FileNotFoundException _) {
            return;
        }
        List files = list;
        for (Path file : files) {
            try {
                if ($this$deleteContents.metadata(file).isDirectory()) {
                    FileSystemKt.deleteContents($this$deleteContents, file);
                }
                $this$deleteContents.delete(file);
            }
            catch (IOException e) {
                if (exception != null) continue;
                exception = e;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }
}

