/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.ide.eclipse.core.resource;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.avalon.ide.eclipse.core.tools.EclipseDirectoryHelper;
import org.apache.avalon.ide.eclipse.merlin.core.MerlinDeveloperCore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class EclipseResource {
    private IProject project;
    private Vector classpathEntries = new Vector();
    static /* synthetic */ Class class$org$apache$avalon$ide$eclipse$merlin$core$MerlinDeveloperCore;

    public EclipseResource(IProject project) {
        this.project = project;
    }

    public static String getQualifiedClassName(IResource pResource) {
        String qualifiedClassName = null;
        IProject project = pResource.getProject();
        try {
            IJavaProject proj = JavaCore.create((IProject)project);
            String filePathName = pResource.getLocation().toString();
            if (pResource.getFileExtension().toLowerCase().equals("class")) {
                String outputPath = proj.getOutputLocation().toString();
                String projectPath = project.getLocation().toString();
                outputPath = projectPath + outputPath.substring(project.getName().length());
                qualifiedClassName = filePathName.substring(outputPath.length(), filePathName.length() - 6);
                qualifiedClassName = qualifiedClassName.replace('/', '.');
                return qualifiedClassName;
            }
            IPackageFragmentRoot[] roots = proj.getPackageFragmentRoots();
            String projectPath = project.getLocation().toString();
            String sourcePath = null;
            for (int i = 0; roots.length > i && (roots[i].isArchive() || !(sourcePath = projectPath + "/" + roots[i].getElementName()).equals(filePathName.substring(0, sourcePath.length()))); ++i) {
            }
            qualifiedClassName = filePathName.substring(sourcePath.length() + 1, filePathName.length() - 5);
            qualifiedClassName = qualifiedClassName.replace('/', '.');
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return qualifiedClassName;
    }

    public String[] getSourcePaths() throws Exception {
        ArrayList<String> sourcePath = new ArrayList<String>();
        String projectPath = this.project.getLocation().toString();
        IJavaProject javaProject = JavaCore.create((IProject)this.project);
        IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
        for (int i = 0; roots.length > i; ++i) {
            if (roots[i].isArchive()) continue;
            sourcePath.add(projectPath + "/" + roots[i].getElementName());
        }
        return sourcePath.toArray(new String[sourcePath.size()]);
    }

    public void addUuidProperty(String className, boolean b) {
        try {
            IJavaProject proj = JavaCore.create((IProject)this.project);
            IType type = proj.findType(className);
            this.addUuidField(type, b);
            this.addUuidAccessor(type, b);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addUuidAccessor(IType type, boolean b) throws Exception {
        IMethod method = type.getMethod("getUuid", new String[0]);
        if (b && !method.exists()) {
            type.createMethod(this.getGetUuidMethodSource(), null, false, null);
        }
        if (!b && method.exists()) {
            method.delete(true, null);
        }
        String[] str = new String[]{"QString;"};
        method = type.getMethod("setUuid", str);
        if (b && !method.exists()) {
            type.createMethod(this.getSetUuidMethodSource(), null, false, null);
        }
        if (!b && method.exists()) {
            method.delete(true, null);
        }
    }

    private String getGetUuidMethodSource() {
        StringBuffer buf = new StringBuffer();
        buf.append("    /**\n");
        buf.append("     * @uuid. Get the unique object identifier.\n");
        buf.append("     */\n");
        buf.append("    public String getUuid(){\n\n");
        buf.append("    \treturn uuid;\n");
        buf.append("    }\n\n");
        return buf.toString();
    }

    private String getSetUuidMethodSource() {
        StringBuffer buf = new StringBuffer();
        buf.append("    /**\n");
        buf.append("     * @uuid. Set the unique object identifier.\n");
        buf.append("     */\n");
        buf.append("    public void setUuid(String uuid){\n\n");
        buf.append("    \tthis.uuid = uuid;\n");
        buf.append("    }\n\n");
        return buf.toString();
    }

    private void addUuidField(IType type, boolean b) throws Exception {
        IField field = type.getField("uuid");
        if (b && !field.exists()) {
            type.createField(this.getUuidFieldSource(), null, false, null);
        }
        if (!b && field.exists()) {
            field.delete(true, null);
        }
    }

    private String getUuidFieldSource() {
        StringBuffer buf = new StringBuffer();
        buf.append("    // The uuid is used to store a unique object identifier. **\n");
        buf.append("    private String uuid;\n\n");
        return buf.toString();
    }

    public static URLClassLoader getProjectClassLoader(IResource file) {
        URL[] urls = null;
        try {
            urls = new URL[]{new URL("file:/" + EclipseDirectoryHelper.getOutputPath(file) + "/")};
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        URLClassLoader cl = new URLClassLoader(urls, (class$org$apache$avalon$ide$eclipse$merlin$core$MerlinDeveloperCore == null ? (class$org$apache$avalon$ide$eclipse$merlin$core$MerlinDeveloperCore = EclipseResource.class$("org.apache.avalon.ide.eclipse.merlin.core.MerlinDeveloperCore")) : class$org$apache$avalon$ide$eclipse$merlin$core$MerlinDeveloperCore).getClassLoader());
        return cl;
    }

    public static IProject createMerlinProject(String projectName, String nature) throws InvocationTargetException, InterruptedException {
        IProject project;
        try {
            IWorkspaceRoot root = MerlinDeveloperCore.getWorkspace().getRoot();
            project = root.getProject(projectName);
            if (!project.exists()) {
                project.create(null);
            }
            if (!project.isOpen()) {
                project.open(null);
            }
            IProjectDescription description = project.getDescription();
            String[] natureIds = new String[]{"org.eclipse.jdt.core.javanature", nature};
            description.setLocation(null);
            description.setNatureIds(natureIds);
            project.setDescription(description, null);
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
        return project;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

