/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.ide.eclipse.core.resource;

import java.io.File;
import java.io.IOException;
import java.io.StringBufferInputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import org.apache.avalon.ide.eclipse.core.resource.EclipseResource;
import org.eclipse.core.resources.IProject;
import xjavadoc.SourceSet;
import xjavadoc.XClass;
import xjavadoc.XJavaDoc;
import xjavadoc.XTag;
import xjavadoc.filesystem.AbstractFile;
import xjavadoc.filesystem.FileSourceSet;
import xjavadoc.filesystem.XJavadocFile;

public class JavaDocResource {
    private XClass xClass;
    private static JavaDocResource[] docCache;

    public JavaDocResource(String qualifiedClassName, String filePathName) {
        XJavaDoc xDoc = new XJavaDoc();
        xDoc.setUseNodeParser(true);
        xDoc.addAbstractFile(qualifiedClassName, (AbstractFile)new XJavadocFile(new File(filePathName)));
        this.xClass = xDoc.getXClass(qualifiedClassName);
    }

    public JavaDocResource(XClass clazz) {
        this.xClass = clazz;
    }

    public static JavaDocResource[] getJavaDocResources(IProject project) {
        EclipseResource eclipse = new EclipseResource(project);
        XJavaDoc xDoc = new XJavaDoc();
        xDoc.setUseNodeParser(true);
        ArrayList<JavaDocResource> infoList = new ArrayList<JavaDocResource>();
        try {
            String[] sourcePaths = eclipse.getSourcePaths();
            for (int i = 0; sourcePaths.length > i; ++i) {
                FileSourceSet set = new FileSourceSet(new File(sourcePaths[i]));
                xDoc.addSourceSet((SourceSet)set);
            }
            Iterator it = xDoc.getSourceClasses().iterator();
            while (it.hasNext()) {
                JavaDocResource java = new JavaDocResource((XClass)it.next());
                infoList.add(java);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        docCache = infoList.toArray(new JavaDocResource[infoList.size()]);
        return docCache;
    }

    public static JavaDocResource getJavaDocResource(String qualifiedClassName) {
        if (docCache == null) {
            return null;
        }
        for (int i = 0; docCache.length > i; ++i) {
            if (!docCache[i].getQualifiedName().equals(qualifiedClassName)) continue;
            return docCache[i];
        }
        return null;
    }

    public void setPersistent(boolean b) {
        XTag tag = this.xClass.getDoc().getTag("persistent");
        if (b && tag == null) {
            this.xClass.getDoc().addTag("persistent", "");
        }
        if (!b && tag != null) {
            this.xClass.getDoc().removeTag(tag);
        }
    }

    public boolean isPersistent() {
        XClass sClass;
        XClass clazz = this.xClass;
        if (this.isClassPersistent(clazz)) {
            return true;
        }
        while (!(sClass = clazz.getSuperclass()).getName().equals("Object")) {
            if (this.isClassPersistent(sClass)) {
                return this.isClassPersistent(sClass);
            }
            clazz = sClass;
        }
        return this.isClassPersistent(clazz);
    }

    public boolean isClassPersistent(XClass xClazz) {
        if (xClazz.getDoc().getTag("persistent") != null) {
            return true;
        }
        try {
            XTag tag = xClazz.getDoc().getTag("uml");
            if (tag != null) {
                String stereotype = tag.getValue();
                Properties prop = new Properties();
                prop.load(new StringBufferInputStream(stereotype));
                stereotype = (String)((Hashtable)prop).get("stereotypes");
                if (stereotype == null) {
                    return false;
                }
                String[] array = this.stringToArray(stereotype);
                for (int j = 0; array.length > j; ++j) {
                    if (!array[j].equals("persistent")) continue;
                    return true;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    private String[] stringToArray(String pStereotype) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuffer buf = new StringBuffer(pStereotype);
        boolean open = false;
        StringBuffer out = new StringBuffer();
        for (int i = 0; buf.length() > i; ++i) {
            char ch = buf.charAt(i);
            if (ch == '{' || ch == '}') continue;
            if (ch == '\"' && !open) {
                open = true;
                out = new StringBuffer();
                continue;
            }
            if (ch == '\"' && open) {
                open = false;
                result.add(out.toString());
                continue;
            }
            if (!open) continue;
            out.append(ch);
        }
        return result.toArray(new String[result.size()]);
    }

    public String getQualifiedName() {
        return this.xClass.getQualifiedName();
    }

    public void save() {
        try {
            this.xClass.save(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Object getAttribute(String string) {
        XClass sClass;
        XClass clazz = this.xClass;
        while (!(sClass = clazz.getSuperclass()).getName().equals("Object")) {
            if (sClass.getField(string) != null) {
                return sClass.getField(string);
            }
            clazz = sClass;
        }
        return clazz.getField(string);
    }
}

