/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.ide.eclipse.core.resource;

import java.lang.reflect.InvocationTargetException;
import org.apache.avalon.ide.eclipse.core.resource.AbstractResourceManager;
import org.apache.avalon.ide.eclipse.core.resource.EclipseResource;
import org.apache.avalon.ide.eclipse.core.resource.TemplateResource;
import org.apache.avalon.ide.eclipse.core.resource.XMLResource;
import org.apache.avalon.ide.eclipse.core.tools.ClassNameAnalyzer;
import org.apache.avalon.ide.eclipse.core.tools.DynProjectParam;
import org.apache.avalon.ide.eclipse.core.tools.EclipseDirectoryHelper;
import org.apache.avalon.ide.eclipse.core.xmlmodel.Directory;
import org.apache.avalon.ide.eclipse.core.xmlmodel.ProjectModel;
import org.apache.avalon.ide.eclipse.core.xmlmodel.ProjectModelConfiguration;
import org.apache.avalon.ide.eclipse.core.xmlmodel.Template;
import org.apache.avalon.ide.eclipse.merlin.core.MerlinDeveloperCore;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;

public class ProjectResourceManager
extends AbstractResourceManager {
    private String pluginId;

    public ProjectResourceManager(ProjectModel model, DynProjectParam param, String callingPluginId, String nature) {
        this.pluginId = callingPluginId;
        try {
            this.setProject(EclipseResource.createMerlinProject(param.getProjectName(), nature));
            this.setTemplateResource(new TemplateResource(this.getProject()));
            this.createProjectResources(model, param);
            this.getProject().refreshLocal(2, null);
        }
        catch (InvocationTargetException e) {
            MerlinDeveloperCore.log(e, "InvocationTargetException while creating project resources");
        }
        catch (InterruptedException e) {
            MerlinDeveloperCore.log(e, "InterruptedException while creating project resources");
        }
        catch (CoreException e) {
            MerlinDeveloperCore.log(e, "CoreException while creating project resources");
        }
    }

    public ProjectResourceManager(IProject project) {
        super(project);
    }

    public String getPluginId() {
        return this.pluginId;
    }

    private void createProjectResources(ProjectModel wizardMeta, DynProjectParam param) {
        EclipseDirectoryHelper helper = new EclipseDirectoryHelper(this.getProject());
        this.getTemplateResource().setTemplateSourcePath(this.getPluginPathName() + "templates/");
        this.getTemplateResource().setParameter(param);
        for (int i = 0; wizardMeta.getDirectories().size() > i; ++i) {
            Directory dir = (Directory)wizardMeta.getDirectories().get(i);
            helper.createDirectory(dir.getName(), dir.isSource());
            for (int y = 0; dir.getTemplates().size() > y; ++y) {
                Template templ = (Template)dir.getTemplates().get(y);
                if (templ.getName() == null) continue;
                String className = TemplateResource.replaceParam(templ.getFileName(), param);
                ClassNameAnalyzer cna = new ClassNameAnalyzer();
                cna.setFullClassName(className);
                helper.createDirectory(dir.getName() + "/" + cna.getPath(), false);
                String dest = helper.getFullPathName(dir.getName());
                dest = dest + "/" + cna.getPath() + cna.getFileName();
                this.getTemplateResource().createTemplate(dest, templ.getName());
            }
        }
        helper.setClasspath();
    }

    private String getPluginPathName() {
        return EclipseDirectoryHelper.getPluginLocation(this.pluginId).toString();
    }

    public static ProjectModelConfiguration getProjectModelConfiguration(String fileName, String pluginId) {
        XMLResource xml = new XMLResource();
        xml.setPluginId(pluginId);
        xml.setFileName(fileName);
        return ProjectModelConfiguration.newInstance(xml);
    }

    public void addBuilder(String builderID) {
        try {
            IProjectDescription desc = this.getProject().getDescription();
            ICommand[] commands = desc.getBuildSpec();
            boolean found = false;
            for (int i = 0; i < commands.length; ++i) {
                if (!commands[i].getBuilderName().equals(builderID)) continue;
                found = true;
                break;
            }
            if (!found) {
                ICommand command = desc.newCommand();
                command.setBuilderName(builderID);
                ICommand[] newCommands = new ICommand[commands.length + 1];
                System.arraycopy(commands, 0, newCommands, 1, commands.length);
                newCommands[0] = command;
                desc.setBuildSpec(newCommands);
                this.getProject().setDescription(desc, null);
            }
        }
        catch (CoreException e) {
            MerlinDeveloperCore.log(e, "Error while setting the builder commands");
        }
    }
}

