/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.ide.eclipse.core.resource;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.apache.avalon.ide.eclipse.merlin.core.MerlinDeveloperCore;

public class SystemResource {
    public static void copyFile(File in, File out) throws Exception {
        FileOutputStream copy;
        FileInputStream source;
        boolean force = true;
        try {
            source = new FileInputStream(in);
        }
        catch (FileNotFoundException e) {
            MerlinDeveloperCore.log(e, "Can't find file \"" + in.getName() + "\".");
            return;
        }
        File file = out;
        if (file.exists() && !force) {
            MerlinDeveloperCore.log(null, "Output file exists.  Use the -f option to replace it.");
            return;
        }
        try {
            copy = new FileOutputStream(out);
        }
        catch (IOException e) {
            System.out.println("Can't open output file \"" + out.getName() + "\".");
            return;
        }
        int byteCount = 0;
        try {
            int data;
            while ((data = ((InputStream)source).read()) >= 0) {
                ((OutputStream)copy).write(data);
                ++byteCount;
            }
            ((InputStream)source).close();
            ((OutputStream)copy).close();
        }
        catch (Exception e) {
            MerlinDeveloperCore.log(e, "Error occured while copying.  " + byteCount + " bytes copied.");
        }
    }

    public static String getFileContents(String fileName) {
        StringBuffer buf = new StringBuffer();
        try {
            String line;
            FileInputStream in = new FileInputStream(fileName);
            InputStreamReader file = new InputStreamReader(in);
            BufferedReader reader = new BufferedReader(file);
            while ((line = reader.readLine()) != null) {
                buf.append(line);
            }
            file.close();
        }
        catch (FileNotFoundException e) {
            MerlinDeveloperCore.log(e, "");
        }
        catch (IOException e) {
            MerlinDeveloperCore.log(e, "");
        }
        return buf.toString();
    }

    public static String replaceAll(String source, String pKey, String pReplacement) {
        int next;
        int start = 0;
        StringBuffer in = new StringBuffer(source);
        StringBuffer out = new StringBuffer();
        while ((next = in.indexOf(pKey, start)) != -1) {
            out.append(source.substring(start, next));
            out.append(pReplacement);
            start = next + pKey.length();
        }
        out.append(source.substring(start, source.length()));
        return out.toString();
    }
}

