/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.ide.eclipse.core.tools;

import java.net.URL;
import java.util.Iterator;
import java.util.Vector;
import org.apache.avalon.ide.eclipse.core.tools.ClassNameAnalyzer;
import org.apache.avalon.ide.eclipse.merlin.core.MerlinDeveloperCore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;

public class EclipseDirectoryHelper {
    private IProject project;
    private Vector classpathEntries = new Vector();

    public EclipseDirectoryHelper(IProject pProject) {
        this.project = pProject;
    }

    public static IPath getPluginLocation(String pluginId) {
        try {
            URL installURL = Platform.getPluginRegistry().getPluginDescriptor(pluginId).getInstallURL();
            return new Path(Platform.resolve((URL)installURL).getFile());
        }
        catch (Exception e) {
            MerlinDeveloperCore.log(e, "getPluginLocation() handling Exception");
            return null;
        }
    }

    public static IFile findFile(IProject project, String qualifiedClassName) {
        IJavaProject proj = JavaCore.create((IProject)project);
        IFile file = null;
        try {
            IType type = proj.findType(qualifiedClassName);
            file = (IFile)type.getUnderlyingResource();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return file;
    }

    public static String getOutputPath(IResource file) {
        String result = null;
        IJavaProject proj = JavaCore.create((IProject)file.getProject());
        try {
            String fullPath = file.getProject().getLocation().toString();
            int i = 0;
            i = fullPath.lastIndexOf(47);
            if (i != -1) {
                fullPath = fullPath.substring(0, i);
            }
            IPath path = proj.getOutputLocation();
            result = fullPath + path.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static void refresh(IFile eFile) {
        try {
            eFile.refreshLocal(1, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void createDirectory(String directory, boolean isSource) {
        IFolder folder = null;
        try {
            ClassNameAnalyzer cna = new ClassNameAnalyzer();
            cna.setPath(directory);
            Iterator it = cna.getSegments().iterator();
            while (it.hasNext()) {
                if (!(folder = folder == null ? this.project.getFolder((String)it.next()) : folder.getFolder((String)it.next())).exists()) {
                    folder.create(false, true, null);
                }
                if (!isSource) continue;
                this.classpathEntries.add(JavaCore.newSourceEntry((IPath)folder.getFullPath()));
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public String getFullPathName(String folderName) {
        String projectFolder = this.project.getLocation().toString();
        return projectFolder + "/" + folderName;
    }

    public void setClasspath() {
        try {
            IJavaProject javaProject = JavaCore.create((IProject)this.project);
            this.classpathEntries.add(JavaRuntime.getJREVariableEntry());
            IPath pluginPath = EclipseDirectoryHelper.getPluginLocation("org.apache.avalon.MerlinDeveloperCore");
            pluginPath = pluginPath.append("lib/avalon-framework");
            String[] libraries = pluginPath.toFile().list();
            for (int i = 0; i < libraries.length; ++i) {
                if (libraries[i].equalsIgnoreCase("avalon-framework-api-4.1.5.jar")) {
                    this.classpathEntries.add(JavaCore.newLibraryEntry((IPath)pluginPath.append("avalon-framework-api-4.1.5.jar"), null, null));
                }
                if (!libraries[i].equalsIgnoreCase("avalon-framework-impl-4.1.5.jar")) continue;
                this.classpathEntries.add(JavaCore.newLibraryEntry((IPath)pluginPath.append("avalon-framework-impl-4.1.5.jar"), null, null));
            }
            javaProject.setRawClasspath(this.classpathEntries.toArray(new IClasspathEntry[this.classpathEntries.size()]), javaProject.getOutputLocation(), null);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }
}

