/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.tags;

import java.text.SimpleDateFormat;
import java.util.Date;
import junit.framework.TestCase;
import org.mevenide.tags.AdaptVersionTag;

public class AdaptVersionTagTest
extends TestCase {
    private AdaptVersionTag tag;

    protected void setUp() throws Exception {
        this.tag = new AdaptVersionTag();
    }

    protected void tearDown() throws Exception {
        this.tag = null;
    }

    public void testAdapt() {
        this.tag.setVersion("1.0.0");
        AdaptVersionTagTest.assertEquals((String)"1.0.0", (String)this.tag.adapt());
        this.tag.setVersion("1.00");
        AdaptVersionTagTest.assertEquals((String)"1.0.0", (String)this.tag.adapt());
        this.tag.setVersion("1..0");
        AdaptVersionTagTest.assertEquals((String)"1.0.0", (String)this.tag.adapt());
        this.tag.setVersion("1.0-rc1");
        AdaptVersionTagTest.assertEquals((String)"1.0.1", (String)this.tag.adapt());
        this.tag.setVersion("1.0.beta5");
        AdaptVersionTagTest.assertEquals((String)"1.0.5", (String)this.tag.adapt());
        this.tag.setVersion("SNAPSHOT");
        AdaptVersionTagTest.assertEquals((String)"0.0.0", (String)this.tag.adapt());
        this.tag.setVersion("1.0-SNAPSHOT");
        AdaptVersionTagTest.assertEquals((String)("1.0." + new SimpleDateFormat("yyyyMMdd").format(new Date())), (String)this.tag.adapt());
        this.tag.setVersion("1.0.");
        AdaptVersionTagTest.assertEquals((String)"1.0.0", (String)this.tag.adapt());
        this.tag.setVersion("1.2");
        AdaptVersionTagTest.assertEquals((String)"1.2.0", (String)this.tag.adapt());
        this.tag.setVersion("1");
        AdaptVersionTagTest.assertEquals((String)"1.0.0", (String)this.tag.adapt());
    }
}

