/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.context;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.project.Project;
import org.jdom.DefaultJDOMFactory;
import org.jdom.Element;
import org.jdom.JDOMFactory;
import org.mevenide.context.AbstractQueryContext;
import org.mevenide.context.DefaultProjectContext;
import org.mevenide.context.IProjectContext;
import org.mevenide.context.IQueryContext;
import org.mevenide.context.IQueryErrorCallback;
import org.mevenide.context.LoggerErrorHandlerCallback;

public class DefaultQueryContext
extends AbstractQueryContext {
    private static final Log logger = LogFactory.getLog((Class)DefaultQueryContext.class);
    private static final Project EMPTY_PROJECT = new Project();
    private IQueryErrorCallback callback;
    private File projectDir;
    private File userDir;
    private File userPropertyFile;
    private long userPropertyFileTimestamp = 0L;
    private Properties userPropertyModel;
    private HashMap propertyModels;
    private HashMap timestamps;
    private HashMap files;
    private IProjectContext projectContext = new EmptyProjectContext();
    private static IQueryContext defaultInstance;
    private static JDOMFactory factory;

    private DefaultQueryContext() {
        this.callback = new LoggerErrorHandlerCallback();
        String home = System.getProperty("user.home");
        this.userDir = new File(home);
        this.userPropertyFile = new File(this.userDir, "build.properties");
        this.userPropertyModel = new Properties();
        this.initMaps();
    }

    public DefaultQueryContext(File projectDirectory) {
        this(projectDirectory, new LoggerErrorHandlerCallback());
    }

    public DefaultQueryContext(File projectDirectory, IQueryErrorCallback errorCallback) {
        this.callback = errorCallback;
        this.projectDir = projectDirectory;
        this.initMaps();
        this.projectContext = new DefaultProjectContext(this, this.getResolver(), this.callback);
    }

    DefaultQueryContext(File projectDirectory, IProjectContext proj) {
        this.projectDir = projectDirectory;
        this.projectContext = proj;
        this.initMaps();
    }

    private void initMaps() {
        this.propertyModels = new HashMap();
        this.timestamps = new HashMap();
        this.files = new HashMap();
        if (this.projectDir != null) {
            this.initLevel(1, this.projectDir);
        }
    }

    void initLevel(int level, File projDir) {
        File f = new File(projDir, "project.properties");
        Integer location = new Integer(level * 10);
        this.files.put(location, f);
        this.timestamps.put(location, new Long(0L));
        this.propertyModels.remove(location);
        f = new File(projDir, "build.properties");
        location = new Integer(level * 10 + 1);
        this.files.put(location, f);
        this.timestamps.put(location, new Long(0L));
        this.propertyModels.remove(location);
    }

    void reloadingParents() {
        this.files.clear();
        this.timestamps.clear();
        this.propertyModels.clear();
        this.initLevel(1, this.projectDir);
    }

    public static synchronized IQueryContext getNonProjectContextInstance() {
        if (defaultInstance == null) {
            defaultInstance = new DefaultQueryContext();
        }
        return defaultInstance;
    }

    public String getBuildPropertyValue(String key) {
        return this.getPropertyValueAt(key, 11);
    }

    public File getProjectDirectory() {
        return this.projectDir;
    }

    public String getProjectPropertyValue(String key) {
        return this.getPropertyValueAt(key, 10);
    }

    public String getParentBuildPropertyValue(String key) {
        return this.getPropertyValueAt(key, 21);
    }

    public String getParentProjectPropertyValue(String key) {
        return this.getPropertyValueAt(key, 20);
    }

    public String getUserPropertyValue(String key) {
        if (this != defaultInstance) {
            return DefaultQueryContext.getNonProjectContextInstance().getUserPropertyValue(key);
        }
        this.userPropertyFileTimestamp = this.checkReloadModel(this.userPropertyFile, this.userPropertyFileTimestamp, this.userPropertyModel);
        if (this.userPropertyFileTimestamp == 0L) {
            return null;
        }
        return this.userPropertyModel.getProperty(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties checkReloadModel(int location) {
        Integer loc;
        File propFile;
        if (location > 19) {
            this.getPOMContext().getProjectFiles();
        }
        if ((propFile = (File)this.files.get(loc = new Integer(location))) == null || !propFile.exists()) {
            return null;
        }
        long lastModified = propFile.lastModified();
        Long timeStamp = (Long)this.timestamps.get(loc);
        Properties prop = (Properties)this.propertyModels.get(loc);
        if (prop == null) {
            prop = new Properties();
            this.propertyModels.put(loc, prop);
        }
        if (lastModified > timeStamp) {
            prop.clear();
            InputStream str = null;
            try {
                str = new BufferedInputStream(new FileInputStream(propFile));
                prop.load(str);
            }
            catch (IOException exc) {
                this.callback.handleError(-2, exc);
            }
            finally {
                if (str != null) {
                    try {
                        str.close();
                    }
                    catch (IOException exc) {
                        logger.error((Object)("Cannot close " + propFile), (Throwable)exc);
                    }
                }
            }
        }
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long checkReloadModel(File propFile, long timestamp, Properties propModel) {
        if (propFile == null || !propFile.exists()) {
            return 0L;
        }
        long lastModified = propFile.lastModified();
        if (lastModified > timestamp) {
            propModel.clear();
            InputStream str = null;
            try {
                str = new BufferedInputStream(new FileInputStream(propFile));
                propModel.load(str);
            }
            catch (IOException exc) {
                this.callback.handleError(-2, exc);
            }
            finally {
                if (str != null) {
                    try {
                        str.close();
                    }
                    catch (IOException exc) {
                        logger.error((Object)("Cannot close " + propFile), (Throwable)exc);
                    }
                }
            }
        }
        return lastModified;
    }

    public File getUserDirectory() {
        if (this != defaultInstance) {
            return DefaultQueryContext.getNonProjectContextInstance().getUserDirectory();
        }
        return this.userDir;
    }

    public IProjectContext getPOMContext() {
        return this.projectContext;
    }

    public Set getBuildPropertyKeys() {
        return this.getPropertyKeysAt(11);
    }

    public Set getProjectPropertyKeys() {
        return this.getPropertyKeysAt(10);
    }

    public Set getUserPropertyKeys() {
        if (this != defaultInstance) {
            return DefaultQueryContext.getNonProjectContextInstance().getUserPropertyKeys();
        }
        this.userPropertyFileTimestamp = this.checkReloadModel(this.userPropertyFile, this.userPropertyFileTimestamp, this.userPropertyModel);
        if (this.userPropertyFileTimestamp == 0L) {
            return Collections.EMPTY_SET;
        }
        return new HashSet<Object>(this.userPropertyModel.keySet());
    }

    public Set getParentBuildPropertyKeys() {
        return this.getPropertyKeysAt(21);
    }

    public Set getParentProjectPropertyKeys() {
        return this.getPropertyKeysAt(20);
    }

    public String getPropertyValueAt(String key, int location) {
        if (location == 12) {
            return this.getUserPropertyValue(key);
        }
        Properties props = this.checkReloadModel(location);
        if (props == null) {
            return null;
        }
        return props.getProperty(key);
    }

    public Set getPropertyKeysAt(int location) {
        if (location == 12) {
            return this.getUserPropertyKeys();
        }
        Properties props = this.checkReloadModel(location);
        if (props == null) {
            return Collections.EMPTY_SET;
        }
        return new HashSet<Object>(props.keySet());
    }

    public final String getPropertyValue(String key) {
        int depth;
        String toReturn = this.getUserPropertyValue(key);
        if (toReturn == null) {
            toReturn = this.getBuildPropertyValue(key);
        }
        if (toReturn == null) {
            toReturn = this.getProjectPropertyValue(key);
        }
        if (toReturn == null && (depth = this.getPOMContext().getProjectDepth()) > 1) {
            int current = 1;
            while (current <= depth && toReturn == null) {
                if ((toReturn = this.getPropertyValueAt(key, ++current * 10 + 1)) != null) continue;
                toReturn = this.getPropertyValueAt(key, current * 10);
            }
        }
        return toReturn;
    }

    static /* synthetic */ JDOMFactory access$100() {
        return factory;
    }

    static {
        factory = new DefaultJDOMFactory();
    }

    private class EmptyProjectContext
    implements IProjectContext {
        private Project empty = new Project();
        private Element rootEl = DefaultQueryContext.access$100().element("project");

        private EmptyProjectContext() {
        }

        public Project getFinalProject() {
            return this.empty;
        }

        public File[] getProjectFiles() {
            return new File[0];
        }

        public Project[] getProjectLayers() {
            return new Project[0];
        }

        public int getProjectDepth() {
            return 0;
        }

        public Element[] getRootElementLayers() {
            return new Element[0];
        }

        public Element getRootProjectElement() {
            return this.rootEl;
        }
    }
}

