/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.properties;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.properties.Comment;
import org.mevenide.properties.Element;
import org.mevenide.properties.ElementFactory;
import org.mevenide.properties.KeyValuePair;

public class PropertyModel {
    private static final Log log = LogFactory.getLog((Class)PropertyModel.class);
    private List list = new LinkedList();

    PropertyModel() {
    }

    public void addElement(Element el) {
        this.list.add(el);
    }

    public void removeElement(Element el) {
        this.list.remove(el);
    }

    public List getList() {
        return new ArrayList(this.list);
    }

    public int getSize() {
        return this.list.size();
    }

    public boolean insertAt(int index, Element el) {
        if (index >= 0 && index < this.list.size()) {
            this.list.add(index, el);
            return true;
        }
        return false;
    }

    public KeyValuePair findByKey(String key) {
        Iterator it = this.list.iterator();
        KeyValuePair result = null;
        while (it.hasNext()) {
            KeyValuePair kp;
            Object el = it.next();
            if (!(el instanceof KeyValuePair) || !(kp = (KeyValuePair)el).getKey().equals(key)) continue;
            result = kp;
        }
        String lineSeparator = new String(new byte[]{13});
        if (result != null) {
            result.setValue(result.getValue().trim().replaceAll("\\\\r\\\\n", lineSeparator));
            result.setValue(result.getValue().trim().replaceAll("\\\\r", lineSeparator));
            result.setValue(result.getValue().trim().replaceAll("\\\\n", lineSeparator));
        }
        return result;
    }

    public KeyValuePair newKeyPair(String key, char separator, String value) {
        KeyValuePair pair = this.findByKey(key.trim());
        if (pair == null) {
            pair = new KeyValuePair(key.trim(), separator);
            pair.addToValue(value.trim());
            this.addElement(pair);
        } else {
            pair.setValue(value.trim());
        }
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(OutputStream stream) throws IOException {
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter(stream);
            Iterator it = this.getList().iterator();
            while (it.hasNext()) {
                writer.write(it.next().toString());
                writer.write(10);
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String message;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        String modelToString = null;
        try {
            this.store(bos);
            modelToString = "PropertyModel = " + new String(bos.toByteArray());
        }
        catch (IOException e) {
            message = "unable to write model to Stream";
            log.error((Object)message, (Throwable)e);
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e1) {
                    message = "Cannot close stream";
                    log.error((Object)message, (Throwable)e1);
                }
            }
        }
        return modelToString;
    }

    public void addToComment(Comment comment, String line) {
        if (comment == null) {
            comment = ElementFactory.getFactory().createComment();
            this.addElement(comment);
        }
        comment.addToComment(line);
    }
}

