/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.properties.resolver;

import java.io.File;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.context.IQueryContext;
import org.mevenide.properties.IPropertyFinder;
import org.mevenide.properties.resolver.PluginPropertiesFinder;
import org.mevenide.properties.resolver.PropertyResolverFactory;

public final class DefaultsResolver
implements IPropertyFinder {
    private static final Log logger = LogFactory.getLog((Class)DefaultsResolver.class);
    private PluginPropertiesFinder pluginDefaults;
    private static Properties defaults;
    private File projectDir;
    private File userDir;
    private IQueryContext context;
    private String lastUnpackedDir;
    private String lastPackedDir;
    private boolean reloading = false;

    public DefaultsResolver(File projectFile, File userFile) {
        this.userDir = userFile;
        this.projectDir = projectFile;
    }

    public DefaultsResolver(IQueryContext cont) {
        this.context = cont;
    }

    void initPluginPropsFinder(PluginPropertiesFinder finder) {
        this.pluginDefaults = finder;
    }

    public String getValue(String key) {
        return this.getDefault(key);
    }

    public void reload() {
    }

    private String getDefault(String key) {
        if ("basedir".equals(key)) {
            if (this.context != null) {
                File proj = this.context.getProjectDirectory();
                return proj == null ? null : proj.getAbsolutePath();
            }
            return this.projectDir.getAbsolutePath();
        }
        if ("user.home".equals(key)) {
            if (this.context != null) {
                return this.context.getUserDirectory().getAbsolutePath();
            }
            return this.userDir.getAbsolutePath();
        }
        this.checkReload();
        String toReturn = defaults.getProperty(key);
        if (toReturn == null && this.pluginDefaults != null) {
            toReturn = this.pluginDefaults.getValue(key);
        }
        return toReturn;
    }

    public Set getDefaultKeys() {
        this.checkReload();
        HashSet<Object> set = new HashSet<Object>(defaults.keySet());
        if (this.pluginDefaults != null) {
            set.addAll(this.pluginDefaults.getDefaultPluginKeys());
        }
        return set;
    }

    private synchronized void checkReload() {
        if (this.reloading) {
            return;
        }
        this.reloading = true;
        String val = this.context.getResolver().getResolvedValue("maven.plugin.unpacked.dir");
        String val2 = this.context.getResolver().getResolvedValue("maven.plugin.dir");
        if (val != null && !val.equals(this.lastUnpackedDir) || val2 != null && !val2.equals(this.lastPackedDir)) {
            this.pluginDefaults = PropertyResolverFactory.getFactory().getPluginDefaultsPropertyFinder(new File(val), new File(val2));
            this.lastUnpackedDir = val;
            this.lastPackedDir = val2;
        }
        this.reloading = false;
    }

    static {
        try {
            InputStream stream = DefaultsResolver.class.getClassLoader().getResourceAsStream("org/mevenide/properties/maven_defaults.properties");
            defaults = new Properties();
            defaults.load(stream);
        }
        catch (Exception exc) {
            logger.error((Object)"Cannot load default properties.", (Throwable)exc);
        }
    }
}

