/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.properties.resolver;

import java.lang.reflect.Field;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.project.Project;

public class ProjectWalker {
    private static final String EMPTY_STR = "";
    private Project project;

    public ProjectWalker(Project project) {
        this.project = project;
    }

    public String resolve(String unresolvedString) throws Exception {
        return this.resolve(unresolvedString, false);
    }

    public String resolve(String unresolvedString, boolean preserveBasedir) throws Exception {
        String resolvedString = EMPTY_STR;
        String tempVariable = EMPTY_STR;
        for (int i = 0; i < unresolvedString.length(); ++i) {
            if (unresolvedString.charAt(i) == '$') {
                tempVariable = tempVariable + unresolvedString.charAt(i);
            }
            if (unresolvedString.charAt(i) != '$' && unresolvedString.charAt(i) != '{' && unresolvedString.charAt(i) != '}') {
                if (!tempVariable.equals(EMPTY_STR)) {
                    tempVariable = tempVariable + unresolvedString.charAt(i);
                } else {
                    resolvedString = resolvedString + unresolvedString.charAt(i);
                }
            }
            if (unresolvedString.charAt(i) != '}') continue;
            if (!(tempVariable = tempVariable.substring(1, tempVariable.length())).startsWith("pom") && !tempVariable.startsWith("basedir")) {
                return unresolvedString;
            }
            Object evaluation = null;
            if (tempVariable.startsWith("basedir")) {
                evaluation = preserveBasedir ? "${basedir}" : ".";
            } else {
                String[] splittedVar = StringUtils.split((String)tempVariable, (String)".");
                evaluation = this.project;
                for (int j = 1; j < splittedVar.length; ++j) {
                    try {
                        Field f = evaluation.getClass().getDeclaredField(splittedVar[j]);
                        f.setAccessible(true);
                        evaluation = f.get(evaluation);
                        f.setAccessible(false);
                        continue;
                    }
                    catch (NoSuchFieldException ex) {
                        Field f = evaluation.getClass().getSuperclass().getDeclaredField(splittedVar[j]);
                        f.setAccessible(true);
                        evaluation = f.get(evaluation);
                        f.setAccessible(false);
                    }
                }
            }
            resolvedString = resolvedString + evaluation;
            tempVariable = EMPTY_STR;
        }
        return resolvedString;
    }
}

