/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.properties.writer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.properties.Element;
import org.mevenide.properties.ElementFactory;
import org.mevenide.properties.KeyValuePair;
import org.mevenide.properties.PropertyModel;
import org.mevenide.properties.PropertyModelFactory;
import org.mevenide.properties.writer.IPropertiesWriter;

public class CarefulPropertiesWriter
implements IPropertiesWriter {
    private static Log logger = LogFactory.getLog((Class)CarefulPropertiesWriter.class);
    private static final String specialSaveChars = "=: \t\r\n\f#!";
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public void marshall(OutputStream output, Properties props, InputStream currentContent) throws IOException {
        PropertyModel model = PropertyModelFactory.getFactory().newPropertyModel(currentContent);
        ArrayList<KeyValuePair> newOnes = new ArrayList<KeyValuePair>();
        ArrayList<KeyValuePair> replacedOnes = new ArrayList<KeyValuePair>();
        Enumeration<?> en = props.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            KeyValuePair kp = model.findByKey(key);
            if (kp != null) {
                kp.setValue(this.saveConvert(props.getProperty(key), false));
                replacedOnes.add(kp);
                continue;
            }
            kp = ElementFactory.getFactory().createKeyValuePair(key, '=');
            kp.setValue(this.saveConvert(props.getProperty(key), false));
            newOnes.add(kp);
            model.addElement(kp);
        }
        List modelList = model.getList();
        Iterator it = modelList.iterator();
        while (it.hasNext()) {
            Element obj = (Element)it.next();
            if (!(obj instanceof KeyValuePair) || newOnes.contains(obj) || replacedOnes.contains(obj)) continue;
            model.removeElement(obj);
        }
        this.marshallModel(model, output);
    }

    private void marshallModel(PropertyModel model, OutputStream stream) throws IOException {
        model.store(stream);
    }

    private String saveConvert(String theString, boolean escapeSpace) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\\': {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(CarefulPropertiesWriter.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(CarefulPropertiesWriter.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(CarefulPropertiesWriter.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(CarefulPropertiesWriter.toHex(aChar & 0xF));
                        continue block8;
                    }
                    if (specialSaveChars.indexOf(aChar) != -1) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static char toHex(int number) {
        return hexDigit[number & 0xF];
    }
}

