/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.environment;

import java.io.File;
import org.mevenide.environment.ILocationFinder;
import org.mevenide.environment.LocationFinderAggregator;

public final class ConfigUtils {
    private static ILocationFinder defaultLocFinder;
    private static Object LOCK;
    private static int heapSize;

    private ConfigUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ILocationFinder getDefaultLocationFinder() {
        if (defaultLocFinder == null) {
            Object object = LOCK;
            synchronized (object) {
                if (defaultLocFinder == null) {
                    defaultLocFinder = new LocationFinderAggregator();
                }
            }
        }
        return defaultLocFinder;
    }

    public static int getHeapSize() {
        return heapSize;
    }

    public static void setHeapSize(int hSize) {
        heapSize = hSize;
    }

    public static String getEndorsedDirs() {
        return ConfigUtils.getDefaultLocationFinder().getJavaHome() + File.separatorChar + "lib" + File.separatorChar + "endorsed" + File.pathSeparator + ConfigUtils.getDefaultLocationFinder().getMavenHome() + File.separator + "lib" + File.separator + "endorsed";
    }

    public static String getConfigurationFile() {
        return new File(new File(ConfigUtils.getDefaultLocationFinder().getMavenHome(), "bin"), "forehead.conf").getAbsolutePath();
    }

    static {
        LOCK = new Object();
        heapSize = 160;
    }
}

