/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.properties;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.properties.KeyValuePair;
import org.mevenide.properties.PropertyModel;
import org.mevenide.properties.util.Utils;

public final class PropertyModelFactory {
    private static final Log log = LogFactory.getLog((Class)PropertyModelFactory.class);
    private static final PropertyModelFactory factory = new PropertyModelFactory();
    private final String whiteSpaceChars = " \t\r\n\f";

    private PropertyModelFactory() {
    }

    public static PropertyModelFactory getFactory() {
        return factory;
    }

    public PropertyModel newPropertyModel(File file) throws IOException {
        if (file.exists()) {
            return this.newPropertyModel(new FileInputStream(file));
        }
        return new PropertyModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyModel newPropertyModel(InputStream stream) throws IOException {
        BufferedReader reader = null;
        PropertyModel model = new PropertyModel();
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(stream, "8859_1"));
            Object currComment = null;
            KeyValuePair currKeyPair = null;
            boolean appendingMode = false;
            while ((line = reader.readLine()) != null) {
                int keyStart;
                line = Utils.removeTrailingWhitespaces(line);
                int len = line.length();
                for (keyStart = 0; keyStart < len && " \t\r\n\f".indexOf(line.charAt(keyStart)) != -1; ++keyStart) {
                }
                if (appendingMode) {
                    currComment = null;
                    currKeyPair.setValue(Utils.removeTrailingSlash(currKeyPair.getValue()).trim());
                    currKeyPair.addToValue(Utils.removeTrailingWhitespaces(line));
                    appendingMode = this.continueLine(line);
                    continue;
                }
                if (keyStart == len) {
                    currKeyPair = null;
                    model.addToComment(currComment, line);
                    continue;
                }
                char firstChar = line.charAt(keyStart);
                if (firstChar == '#' || firstChar == '!') {
                    currKeyPair = null;
                    model.addToComment(currComment, line);
                    continue;
                }
                int sepIndex = Math.min(line.indexOf(61), line.indexOf(58));
                if (sepIndex < 0) {
                    sepIndex = Math.max(line.indexOf(61), line.indexOf(58));
                }
                if (sepIndex > 0) {
                    String key = line.substring(0, sepIndex);
                    String value = line.substring(sepIndex + 1);
                    currComment = null;
                    if (key.trim().length() == 0) {
                        log.warn((Object)"strange line - key is whitespace");
                        continue;
                    }
                    currKeyPair = model.newKeyPair(key, line.charAt(sepIndex), value);
                    appendingMode = this.continueLine(line);
                    continue;
                }
                log.warn((Object)("A non-comment non key-pair line encountered:'" + line + "'"));
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return model;
    }

    private boolean continueLine(String line) {
        int slashCount = 0;
        int index = line.length() - 1;
        while (index >= 0 && line.charAt(index--) == '\\') {
            ++slashCount;
        }
        return slashCount % 2 == 1;
    }
}

