/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.properties.resolver;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.properties.IPropertyFinder;

public final class PluginPropertiesFinder
implements IPropertyFinder {
    private static final Log logger = LogFactory.getLog((Class)PluginPropertiesFinder.class);
    private File pluginDir;
    private File valid;
    private Properties props;
    private long lastModified = -1L;
    private Object LOCK = new Object();

    PluginPropertiesFinder(File pluginDir) {
        this.pluginDir = pluginDir;
        this.valid = new File(pluginDir, "valid.cache");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValue(String key) {
        Object object = this.LOCK;
        synchronized (object) {
            this.checkReload();
            return this.props.getProperty(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getDefaultPluginKeys() {
        Object object = this.LOCK;
        synchronized (object) {
            this.checkReload();
            return new HashSet<Object>(this.props.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        Object object = this.LOCK;
        synchronized (object) {
            this.checkReload();
        }
    }

    private void checkReload() {
        long validStamp;
        long l = validStamp = this.valid.exists() ? this.valid.lastModified() : 0L;
        if (validStamp != this.lastModified) {
            this.props = null;
            this.loadAllProperties();
        }
        this.lastModified = validStamp;
    }

    private void loadAllProperties() {
        this.props = new Properties();
        if (this.pluginDir.exists()) {
            File[] plugins = this.pluginDir.listFiles();
            for (int i = 0; i < plugins.length; ++i) {
                if (!plugins[i].isDirectory()) continue;
                this.loadDefaults(this.props, plugins[i]);
            }
        }
    }

    private void loadDefaults(Properties pros, File dir) {
        File propFile = new File(dir, "plugin.properties");
        if (propFile.exists()) {
            try {
                pros.load(new BufferedInputStream(new FileInputStream(propFile)));
            }
            catch (IOException exc) {
                logger.warn((Object)("Cannot read defaults from file:" + propFile), (Throwable)exc);
            }
        }
    }
}

