/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.properties.resolver;

import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Element;
import org.mevenide.context.IQueryContext;
import org.mevenide.properties.IPropertyFinder;

public class ProjectWalker2
implements IPropertyFinder {
    private static final Log logger = LogFactory.getLog((Class)ProjectWalker2.class);
    private IQueryContext context;

    public ProjectWalker2(IQueryContext qcontext) {
        this.context = qcontext;
    }

    public String getValue(String key) {
        if (!key.startsWith("pom.")) {
            return null;
        }
        Element proj = this.context.getPOMContext().getRootProjectElement();
        return this.doGetValue(key, proj, true);
    }

    public void reload() {
    }

    private String doGetValue(String key, Element proj, boolean resolveId) {
        if (proj == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(key, ".", false);
        tok.nextToken();
        Element currentElement = proj;
        while (tok.hasMoreTokens()) {
            List nextEl;
            String next = tok.nextToken();
            if (resolveId && "project".equals(currentElement.getName())) {
                if ("artifactId".equals(next)) {
                    return this.context.getPOMContext().getFinalProject().getArtifactId();
                }
                if ("groupId".equals(next)) {
                    return this.context.getPOMContext().getFinalProject().getGroupId();
                }
                if ("id".equals(next)) {
                    return this.context.getPOMContext().getFinalProject().getId();
                }
            }
            if ((nextEl = currentElement.getChildren(next)) != null && nextEl.size() == 1) {
                currentElement = (Element)nextEl.iterator().next();
                continue;
            }
            currentElement = null;
            break;
        }
        if (currentElement != null) {
            return currentElement.getText();
        }
        logger.debug((Object)("could not find=" + key + ". Maybe it's not defined in the current POM or it's badly formed"));
        return null;
    }

    public int getLocation(String key) {
        Element[] els = this.context.getPOMContext().getRootElementLayers();
        for (int i = 0; i < els.length; ++i) {
            String loc = this.doGetValue(key, els[i], false);
            if (loc == null) continue;
            return i;
        }
        return -1;
    }
}

