/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.properties.resolver;

import java.io.File;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.context.IQueryContext;
import org.mevenide.environment.SysEnvLocationFinder;
import org.mevenide.properties.IPropertyFinder;
import org.mevenide.properties.IPropertyLocator;
import org.mevenide.properties.IPropertyResolver;
import org.mevenide.properties.resolver.DefaultsResolver;
import org.mevenide.properties.resolver.ProjectWalker2;
import org.mevenide.properties.resolver.PropertyResolverFactory;

public class PropertyFilesAggregator
implements IPropertyResolver,
IPropertyLocator {
    private static final Log logger = LogFactory.getLog((Class)PropertyFilesAggregator.class);
    private IPropertyFinder defaults;
    private IPropertyFinder projectWalker;
    private IQueryContext context;

    PropertyFilesAggregator(IQueryContext querycontext, DefaultsResolver defs) {
        this.context = querycontext;
        this.defaults = defs;
        this.initializeContext();
        String val = this.getResolvedValue("maven.plugin.unpacked.dir");
        if (val != null) {
            defs.initPluginPropsFinder(PropertyResolverFactory.getFactory().getPluginDefaultsPropertyFinder(new File(val)));
        }
    }

    private void initializeContext() {
        this.projectWalker = new ProjectWalker2(this.context);
    }

    public String getResolvedValue(String key) {
        return this.getValue(key, true);
    }

    public String getValue(String key) {
        return this.getValue(key, false);
    }

    protected String getValue(String key, boolean resolve) {
        String toReturn = null;
        if (key.startsWith("pom.") && this.projectWalker != null) {
            toReturn = this.projectWalker.getValue(key);
        } else {
            toReturn = this.checkSysEnv(key);
            if (toReturn == null) {
                toReturn = this.context.getPropertyValue(key);
            }
            if (toReturn == null && this.defaults != null) {
                toReturn = this.defaults.getValue(key);
            }
        }
        if (resolve && toReturn != null) {
            toReturn = this.resolve(new StringBuffer(toReturn)).toString();
        }
        return toReturn;
    }

    private String checkSysEnv(String key) {
        if ("maven.home.local".equals(key)) {
            return SysEnvLocationFinder.getInstance().getMavenLocalHome();
        }
        if ("maven.home".equals(key)) {
            return SysEnvLocationFinder.getInstance().getMavenHome();
        }
        if ("maven.repo.local".equals(key)) {
            return SysEnvLocationFinder.getInstance().getMavenLocalRepository();
        }
        return null;
    }

    public int getPropertyLocation(String key) {
        int toReturn = -1;
        if (this.checkSysEnv(key) != null) {
            return 99;
        }
        if (this.context.getUserPropertyValue(key) != null) {
            toReturn = 12;
        } else if (this.context.getBuildPropertyValue(key) != null) {
            toReturn = 11;
        } else if (this.context.getProjectPropertyValue(key) != null) {
            toReturn = 10;
        } else {
            int depth = this.context.getPOMContext().getProjectDepth();
            if (depth > 1) {
                int current = 1;
                while (current <= depth && toReturn == -1) {
                    String val;
                    if ((val = this.context.getPropertyValueAt(key, ++current * 10 + 1)) != null) {
                        toReturn = current * 10 + 1;
                        continue;
                    }
                    val = this.context.getPropertyValueAt(key, current * 10 + 0);
                    if (val == null) continue;
                    toReturn = current * 10 + 0;
                }
            }
        }
        if (toReturn == -1 && this.defaults.getValue(key) != null) {
            toReturn = -2;
        }
        return toReturn;
    }

    protected final StringBuffer resolve(StringBuffer value) {
        StringBuffer toReturn = value;
        int index = value.indexOf("${");
        if (index > -1) {
            int end = value.indexOf("}", index);
            if (end > index + 2) {
                String key = value.substring(index + 2, end);
                String keyvalue = this.getValue(key, false);
                if (keyvalue != null) {
                    toReturn.replace(index, end + 1, keyvalue);
                    return this.resolve(toReturn);
                }
                logger.warn((Object)("cannot resolve key? '" + key + "'"));
            } else {
                logger.warn((Object)("badly formed value? '" + value + "'"));
            }
        }
        return toReturn;
    }

    public void reload() {
    }

    public String resolveString(String original) {
        if (original == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(original);
        return this.resolve(buf).toString();
    }

    public boolean isDefinedInLocation(String key, int location) {
        if (location == -2) {
            return this.defaults.getValue(key) != null;
        }
        return this.context.getPropertyValueAt(key, location) != null;
    }

    public String getValueAtLocation(String key, int location) {
        if (location == -2) {
            return this.defaults.getValue(key);
        }
        return this.context.getPropertyValueAt(key, location);
    }

    public Set getKeysAtLocation(int location) {
        if (location == -2 && this.defaults != null && this.defaults instanceof DefaultsResolver) {
            return ((DefaultsResolver)this.defaults).getDefaultKeys();
        }
        return this.context.getPropertyKeysAt(location);
    }
}

