/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.properties.resolver;

import org.mevenide.context.IQueryContext;
import org.mevenide.properties.IPropertyFinder;

final class QueryBasedFinderFactory {
    QueryBasedFinderFactory() {
    }

    static IPropertyFinder createUserPropertyFinder(IQueryContext context) {
        return new UserPropertyFinder(context);
    }

    static IPropertyFinder createBuildPropertyFinder(IQueryContext context) {
        return new BuildPropertyFinder(context);
    }

    static IPropertyFinder createProjectPropertyFinder(IQueryContext context) {
        return new ProjectPropertyFinder(context);
    }

    private static final class ProjectPropertyFinder
    extends PropertyFinder {
        public ProjectPropertyFinder(IQueryContext context) {
            super(context);
        }

        public String getValue(String key) {
            return this.context.getProjectPropertyValue(key);
        }
    }

    private static final class BuildPropertyFinder
    extends PropertyFinder {
        public BuildPropertyFinder(IQueryContext context) {
            super(context);
        }

        public String getValue(String key) {
            return this.context.getBuildPropertyValue(key);
        }
    }

    private static final class UserPropertyFinder
    extends PropertyFinder {
        public UserPropertyFinder(IQueryContext context) {
            super(context);
        }

        public String getValue(String key) {
            return this.context.getUserPropertyValue(key);
        }
    }

    private static abstract class PropertyFinder
    implements IPropertyFinder {
        protected IQueryContext context;

        protected PropertyFinder(IQueryContext querycontext) {
            this.context = querycontext;
        }

        public void reload() {
        }
    }
}

