/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.context;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.project.Project;
import org.jdom.Content;
import org.jdom.DefaultJDOMFactory;
import org.jdom.Element;
import org.jdom.JDOMFactory;
import org.jdom.Text;
import org.mevenide.context.DefaultQueryContext;
import org.mevenide.context.IProjectContext;
import org.mevenide.context.IQueryErrorCallback;
import org.mevenide.context.JDomProjectUnmarshaller;
import org.mevenide.properties.IPropertyResolver;

class DefaultProjectContext
implements IProjectContext {
    private static final Log logger = LogFactory.getLog((Class)DefaultProjectContext.class);
    private IQueryErrorCallback callback;
    private Project mergedProject;
    private List projects;
    private List projectFiles;
    private List projectTimestamps;
    private Element mergedJDomRoot;
    private List jdomRootElements;
    private Object LOCK = new Object();
    private JDomProjectUnmarshaller unmarshaller;
    private IPropertyResolver propResolver;
    private DefaultQueryContext queryContext;
    private static Pattern pattern = Pattern.compile(".*\\$\\{([a-zA-Z0-9_\\-\\.]*)\\}.*");
    private static JDOMFactory factory = new DefaultJDOMFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultProjectContext(DefaultQueryContext context, IPropertyResolver resolver, IQueryErrorCallback errorCallback) {
        this.callback = errorCallback;
        this.unmarshaller = new JDomProjectUnmarshaller();
        this.propResolver = resolver;
        this.queryContext = context;
        this.projectTimestamps = new ArrayList();
        this.projectFiles = new ArrayList();
        this.projects = new ArrayList();
        this.jdomRootElements = new ArrayList();
        if (context.getProjectDirectory() == null) {
            throw new IllegalStateException("Cannot initialize ProjectContext without a project-based Querycontext");
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.reloadData();
        }
    }

    private void reloadData() {
        this.projectFiles.clear();
        this.projectTimestamps.clear();
        this.projects.clear();
        this.jdomRootElements.clear();
        this.mergedProject = new Project();
        this.mergedJDomRoot = factory.element("project");
        File rootFile = new File(this.queryContext.getProjectDirectory(), "project.xml");
        this.readProject(rootFile, 1);
        for (int i = 0; i < this.jdomRootElements.size(); ++i) {
            Element root = (Element)this.jdomRootElements.get(i);
            File file = (File)this.projectFiles.get(i);
            this.mergedJDomRoot = this.mergeProjectDOMs(this.mergedJDomRoot, root);
            Project project = this.unmarshaller.generateProject(root);
            project.setFile(file);
            this.projects.add(project);
        }
        this.mergedProject = this.unmarshaller.generateProject(this.mergedJDomRoot);
        this.mergedProject.setFile(rootFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project getFinalProject() {
        Object object = this.LOCK;
        synchronized (object) {
            this.checkTimeStamps();
            return this.mergedProject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] getProjectFiles() {
        File[] fls;
        Object object = this.LOCK;
        synchronized (object) {
            this.checkTimeStamps();
            fls = new File[this.projectFiles.size()];
            fls = this.projectFiles.toArray(fls);
        }
        return fls;
    }

    public int getProjectDepth() {
        File[] fls = this.getProjectFiles();
        return fls.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project[] getProjectLayers() {
        Project[] prjs;
        Object object = this.LOCK;
        synchronized (object) {
            this.checkTimeStamps();
            prjs = new Project[this.projects.size()];
            prjs = this.projects.toArray(prjs);
        }
        return prjs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element[] getRootElementLayers() {
        Element[] prjs;
        Object object = this.LOCK;
        synchronized (object) {
            this.checkTimeStamps();
            prjs = new Element[this.jdomRootElements.size()];
            prjs = this.jdomRootElements.toArray(prjs);
        }
        return prjs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getRootProjectElement() {
        Object object = this.LOCK;
        synchronized (object) {
            this.checkTimeStamps();
            return this.mergedJDomRoot;
        }
    }

    private void checkTimeStamps() {
        for (int i = 0; i < this.projectFiles.size(); ++i) {
            File file = (File)this.projectFiles.get(i);
            Long stamp = (Long)this.projectTimestamps.get(i);
            if (file.lastModified() <= stamp) continue;
            this.reloadData();
        }
    }

    private void readProject(File file, int level) {
        logger.debug((Object)("readproject=" + file));
        if (file.exists()) {
            Element proj;
            this.queryContext.initLevel(level, file.getParentFile());
            this.callback.discardError(-3);
            try {
                proj = this.unmarshaller.parseRootElement(file);
            }
            catch (Exception exc) {
                DefaultJDOMFactory fact = new DefaultJDOMFactory();
                this.jdomRootElements.add(fact.element("project"));
                this.projectFiles.add(file);
                this.projectTimestamps.add(new Long(file.lastModified()));
                this.callback.handleError(-1, exc);
                return;
            }
            if (proj != null) {
                this.jdomRootElements.add(proj);
                this.projectFiles.add(file);
                this.projectTimestamps.add(new Long(file.lastModified()));
                String extend = proj.getChildText("extend");
                this.callback.discardError(-1);
                if (extend != null) {
                    extend = DefaultProjectContext.doReplaceExtend(file.getParentFile(), this.propResolver, extend);
                    File absolute = new File(extend);
                    if ((absolute = JDomProjectUnmarshaller.normalizeFile(absolute)).exists() && !absolute.equals(file)) {
                        this.callback.discardError(-4);
                        this.readProject(absolute, level + 1);
                    } else {
                        File relative = new File(this.queryContext.getProjectDirectory(), extend);
                        if ((relative = JDomProjectUnmarshaller.normalizeFile(relative)).exists() && !relative.equals(file)) {
                            this.callback.discardError(-4);
                            this.readProject(relative, level + 1);
                        } else {
                            this.callback.handleError(-4, new FileNotFoundException("Cannot find <extend> file:" + extend));
                        }
                    }
                }
            }
        } else {
            this.callback.handleError(-3, new FileNotFoundException("Cannot find project.xml file:" + file.getAbsolutePath()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String doReplaceExtend(File basedir, IPropertyResolver resolver, String extend) {
        Matcher match;
        if (extend.indexOf("${") <= -1) return extend;
        int index = extend.indexOf("${basedir}");
        if (index > -1) {
            extend = extend.substring(0, index) + basedir.getAbsolutePath() + extend.substring(index + "${basedir}".length());
        }
        if (!(match = pattern.matcher(extend)).matches()) return extend;
        String gr1 = match.group(1);
        String replace = resolver.getValue(gr1);
        if (replace == null) return extend;
        index = extend.indexOf(gr1);
        extend = extend.substring(0, index - 2) + replace + extend.substring(index + gr1.length() + 1);
        return DefaultProjectContext.doReplaceExtend(basedir, resolver, extend);
    }

    private void mergeSimpleElement(String name, Element primaryParent, Element secondaryParent, Element resultParent) {
        String source;
        String primary = primaryParent != null ? primaryParent.getChildText(name) : null;
        String secondary = secondaryParent != null ? secondaryParent.getChildText(name) : null;
        String string = source = primary != null ? primary : secondary;
        if (source != null) {
            Element toReturn = factory.element(name);
            toReturn.addContent((Content)factory.text(source));
            resultParent.addContent((Content)toReturn);
        }
    }

    private void mergeSubtree(String name, Element primaryParent, Element secondaryParent, Element resultParent) {
        Element source;
        Element primary = primaryParent != null ? primaryParent.getChild(name) : null;
        Element secondary = secondaryParent != null ? secondaryParent.getChild(name) : null;
        Element element = source = primary != null ? primary : secondary;
        if (source != null) {
            Element toReturnRoot = this.copyTree(source);
            resultParent.addContent((Content)toReturnRoot);
        }
    }

    private Element copyTree(Element source) {
        Element toReturn = factory.element(source.getName());
        Iterator it = source.getContent().iterator();
        while (it.hasNext()) {
            Object content = it.next();
            if (content instanceof Element) {
                toReturn.addContent((Content)this.copyTree((Element)content));
            }
            if (!(content instanceof Text)) continue;
            Text text = (Text)content;
            toReturn.addContent((Content)factory.text(text.getText()));
        }
        return toReturn;
    }

    private Element mergeProjectDOMs(Element primary, Element secondary) {
        Element toReturn = factory.element("project");
        if (primary == null || secondary == null) {
            throw new IllegalStateException("Shall not call method with null params.");
        }
        this.mergeSimpleElement("extend", primary, secondary, toReturn);
        this.mergeSimpleElement("pomVersion", primary, secondary, toReturn);
        this.mergeSimpleElement("id", primary, secondary, toReturn);
        this.mergeSimpleElement("groupId", primary, secondary, toReturn);
        this.mergeSimpleElement("artifactId", primary, secondary, toReturn);
        this.mergeSimpleElement("name", primary, secondary, toReturn);
        this.mergeSimpleElement("currentVersion", primary, secondary, toReturn);
        this.mergeSubtree("organization", primary, secondary, toReturn);
        this.mergeSimpleElement("inceptionYear", primary, secondary, toReturn);
        this.mergeSimpleElement("package", primary, secondary, toReturn);
        this.mergeSimpleElement("logo", primary, secondary, toReturn);
        this.mergeSimpleElement("gumpRepositoryId", primary, secondary, toReturn);
        this.mergeSimpleElement("description", primary, secondary, toReturn);
        this.mergeSimpleElement("shortDescription", primary, secondary, toReturn);
        this.mergeSimpleElement("url", primary, secondary, toReturn);
        this.mergeSimpleElement("issueTrackingUrl", primary, secondary, toReturn);
        this.mergeSimpleElement("siteAddress", primary, secondary, toReturn);
        this.mergeSimpleElement("siteDirectory", primary, secondary, toReturn);
        this.mergeSimpleElement("distributionSite", primary, secondary, toReturn);
        this.mergeSimpleElement("distributionDirectory", primary, secondary, toReturn);
        this.mergeSubtree("repository", primary, secondary, toReturn);
        this.mergeSubtree("versions", primary, secondary, toReturn);
        this.mergeSubtree("branches", primary, secondary, toReturn);
        this.mergeSubtree("mailingLists", primary, secondary, toReturn);
        this.mergeSubtree("developers", primary, secondary, toReturn);
        this.mergeSubtree("contributors", primary, secondary, toReturn);
        this.mergeSubtree("licenses", primary, secondary, toReturn);
        this.mergeDependencies(primary, secondary, toReturn);
        this.mergeBuild(primary, secondary, toReturn);
        this.mergeSubtree("reports", primary, secondary, toReturn);
        this.mergeProperties(primary, secondary, toReturn);
        return toReturn;
    }

    private void mergeDependencies(Element primary, Element secondary, Element toReturn) {
        Element dependency;
        Iterator it;
        Element secondarySource;
        Element primarySource = primary != null ? primary.getChild("dependencies") : null;
        Element element = secondarySource = secondary != null ? secondary.getChild("dependencies") : null;
        if (primarySource == null && secondarySource == null) {
            return;
        }
        Element root = factory.element("dependencies");
        if (primarySource != null) {
            it = primarySource.getChildren("dependency").iterator();
            while (it.hasNext()) {
                dependency = (Element)it.next();
                root.addContent((Content)this.copyTree(dependency));
            }
        }
        if (secondarySource != null) {
            it = secondarySource.getChildren("dependency").iterator();
            while (it.hasNext()) {
                dependency = (Element)it.next();
                root.addContent((Content)this.copyTree(dependency));
            }
        }
        toReturn.addContent((Content)root);
    }

    private void mergeBuild(Element primary, Element secondary, Element toReturn) {
        Element primarySource = primary.getChild("build");
        Element secondarySource = secondary.getChild("build");
        if (primarySource == null && secondarySource == null) {
            return;
        }
        Element root = factory.element("build");
        this.mergeSimpleElement("nagEmailAddress", primarySource, secondarySource, root);
        this.mergeSimpleElement("sourceDirectory", primarySource, secondarySource, root);
        this.mergeSimpleElement("aspectSourceDirectory", primarySource, secondarySource, root);
        this.mergeSimpleElement("unitTestSourceDirectory", primarySource, secondarySource, root);
        this.mergeSimpleElement("integrationUnitTestSourceDirectory", primarySource, secondarySource, root);
        this.mergeSourceModifications(primarySource, secondarySource, root);
        this.mergeSubtree("unitTest", primarySource, secondarySource, root);
        this.mergeSubtree("resources", primarySource, secondarySource, root);
        toReturn.addContent((Content)root);
    }

    private void mergeSourceModifications(Element primary, Element secondary, Element toReturn) {
        Element dependency;
        Iterator it;
        Element secondarySource;
        Element primarySource = primary != null ? primary.getChild("sourceModifications") : null;
        Element element = secondarySource = secondary != null ? secondary.getChild("sourceModifications") : null;
        if (primarySource == null && secondarySource == null) {
            return;
        }
        Element root = factory.element("sourceModifications");
        if (primarySource != null) {
            it = primarySource.getChildren("sourceModification").iterator();
            while (it.hasNext()) {
                dependency = (Element)it.next();
                root.addContent((Content)this.copyTree(dependency));
            }
        }
        if (secondarySource != null) {
            it = secondarySource.getChildren("sourceModification").iterator();
            while (it.hasNext()) {
                dependency = (Element)it.next();
                root.addContent((Content)this.copyTree(dependency));
            }
        }
    }

    private void mergeProperties(Element primary, Element secondary, Element toReturn) {
        Element prop;
        Iterator it;
        Element secondarySource;
        Element primarySource = primary != null ? primary.getChild("properties") : null;
        Element element = secondarySource = secondary != null ? secondary.getChild("properties") : null;
        if (primarySource == null && secondarySource == null) {
            return;
        }
        Element root = factory.element("properties");
        if (primarySource != null) {
            it = primarySource.getChildren().iterator();
            while (it.hasNext()) {
                prop = (Element)it.next();
                root.addContent((Content)this.copyTree(prop));
            }
        }
        if (secondarySource != null) {
            it = secondarySource.getChildren("").iterator();
            while (it.hasNext()) {
                prop = (Element)it.next();
                root.addContent((Content)this.copyTree(prop));
            }
        }
    }

    static String makeRelativePath(File basedir, String path) throws IOException {
        String canonicalBasedir = basedir.getCanonicalPath();
        String canonicalPath = new File(path).getCanonicalPath();
        if (canonicalPath.equals(canonicalBasedir)) {
            return ".";
        }
        if (canonicalPath.startsWith(canonicalBasedir)) {
            canonicalPath = canonicalPath.charAt(canonicalBasedir.length()) == File.separatorChar ? canonicalPath.substring(canonicalBasedir.length() + 1) : canonicalPath.substring(canonicalBasedir.length());
        }
        return canonicalPath;
    }
}

