/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.context;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.project.BaseObject;
import org.apache.maven.project.Branch;
import org.apache.maven.project.Build;
import org.apache.maven.project.Contributor;
import org.apache.maven.project.Dependency;
import org.apache.maven.project.Developer;
import org.apache.maven.project.License;
import org.apache.maven.project.MailingList;
import org.apache.maven.project.Organization;
import org.apache.maven.project.Project;
import org.apache.maven.project.Repository;
import org.apache.maven.project.Resource;
import org.apache.maven.project.SourceModification;
import org.apache.maven.project.UnitTest;
import org.apache.maven.project.Version;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.mevenide.context.IProjectUnmarshaller;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JDomProjectUnmarshaller
implements IProjectUnmarshaller {
    private static final Log logger = LogFactory.getLog((Class)JDomProjectUnmarshaller.class);
    private static final String PROPERTY_SEPARATOR = ":";
    private static final String EMPTY_STR = "";

    public Project parse(Reader reader) throws Exception {
        SAXBuilder builder = new SAXBuilder();
        builder.setExpandEntities(true);
        logger.fatal((Object)"deprecated. no way to create a reasonable entity resolver.");
        Document document = builder.build(reader);
        return this.generateProject(document.getRootElement());
    }

    public Project parse(File file) throws Exception {
        return this.generateProject(this.parseRootElement(file));
    }

    public Element parseRootElement(File file) throws Exception {
        SAXBuilder builder = new SAXBuilder();
        builder.setExpandEntities(true);
        builder.setEntityResolver((EntityResolver)new EntResolver(file.getParentFile()));
        Document document = builder.build(file);
        return document.getRootElement();
    }

    public Element parseRootElement(Reader reader) throws Exception {
        SAXBuilder builder = new SAXBuilder();
        builder.setExpandEntities(false);
        Document document = builder.build(reader);
        return document.getRootElement();
    }

    public Project generateProject(Element projectElement) {
        Project mavenProject = new Project();
        mavenProject.setExtend(projectElement.getChildText("extend"));
        mavenProject.setPomVersion(projectElement.getChildText("pomVersion"));
        mavenProject.setName(projectElement.getChildText("name"));
        String id = projectElement.getChildText("id");
        String groupId = projectElement.getChildText("groupId");
        String artifactId = projectElement.getChildText("artifactId");
        mavenProject.setId(id);
        mavenProject.setGroupId(groupId);
        mavenProject.setArtifactId(artifactId);
        mavenProject.setCurrentVersion(projectElement.getChildText("currentVersion"));
        mavenProject.setInceptionYear(projectElement.getChildText("inceptionYear"));
        mavenProject.setPackage(projectElement.getChildText("package"));
        mavenProject.setLogo(projectElement.getChildText("logo"));
        mavenProject.setGumpRepositoryId(projectElement.getChildText("gumpRepositoryId"));
        mavenProject.setDescription(projectElement.getChildText("description"));
        mavenProject.setShortDescription(projectElement.getChildText("shortDescription"));
        mavenProject.setUrl(projectElement.getChildText("url"));
        mavenProject.setIssueTrackingUrl(projectElement.getChildText("issueTrackingUrl"));
        mavenProject.setSiteAddress(projectElement.getChildText("siteAddress"));
        mavenProject.setSiteDirectory(projectElement.getChildText("siteDirectory"));
        mavenProject.setDistributionSite(projectElement.getChildText("distributionSite"));
        mavenProject.setDistributionDirectory(projectElement.getChildText("distributionDirectory"));
        mavenProject.setOrganization(this.parseOrganization(projectElement));
        mavenProject.setRepository(this.parseRepository(projectElement));
        mavenProject.setVersions(this.parseVersions(projectElement));
        mavenProject.setBranches(this.parseBranches(projectElement));
        mavenProject.setMailingLists(this.parseMailingLists(projectElement));
        mavenProject.setDevelopers(this.parseDevelopers(projectElement));
        mavenProject.setContributors(this.parseContributors(projectElement));
        mavenProject.setLicenses(this.parseLicenses(projectElement));
        mavenProject.setDependencies(this.parseDependencies(projectElement));
        mavenProject.setBuild(this.parseBuild(projectElement));
        mavenProject.setReports(this.parseReports(projectElement));
        List properties = this.parseProperties(projectElement);
        if (properties != null && properties.size() > 0) {
            mavenProject.setProperties(properties);
            this.populateResolvedProperties((BaseObject)mavenProject, properties);
        }
        return mavenProject;
    }

    private void populateResolvedProperties(BaseObject obj, List properties) {
        if (properties != null && properties.size() > 0) {
            for (int i = 0; i < properties.size(); ++i) {
                String[] prop = JDomProjectUnmarshaller.resolveProperty((String)properties.get(i));
                obj.resolvedProperties().put(prop[0], prop[1]);
            }
        }
    }

    private Organization parseOrganization(Element projectElement) {
        Organization organization = null;
        Element elem = projectElement.getChild("organization");
        if (elem != null) {
            organization = new Organization();
            organization.setName(elem.getChildText("name"));
            organization.setUrl(elem.getChildText("url"));
            organization.setLogo(elem.getChildText("logo"));
        }
        return organization;
    }

    private List parseVersions(Element projectElement) {
        List versionElements;
        ArrayList<Version> versions = null;
        Element versionsElement = projectElement.getChild("versions");
        if (versionsElement != null && (versionElements = versionsElement.getChildren("version")) != null && versionElements.size() > 0) {
            versions = new ArrayList<Version>();
            for (int i = 0; i < versionElements.size(); ++i) {
                Element versionElement = (Element)versionElements.get(i);
                Version version = new Version();
                version.setId(versionElement.getChildText("id"));
                version.setName(versionElement.getChildText("name"));
                version.setTag(versionElement.getChildText("tag"));
                versions.add(version);
            }
        }
        return versions;
    }

    private List parseDevelopers(Element projectElement) {
        List developerElements;
        ArrayList<Developer> developers = null;
        Element developersElement = projectElement.getChild("developers");
        if (developersElement != null && (developerElements = developersElement.getChildren("developer")) != null && developerElements.size() > 0) {
            developers = new ArrayList<Developer>();
            for (int i = 0; i < developerElements.size(); ++i) {
                Element developerElement = (Element)developerElements.get(i);
                Developer developer = new Developer();
                developer.setName(developerElement.getChildText("name"));
                developer.setId(developerElement.getChildText("id"));
                developer.setEmail(developerElement.getChildText("email"));
                developer.setOrganization(developerElement.getChildText("organization"));
                List roles = this.parseRoles(developerElement);
                if (roles != null && roles.size() > 0) {
                    for (int j = 0; j < roles.size(); ++j) {
                        developer.addRole((String)roles.get(j));
                    }
                }
                developer.setUrl(developerElement.getChildText("url"));
                developer.setTimezone(developerElement.getChildText("timezone"));
                developers.add(developer);
            }
        }
        return developers;
    }

    private List parseContributors(Element projectElement) {
        List contributorElements;
        ArrayList<Contributor> contributors = null;
        Element contributorsElement = projectElement.getChild("contributors");
        if (contributorsElement != null && (contributorElements = contributorsElement.getChildren("contributor")) != null && contributorElements.size() > 0) {
            contributors = new ArrayList<Contributor>();
            for (int i = 0; i < contributorElements.size(); ++i) {
                Element contributorElement = (Element)contributorElements.get(i);
                Contributor contributor = new Contributor();
                contributor.setName(contributorElement.getChildText("name"));
                contributor.setEmail(contributorElement.getChildText("email"));
                contributor.setOrganization(contributorElement.getChildText("organization"));
                List roles = this.parseRoles(contributorElement);
                if (roles != null && roles.size() > 0) {
                    for (int j = 0; j < roles.size(); ++j) {
                        contributor.addRole((String)roles.get(j));
                    }
                }
                contributor.setUrl(contributorElement.getChildText("url"));
                contributor.setTimezone(contributorElement.getChildText("timezone"));
                contributors.add(contributor);
            }
        }
        return contributors;
    }

    private List parseRoles(Element developerElement) {
        List roleElements;
        ArrayList<String> roles = null;
        Element rolesElement = developerElement.getChild("roles");
        if (rolesElement != null && (roleElements = rolesElement.getChildren("role")) != null && roleElements.size() > 0) {
            roles = new ArrayList<String>();
            for (int i = 0; i < roleElements.size(); ++i) {
                Element roleElement = (Element)roleElements.get(i);
                String role = roleElement.getText();
                roles.add(role);
            }
        }
        return roles;
    }

    private List parseDependencies(Element projectElement) {
        List dependencyElements;
        ArrayList<Dependency> dependencies = null;
        Element dependenciesElement = projectElement.getChild("dependencies");
        if (dependenciesElement != null && (dependencyElements = dependenciesElement.getChildren("dependency")) != null && dependencyElements.size() > 0) {
            dependencies = new ArrayList<Dependency>();
            for (int i = 0; i < dependencyElements.size(); ++i) {
                Element dependencyElement = (Element)dependencyElements.get(i);
                Dependency dependency = new Dependency();
                String id = dependencyElement.getChildText("id");
                if (id != null) {
                    dependency.setId(id);
                }
                if ((id = dependencyElement.getChildText("groupId")) != null) {
                    dependency.setGroupId(id);
                }
                if ((id = dependencyElement.getChildText("artifactId")) != null) {
                    dependency.setArtifactId(id);
                }
                dependency.setVersion(dependencyElement.getChildText("version"));
                String jar = dependencyElement.getChildText("jar");
                if (jar != null) {
                    dependency.setJar(dependencyElement.getChildText("jar"));
                }
                dependency.setType(dependencyElement.getChildText("type"));
                dependency.setUrl(dependencyElement.getChildText("url"));
                List properties = this.parseProperties(dependencyElement);
                if (properties != null && properties.size() > 0) {
                    dependency.setProperties(properties);
                    this.populateResolvedProperties((BaseObject)dependency, properties);
                }
                dependencies.add(dependency);
            }
        }
        return dependencies;
    }

    private List parseLicenses(Element projectElement) {
        List licenseElements;
        ArrayList<License> licenses = null;
        Element licensesElement = projectElement.getChild("licenses");
        if (licensesElement != null && (licenseElements = licensesElement.getChildren("license")) != null && licenseElements.size() > 0) {
            licenses = new ArrayList<License>();
            for (int i = 0; i < licenseElements.size(); ++i) {
                Element licenseElement = (Element)licenseElements.get(i);
                License license = new License();
                license.setName(licenseElement.getChildText("name"));
                license.setUrl(licenseElement.getChildText("url"));
                license.setDistribution(licenseElement.getChildText("distribution"));
                licenses.add(license);
            }
        }
        return licenses;
    }

    private List parseReports(Element projectElement) {
        List reportElements;
        ArrayList<String> reports = null;
        Element reportsElement = projectElement.getChild("reports");
        if (reportsElement != null && (reportElements = reportsElement.getChildren("report")) != null && reportElements.size() > 0) {
            reports = new ArrayList<String>();
            for (int i = 0; i < reportElements.size(); ++i) {
                Element reportElement = (Element)reportElements.get(i);
                String report = reportElement.getText();
                reports.add(report);
            }
        }
        return reports;
    }

    private List parseBranches(Element projectElement) {
        List branchElements;
        ArrayList<Branch> branches = null;
        Element branchesElement = projectElement.getChild("branches");
        if (branchesElement != null && (branchElements = branchesElement.getChildren("branch")) != null && branchElements.size() > 0) {
            branches = new ArrayList<Branch>();
            for (int i = 0; i < branchElements.size(); ++i) {
                Element branchElement = (Element)branchElements.get(i);
                Branch branch = new Branch();
                branch.setTag(branchElement.getChildText("tag"));
                branches.add(branch);
            }
        }
        return branches;
    }

    private List parseMailingLists(Element projectElement) {
        List mailingListElements;
        ArrayList<MailingList> mailingLists = null;
        Element mailingListsElement = projectElement.getChild("mailingLists");
        if (mailingListsElement != null && (mailingListElements = mailingListsElement.getChildren("mailingList")) != null && mailingListElements.size() > 0) {
            mailingLists = new ArrayList<MailingList>();
            for (int i = 0; i < mailingListElements.size(); ++i) {
                Element mailingListElement = (Element)mailingListElements.get(i);
                MailingList mailingList = new MailingList();
                mailingList.setName(mailingListElement.getChildText("name"));
                mailingList.setSubscribe(mailingListElement.getChildText("subscribe"));
                mailingList.setUnsubscribe(mailingListElement.getChildText("unsubscribe"));
                mailingList.setArchive(mailingListElement.getChildText("archive"));
                mailingLists.add(mailingList);
            }
        }
        return mailingLists;
    }

    private List parseProperties(Element element) {
        List propertiesElements;
        ArrayList<String> properties = null;
        Element propertiesElement = element.getChild("properties");
        if (propertiesElement != null && (propertiesElements = propertiesElement.getChildren()) != null && propertiesElements.size() > 0) {
            properties = new ArrayList<String>();
            for (int i = 0; i < propertiesElements.size(); ++i) {
                Element propertyElement = (Element)propertiesElements.get(i);
                String property = propertyElement.getName() + PROPERTY_SEPARATOR + (propertyElement.getText() == null || propertyElement.getText().length() == 0 ? " " : propertyElement.getText());
                properties.add(property);
            }
        }
        return properties;
    }

    private Repository parseRepository(Element projectElement) {
        Repository repository = null;
        Element elem = projectElement.getChild("repository");
        if (elem != null) {
            repository = new Repository();
            repository.setConnection(elem.getChildText("connection"));
            repository.setDeveloperConnection(elem.getChildText("developerConnection"));
            repository.setUrl(elem.getChildText("url"));
        }
        return repository;
    }

    private Build parseBuild(Element projectElement) {
        Build build = null;
        Element buildElement = projectElement.getChild("build");
        if (buildElement != null) {
            build = new Build();
            build.setNagEmailAddress(buildElement.getChildText("nagEmailAddress"));
            build.setSourceDirectory(buildElement.getChildText("sourceDirectory"));
            build.setSourceModification(this.parseSourceModifications(buildElement));
            build.setUnitTestSourceDirectory(buildElement.getChildText("unitTestSourceDirectory"));
            build.setAspectSourceDirectory(buildElement.getChildText("aspectSourceDirectory"));
            build.setUnitTest(this.parseUnitTest(buildElement));
            build.setResources(this.parseResources(buildElement));
        }
        return build;
    }

    private UnitTest parseUnitTest(Element buildElement) {
        UnitTest unitTest = null;
        Element unitTestElement = buildElement.getChild("unitTest");
        if (unitTestElement != null) {
            List excludes;
            unitTest = new UnitTest();
            List includes = this.parseIncludes(unitTestElement);
            if (includes != null && includes.size() > 0) {
                for (int j = 0; j < includes.size(); ++j) {
                    unitTest.addInclude((String)includes.get(j));
                }
            }
            if ((excludes = this.parseExcludes(unitTestElement)) != null && excludes.size() > 0) {
                for (int j = 0; j < excludes.size(); ++j) {
                    unitTest.addExclude((String)excludes.get(j));
                }
            }
            unitTest.setResources(this.parseResources(unitTestElement));
        }
        return unitTest;
    }

    private List parseResources(Element element) {
        List resourceElements;
        ArrayList<Resource> resources = null;
        Element resourcesElement = element.getChild("resources");
        if (resourcesElement != null && (resourceElements = resourcesElement.getChildren("resource")) != null && resourceElements.size() > 0) {
            resources = new ArrayList<Resource>();
            for (int i = 0; i < resourceElements.size(); ++i) {
                List excludes;
                Element resourceElement = (Element)resourceElements.get(i);
                Resource resource = new Resource();
                resource.setDirectory(resourceElement.getChildText("directory"));
                resource.setTargetPath(resourceElement.getChildText("targetPath"));
                String filtering = resourceElement.getChildText("filtering");
                resource.setFiltering("true".equals(filtering));
                List includes = this.parseIncludes(resourceElement);
                if (includes != null && includes.size() > 0) {
                    for (int j = 0; j < includes.size(); ++j) {
                        resource.addInclude((String)includes.get(j));
                    }
                }
                if ((excludes = this.parseExcludes(resourceElement)) != null && excludes.size() > 0) {
                    for (int j = 0; j < excludes.size(); ++j) {
                        resource.addExclude((String)excludes.get(j));
                    }
                }
                resources.add(resource);
            }
        }
        return resources;
    }

    private List parseSourceModifications(Element buildElement) {
        List sourceModificationElements;
        ArrayList<SourceModification> sourceModifications = null;
        Element sourceModificationsElement = buildElement.getChild("sourceModifications");
        if (sourceModificationsElement != null && (sourceModificationElements = sourceModificationsElement.getChildren("sourceModification")) != null && sourceModificationElements.size() > 0) {
            sourceModifications = new ArrayList<SourceModification>();
            for (int i = 0; i < sourceModificationElements.size(); ++i) {
                List excludes;
                Element sourceModificationElement = (Element)sourceModificationElements.get(i);
                SourceModification sourceModification = new SourceModification();
                sourceModification.setClassName(sourceModificationElement.getChildText("className"));
                List includes = this.parseIncludes(sourceModificationElement);
                if (includes != null && includes.size() > 0) {
                    for (int j = 0; j < includes.size(); ++j) {
                        sourceModification.addInclude((String)includes.get(j));
                    }
                }
                if ((excludes = this.parseExcludes(sourceModificationElement)) != null && excludes.size() > 0) {
                    for (int j = 0; j < excludes.size(); ++j) {
                        sourceModification.addExclude((String)excludes.get(j));
                    }
                }
                sourceModifications.add(sourceModification);
            }
        }
        return sourceModifications;
    }

    private List parseIncludes(Element element) {
        List includeElements;
        ArrayList<String> includes = null;
        Element includesElement = element.getChild("includes");
        if (includesElement != null && (includeElements = includesElement.getChildren("include")) != null && includeElements.size() > 0) {
            includes = new ArrayList<String>();
            for (int i = 0; i < includeElements.size(); ++i) {
                Element includeElement = (Element)includeElements.get(i);
                String include = includeElement.getText();
                includes.add(include);
            }
        }
        return includes;
    }

    private List parseExcludes(Element element) {
        List excludeElements;
        ArrayList<String> excludes = null;
        Element excludesElement = element.getChild("excludes");
        if (excludesElement != null && (excludeElements = excludesElement.getChildren("exclude")) != null && excludeElements.size() > 0) {
            excludes = new ArrayList<String>();
            for (int i = 0; i < excludeElements.size(); ++i) {
                Element excludeElement = (Element)excludeElements.get(i);
                String exclude = excludeElement.getText();
                excludes.add(exclude);
            }
        }
        return excludes;
    }

    private static String[] resolveProperty(String property) {
        String[] parts = property.split(PROPERTY_SEPARATOR);
        String name = parts[0];
        String value = parts.length > 1 ? parts[1] : EMPTY_STR;
        return new String[]{name, value};
    }

    static File normalizeFile(File file) {
        String osName = System.getProperty("os.name");
        boolean isWindows = osName.startsWith("Wind");
        if (isWindows) {
            if (file.getParent() != null) {
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException e) {
                    logger.warn((Object)("getCanonicalFile() on file " + file + " failed. " + e.toString()));
                    file = file.getAbsoluteFile();
                }
            } else {
                file = file.getAbsoluteFile();
            }
        } else {
            file = new File(file.toURI().normalize()).getAbsoluteFile();
        }
        return file;
    }

    private class EntResolver
    implements EntityResolver {
        private File directory;

        EntResolver(File dir) {
            this.directory = dir;
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            logger.debug((Object)("resolver" + systemId));
            if (systemId.startsWith("file:")) {
                String path = systemId.substring("file:".length());
                File file = new File(this.directory, path);
                int index = path.indexOf("file:");
                if (index > -1) {
                    path = path.substring(0, index) + path.substring(index + "file:".length());
                    file = new File(path);
                }
                logger.debug((Object)("path=" + path));
                file = JDomProjectUnmarshaller.normalizeFile(file);
                if (file.exists()) {
                    return new InputSource(new FileReader(file));
                }
            }
            return new InputSource(systemId);
        }
    }
}

