/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.environment;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.context.DefaultQueryContext;
import org.mevenide.context.IQueryContext;
import org.mevenide.environment.CustomLocationFinder;
import org.mevenide.environment.ILocationFinder;
import org.mevenide.environment.SysEnvLocationFinder;
import org.mevenide.properties.IPropertyResolver;

public class LocationFinderAggregator
implements ILocationFinder {
    private static Log log = LogFactory.getLog((Class)LocationFinderAggregator.class);
    private SysEnvLocationFinder sysEnvLocationFinder = SysEnvLocationFinder.getInstance();
    private CustomLocationFinder customLocationFinder;
    private IQueryContext context;
    private IPropertyResolver resolver;

    LocationFinderAggregator() {
        this(DefaultQueryContext.getNonProjectContextInstance());
    }

    public LocationFinderAggregator(IQueryContext queryContext) {
        this.context = queryContext;
        this.resolver = this.context.getResolver();
    }

    public String getConfigurationFileLocation() {
        File conf;
        if (this.getMavenHome() != null && (conf = new File(new File(this.getMavenHome(), "bin"), "forehead.conf")).exists()) {
            return conf.getAbsolutePath();
        }
        return null;
    }

    public String getJavaHome() {
        String resValue;
        String javaHome = System.getProperty("java.home");
        if (this.customLocationFinder != null && this.customLocationFinder.getJavaHome() != null) {
            javaHome = this.customLocationFinder.getJavaHome();
        }
        if ((resValue = this.resolver.getResolvedValue("java.home")) != null) {
            javaHome = resValue;
        }
        if (this.sysEnvLocationFinder != null && this.sysEnvLocationFinder.getJavaHome() != null) {
            javaHome = this.sysEnvLocationFinder.getJavaHome();
        }
        return javaHome;
    }

    public String getMavenHome() {
        String mavenHome = null;
        if (this.customLocationFinder != null && this.customLocationFinder.getMavenHome() != null) {
            mavenHome = this.customLocationFinder.getMavenHome();
        }
        mavenHome = this.resolver.getResolvedValue("maven.home");
        if (this.sysEnvLocationFinder != null && this.sysEnvLocationFinder.getMavenHome() != null) {
            mavenHome = this.sysEnvLocationFinder.getMavenHome();
        }
        return mavenHome;
    }

    public String getMavenLocalHome() {
        String resValue;
        String mavenLocalHome = new File(this.getUserHome(), ".maven").getAbsolutePath();
        if (this.customLocationFinder != null && this.customLocationFinder.getMavenLocalHome() != null) {
            mavenLocalHome = this.customLocationFinder.getMavenLocalHome();
        }
        if ((resValue = this.resolver.getResolvedValue("maven.home.local")) != null) {
            mavenLocalHome = resValue;
        }
        return mavenLocalHome;
    }

    public String getMavenLocalRepository() {
        String resValue;
        String mavenLocalRepository = new File(this.getMavenLocalHome(), "repository").getAbsolutePath();
        if (this.customLocationFinder != null && this.customLocationFinder.getMavenLocalRepository() != null) {
            mavenLocalRepository = this.customLocationFinder.getMavenLocalRepository();
        }
        if ((resValue = this.resolver.getResolvedValue("maven.repo.local")) != null) {
            mavenLocalRepository = resValue;
        }
        return mavenLocalRepository;
    }

    public String getMavenPluginsDir() {
        String resValue;
        String mavenPluginsDir = new File(this.getMavenLocalHome(), "cache").getAbsolutePath();
        if (this.customLocationFinder != null && this.customLocationFinder.getMavenPluginsDir() != null) {
            mavenPluginsDir = this.customLocationFinder.getMavenPluginsDir();
        }
        if ((resValue = this.resolver.getResolvedValue("maven.plugin.unpacked.dir")) != null) {
            mavenPluginsDir = resValue;
        }
        return mavenPluginsDir;
    }

    public String getUserHome() {
        String userHome = System.getProperty("user.home");
        if (this.sysEnvLocationFinder != null && this.sysEnvLocationFinder.getUserHome() != null) {
            userHome = this.sysEnvLocationFinder.getUserHome();
        }
        return userHome;
    }

    public void setCustomLocationFinder(CustomLocationFinder customLocationFinder) {
        this.customLocationFinder = customLocationFinder;
    }
}

