/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.environment;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.environment.AbstractLocationFinder;
import org.mevenide.environment.sysenv.DefaultSysEnvProvider;
import org.mevenide.environment.sysenv.SysEnvProvider;

public class SysEnvLocationFinder
extends AbstractLocationFinder {
    private static Log log = LogFactory.getLog((Class)SysEnvLocationFinder.class);
    private static SysEnvLocationFinder locationFinder;
    private static SysEnvProvider defaultProvider;
    private SysEnvProvider provider = null;
    private static Object LOCK;

    private SysEnvLocationFinder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SysEnvLocationFinder getInstance() {
        if (locationFinder == null) {
            Object object = LOCK;
            synchronized (object) {
                if (locationFinder == null) {
                    if (defaultProvider == null) {
                        defaultProvider = new DefaultSysEnvProvider();
                    }
                    locationFinder = new SysEnvLocationFinder();
                    locationFinder.setSysEnvProvider(defaultProvider);
                }
            }
        }
        return locationFinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultSysEnvProvider(SysEnvProvider prov) {
        Object object = LOCK;
        synchronized (object) {
            defaultProvider = prov;
            if (locationFinder != null) {
                locationFinder = null;
                log.warn((Object)"Setting defaultSysEnvProvider while the singleton isntance of SysEnvLocationFinder exists");
            }
        }
    }

    private void setSysEnvProvider(SysEnvProvider prov) {
        this.provider = prov;
    }

    public String getJavaHome() {
        return this.provider.getProperty("JAVA_HOME");
    }

    public String getMavenHome() {
        return this.provider.getProperty("MAVEN_HOME");
    }

    public String getMavenLocalHome() {
        return this.provider.getProperty("MAVEN_HOME_LOCAL");
    }

    public String getMavenLocalRepository() {
        return this.provider.getProperty("MAVEN_REPO_LOCAL");
    }

    public String getMavenPluginsDir() {
        return null;
    }

    public String getUserHome() {
        return System.getProperty("user.home");
    }

    static {
        defaultProvider = null;
        LOCK = new Object();
    }
}

