/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.environment.sysenv;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.environment.sysenv.SysEnvProvider;

public class DefaultSysEnvProvider
implements SysEnvProvider {
    private static Log log = LogFactory.getLog((Class)DefaultSysEnvProvider.class);
    private Properties envProperties;
    private boolean loaded = false;
    private Object LOCK = new Object();

    private void loadEnvironment() {
        try {
            this.envProperties = DefaultSysEnvProvider.getEnvVars();
        }
        catch (Exception exc) {
            log.error((Object)"Problem while looking for env. variables.", (Throwable)exc);
            this.envProperties = new Properties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProperty(String name) {
        if (!this.loaded) {
            Object object = this.LOCK;
            synchronized (object) {
                if (!this.loaded) {
                    this.loadEnvironment();
                    this.loaded = true;
                }
            }
        }
        return this.envProperties.getProperty(name);
    }

    private static Properties getEnvVars() throws IOException {
        String line;
        Process p = null;
        Properties envVars = new Properties();
        Runtime r = Runtime.getRuntime();
        String os = System.getProperty("os.name").toLowerCase();
        p = os.indexOf("windows") > -1 ? (os.indexOf("windows 9") > -1 ? r.exec("command.com /c set") : r.exec("cmd.exe /c set")) : r.exec("sh -l -c env");
        BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
        while ((line = br.readLine()) != null) {
            int idx = line.indexOf(61);
            if (idx <= 0) continue;
            String key = line.substring(0, idx);
            String value = line.substring(idx + 1);
            envVars.setProperty(key, value);
        }
        return envVars;
    }
}

