/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.properties.resolver;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.properties.IPropertyFinder;

public final class PluginPropertiesFinder
implements IPropertyFinder {
    private static final Log logger = LogFactory.getLog((Class)PluginPropertiesFinder.class);
    private File unpackedPluginDir;
    private File pluginDir;
    private File valid;
    private Properties props;
    private long lastModified = -1L;
    private Object LOCK = new Object();

    PluginPropertiesFinder(File unPlugDir, File packedDir) {
        this.unpackedPluginDir = unPlugDir;
        this.pluginDir = packedDir;
        this.valid = new File(this.pluginDir, "valid.cache");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValue(String key) {
        Object object = this.LOCK;
        synchronized (object) {
            this.checkReload();
            return this.props.getProperty(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getDefaultPluginKeys() {
        Object object = this.LOCK;
        synchronized (object) {
            this.checkReload();
            return new HashSet<Object>(this.props.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        Object object = this.LOCK;
        synchronized (object) {
            this.checkReload();
        }
    }

    private void checkReload() {
        long validStamp;
        long l = validStamp = this.valid.exists() ? this.valid.lastModified() : 0L;
        if (validStamp != this.lastModified) {
            this.loadAllProperties();
        }
        this.lastModified = validStamp;
    }

    private void loadAllProperties() {
        block3: {
            block2: {
                this.props = new Properties();
                if (!this.valid.exists() || !this.unpackedPluginDir.exists()) break block2;
                File[] plugins = this.unpackedPluginDir.listFiles();
                for (int i = 0; i < plugins.length; ++i) {
                    if (!plugins[i].isDirectory()) continue;
                    this.loadDefaults(this.props, plugins[i]);
                }
                break block3;
            }
            if (!this.pluginDir.exists()) break block3;
            File[] plugins = this.pluginDir.listFiles();
            for (int i = 0; i < plugins.length; ++i) {
                if (!plugins[i].isFile() || !plugins[i].getName().endsWith("jar")) continue;
                this.loadJarDefaults(this.props, plugins[i]);
            }
        }
    }

    private void loadDefaults(Properties pros, File dir) {
        File propFile = new File(dir, "plugin.properties");
        if (propFile.exists()) {
            try {
                pros.load(new BufferedInputStream(new FileInputStream(propFile)));
            }
            catch (IOException exc) {
                logger.warn((Object)("Cannot read defaults from file:" + propFile), (Throwable)exc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadJarDefaults(Properties pros, File jarFile) {
        JarFile jf = null;
        try {
            jf = new JarFile(jarFile);
            JarEntry je = jf.getJarEntry("plugin.properties");
            if (je != null) {
                pros.load(new BufferedInputStream(jf.getInputStream(je)));
            }
        }
        catch (IOException exc) {
            logger.warn((Object)("Cannot read defaults from file:" + jarFile), (Throwable)exc);
        }
        finally {
            if (jf != null) {
                try {
                    jf.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

