/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.properties.resolver;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.properties.IPropertyFinder;
import org.mevenide.properties.KeyValuePair;
import org.mevenide.properties.PropertyModel;
import org.mevenide.properties.PropertyModelFactory;

final class SinglePropertyFileFinder
implements IPropertyFinder {
    private static final Log logger = LogFactory.getLog((Class)SinglePropertyFileFinder.class);
    private File propFile = null;
    private PropertyModel propModel = null;
    private boolean regenerate;
    private boolean skip = false;

    SinglePropertyFileFinder(File file) {
        this.propFile = file;
        this.regenerate = true;
        this.skip = false;
    }

    public String getValue(String key) {
        if (!this.skip) {
            try {
                if (this.regenerate) {
                    this.readModel();
                }
            }
            catch (IOException exc) {
                logger.error((Object)"Cannot read file", (Throwable)exc);
                this.skip = true;
                return null;
            }
            KeyValuePair pair = this.propModel.findByKey(key);
            if (pair != null) {
                return pair.getValue();
            }
        }
        return null;
    }

    private void readModel() throws IOException {
        this.propModel = PropertyModelFactory.getFactory().newPropertyModel(new FileInputStream(this.propFile));
    }

    public void reload() {
        this.skip = false;
        this.regenerate = true;
    }
}

