/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.project;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.project.Branch;
import org.apache.maven.project.Build;
import org.apache.maven.project.Contributor;
import org.apache.maven.project.Dependency;
import org.apache.maven.project.Developer;
import org.apache.maven.project.License;
import org.apache.maven.project.MailingList;
import org.apache.maven.project.Organization;
import org.apache.maven.project.Project;
import org.apache.maven.project.Repository;
import org.apache.maven.project.Resource;
import org.apache.maven.project.SourceModification;
import org.apache.maven.project.UnitTest;
import org.apache.maven.project.Version;
import org.mevenide.project.IProjectChangeListener;
import org.mevenide.project.ProjectChangeEvent;
import org.mevenide.project.ProjectComparatorFactory;
import org.mevenide.util.MevenideUtils;

public class ProjectComparator {
    private static final Log log = LogFactory.getLog((Class)ProjectComparator.class);
    public static final String PROJECT = "PROJECT";
    public static final String ORGANIZATION = "ORGANIZATION";
    public static final String REPOSITORY = "REPOSITORY";
    public static final String BRANCHES = "BRANCHES";
    public static final String VERSIONS = "VERSIONS";
    public static final String MAILINGLISTS = "MAILINGLISTS";
    public static final String CONTRIBUTORS = "CONTRIBUTORS";
    public static final String DEVELOPERS = "DEVELOPERS";
    public static final String LICENSES = "LICENSES";
    public static final String DEPENDENCIES = "DEPENDENCIES";
    public static final String BUILD = "BUILD";
    public static final String UNIT_TESTS = "UNIT_TESTS";
    public static final String RESOURCES = "RESOURCES";
    public static final String REPORTS = "REPORTS";
    public static final Project NULL_PROJECT = new Project();
    private Project originalProject;
    private Hashtable subModelListenerTable = new Hashtable();
    private Vector generalListeners = new Vector(5);
    private volatile boolean projectChanged = false;

    protected ProjectComparator(Project project) {
        this.originalProject = project;
    }

    public void addProjectChangeListener(IProjectChangeListener listener) {
        this.generalListeners.add(listener);
    }

    public void addProjectChangeListener(String subModel, IProjectChangeListener listener) {
        Vector<IProjectChangeListener> subModelListeners = (Vector<IProjectChangeListener>)this.subModelListenerTable.get(subModel);
        if (subModelListeners == null) {
            subModelListeners = new Vector<IProjectChangeListener>(5);
            this.subModelListenerTable.put(subModel, subModelListeners);
        }
        subModelListeners.add(listener);
    }

    public void removeProjectChangeListener(IProjectChangeListener listener) {
        this.generalListeners.remove(listener);
    }

    public void removeProjectChangeListener(String subModel, IProjectChangeListener listener) {
        Vector subModelListeners = (Vector)this.subModelListenerTable.get(subModel);
        if (subModelListeners != null) {
            subModelListeners.remove(listener);
        }
    }

    private void fireProjectChangeEvent(Project newProject, String subModel) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Firing ProjectChangeEvent with change in " + subModel));
        }
        ProjectChangeEvent e = null;
        e = newProject != null ? new ProjectChangeEvent(newProject, subModel) : new ProjectChangeEvent(NULL_PROJECT, subModel);
        this.projectChanged = true;
        Iterator itr = this.generalListeners.iterator();
        while (itr.hasNext()) {
            IProjectChangeListener listener = (IProjectChangeListener)itr.next();
            listener.projectChanged(e);
        }
        Vector subModelListeners = (Vector)this.subModelListenerTable.get(subModel);
        if (subModelListeners != null) {
            itr = subModelListeners.iterator();
            while (itr.hasNext()) {
                IProjectChangeListener listener = (IProjectChangeListener)itr.next();
                listener.projectChanged(e);
            }
        }
    }

    private boolean comparable(Object newValue, Object oldValue) {
        return newValue != null || oldValue != null;
    }

    private void detectObjectChange(Object newObject, Object oldObject) throws ShortCircuitException {
        if (!(newObject != null && oldObject != null || newObject == null && oldObject == null)) {
            throw new ShortCircuitException();
        }
    }

    private void detectAttributeChange(Object newValue, Object oldValue) throws ShortCircuitException {
        if (MevenideUtils.notEquivalent(newValue, oldValue)) {
            throw new ShortCircuitException();
        }
    }

    private void detectAttributeChange(boolean newValue, boolean oldValue) throws ShortCircuitException {
        if (newValue != oldValue) {
            throw new ShortCircuitException();
        }
    }

    private void detectCollectionChange(Collection newValue, Collection oldValue) throws ShortCircuitException {
        if (oldValue.size() != newValue.size()) {
            throw new ShortCircuitException();
        }
    }

    public void compare(Project newProject) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Computing project difference...");
        }
        if (newProject != this.originalProject) {
            if (newProject == null || this.originalProject == null) {
                this.fireProjectChangeEvent(newProject, PROJECT);
            } else {
                this.compareProject(newProject);
                this.compareOrganization(newProject);
                this.compareRepository(newProject);
                this.compareBranches(newProject);
                this.compareVersions(newProject);
                this.compareMailingLists(newProject);
                this.compareContributors(newProject);
                this.compareDevelopers(newProject);
                this.compareLicenses(newProject);
                this.compareDependencies(newProject);
                this.compareBuild(newProject);
                this.compareReports(newProject);
                try {
                    this.compareProperties(newProject.getProperties(), this.originalProject.getProperties());
                }
                catch (ShortCircuitException e) {
                    this.fireProjectChangeEvent(newProject, PROJECT);
                }
            }
            this.updateProject(newProject);
        }
    }

    private void updateProject(Project newProject) {
        if (this.projectChanged) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Projects differ.  Updating comparator with new project.");
            }
            ProjectComparatorFactory.updateComparator(this.originalProject, newProject);
            this.originalProject = newProject;
            this.projectChanged = false;
        }
    }

    private void compareProject(Project newProject) {
        try {
            this.detectAttributeChange(newProject.getName(), this.originalProject.getName());
            this.detectAttributeChange(newProject.getArtifactId(), this.originalProject.getArtifactId());
            this.detectAttributeChange(newProject.getGroupId(), this.originalProject.getGroupId());
            this.detectAttributeChange(newProject.getGumpRepositoryId(), this.originalProject.getGumpRepositoryId());
            this.detectAttributeChange(newProject.getExtend(), this.originalProject.getExtend());
            this.detectAttributeChange(newProject.getPomVersion(), this.originalProject.getPomVersion());
            this.detectAttributeChange(newProject.getCurrentVersion(), this.originalProject.getCurrentVersion());
            this.detectAttributeChange(newProject.getLogo(), this.originalProject.getLogo());
            this.detectAttributeChange(newProject.getInceptionYear(), this.originalProject.getInceptionYear());
            this.detectAttributeChange(newProject.getUrl(), this.originalProject.getUrl());
            this.detectAttributeChange(newProject.getPackage(), this.originalProject.getPackage());
            this.detectAttributeChange(newProject.getShortDescription(), this.originalProject.getShortDescription());
            this.detectAttributeChange(newProject.getDescription(), this.originalProject.getDescription());
            this.detectAttributeChange(newProject.getDistributionDirectory(), this.originalProject.getDistributionDirectory());
            this.detectAttributeChange(newProject.getDistributionSite(), this.originalProject.getDistributionSite());
            this.detectAttributeChange(newProject.getIssueTrackingUrl(), this.originalProject.getIssueTrackingUrl());
            this.detectAttributeChange(newProject.getSiteAddress(), this.originalProject.getSiteAddress());
            this.detectAttributeChange(newProject.getSiteDirectory(), this.originalProject.getSiteDirectory());
        }
        catch (ShortCircuitException e) {
            this.fireProjectChangeEvent(newProject, PROJECT);
        }
    }

    private void compareOrganization(Project newProject) {
        Organization originalOrg;
        Organization newOrg = newProject.getOrganization();
        if (this.comparable(newOrg, originalOrg = this.originalProject.getOrganization())) {
            try {
                this.detectObjectChange(newOrg, originalOrg);
                this.detectAttributeChange(newOrg.getName(), originalOrg.getName());
                this.detectAttributeChange(newOrg.getLogo(), originalOrg.getLogo());
                this.detectAttributeChange(newOrg.getUrl(), originalOrg.getUrl());
            }
            catch (ShortCircuitException e) {
                this.fireProjectChangeEvent(newProject, ORGANIZATION);
            }
        }
    }

    private void compareRepository(Project newProject) {
        Repository originalRepo;
        Repository newRepo = newProject.getRepository();
        if (this.comparable(newRepo, originalRepo = this.originalProject.getRepository())) {
            try {
                this.detectObjectChange(newRepo, originalRepo);
                this.detectAttributeChange(newRepo.getName(), originalRepo.getName());
                this.detectAttributeChange(newRepo.getConnection(), originalRepo.getConnection());
                this.detectAttributeChange(newRepo.getDeveloperConnection(), originalRepo.getDeveloperConnection());
                this.detectAttributeChange(newRepo.getUrl(), originalRepo.getUrl());
            }
            catch (ShortCircuitException e) {
                this.fireProjectChangeEvent(newProject, REPOSITORY);
            }
        }
    }

    private void compareBranches(Project newProject) {
        List newBranches = newProject.getBranches();
        List origBranches = this.originalProject.getBranches();
        try {
            if (this.comparable(newBranches, origBranches)) {
                this.detectObjectChange(newBranches, origBranches);
                this.detectCollectionChange(newBranches, origBranches);
                for (int i = 0; i < origBranches.size(); ++i) {
                    Branch newBranch = (Branch)newBranches.get(i);
                    Branch origBranch = (Branch)origBranches.get(i);
                    this.detectAttributeChange(newBranch.getName(), origBranch.getName());
                    this.detectAttributeChange(newBranch.getTag(), origBranch.getTag());
                }
            }
        }
        catch (ShortCircuitException e) {
            this.fireProjectChangeEvent(newProject, BRANCHES);
        }
    }

    private void compareVersions(Project newProject) {
        List origVersions;
        List newVersions = newProject.getVersions();
        if (this.comparable(newVersions, origVersions = this.originalProject.getVersions())) {
            try {
                this.detectObjectChange(newVersions, origVersions);
                this.detectCollectionChange(newVersions, origVersions);
                for (int i = 0; i < origVersions.size(); ++i) {
                    Version newVersion = (Version)newVersions.get(i);
                    Version origVersion = (Version)origVersions.get(i);
                    this.detectAttributeChange(newVersion.getId(), origVersion.getId());
                    this.detectAttributeChange(newVersion.getName(), origVersion.getName());
                    this.detectAttributeChange(newVersion.getTag(), origVersion.getTag());
                }
            }
            catch (ShortCircuitException e) {
                this.fireProjectChangeEvent(newProject, VERSIONS);
            }
        }
    }

    private void compareMailingLists(Project newProject) {
        List origMailingLists;
        List newMailingLists = newProject.getMailingLists();
        if (this.comparable(newMailingLists, origMailingLists = this.originalProject.getMailingLists())) {
            try {
                this.detectObjectChange(newMailingLists, origMailingLists);
                this.detectCollectionChange(newMailingLists, origMailingLists);
                for (int i = 0; i < origMailingLists.size(); ++i) {
                    MailingList newMailingList = (MailingList)newMailingLists.get(i);
                    MailingList origMailingList = (MailingList)origMailingLists.get(i);
                    this.detectAttributeChange(newMailingList.getName(), origMailingList.getName());
                    this.detectAttributeChange(newMailingList.getArchive(), origMailingList.getArchive());
                    this.detectAttributeChange(newMailingList.getSubscribe(), origMailingList.getSubscribe());
                    this.detectAttributeChange(newMailingList.getUnsubscribe(), origMailingList.getUnsubscribe());
                }
            }
            catch (ShortCircuitException e) {
                this.fireProjectChangeEvent(newProject, MAILINGLISTS);
            }
        }
    }

    private void compareContributors(Project newProject) {
        List origContributors;
        List newContributors = newProject.getContributors();
        if (this.comparable(newContributors, origContributors = this.originalProject.getContributors())) {
            try {
                this.detectObjectChange(newContributors, origContributors);
                this.detectCollectionChange(newContributors, origContributors);
                for (int i = 0; i < origContributors.size(); ++i) {
                    this.compareContributor((Contributor)newContributors.get(i), (Contributor)origContributors.get(i));
                }
            }
            catch (ShortCircuitException e) {
                this.fireProjectChangeEvent(newProject, CONTRIBUTORS);
            }
        }
    }

    private void compareContributor(Contributor newContributor, Contributor origContributor) throws ShortCircuitException {
        this.detectAttributeChange(newContributor.getName(), origContributor.getName());
        this.detectAttributeChange(newContributor.getEmail(), origContributor.getEmail());
        this.detectAttributeChange(newContributor.getOrganization(), origContributor.getOrganization());
        this.detectAttributeChange(newContributor.getTimezone(), origContributor.getTimezone());
        this.detectAttributeChange(newContributor.getUrl(), origContributor.getUrl());
        SortedSet origRoles = origContributor.getRoles();
        SortedSet newRoles = newContributor.getRoles();
        this.detectObjectChange(newRoles, origRoles);
        this.detectCollectionChange(newRoles, origRoles);
        Iterator itrOrig = origRoles.iterator();
        Iterator itrNew = newRoles.iterator();
        while (itrOrig.hasNext()) {
            this.detectAttributeChange(itrNew.next().toString(), itrOrig.next().toString());
        }
    }

    private void compareDevelopers(Project newProject) {
        List origDevelopers;
        List newDevelopers = newProject.getDevelopers();
        if (this.comparable(newDevelopers, origDevelopers = this.originalProject.getDevelopers())) {
            try {
                this.detectObjectChange(newDevelopers, origDevelopers);
                this.detectCollectionChange(newDevelopers, origDevelopers);
                for (int i = 0; i < origDevelopers.size(); ++i) {
                    Developer newDeveloper = (Developer)newDevelopers.get(i);
                    Developer origDeveloper = (Developer)origDevelopers.get(i);
                    this.detectAttributeChange(newDeveloper.getId(), origDeveloper.getId());
                    this.compareContributor((Contributor)newDeveloper, (Contributor)origDeveloper);
                }
            }
            catch (ShortCircuitException e) {
                this.fireProjectChangeEvent(newProject, DEVELOPERS);
            }
        }
    }

    private void compareLicenses(Project newProject) {
        List origLicenses = this.originalProject.getLicenses();
        List newLicenses = newProject.getLicenses();
        if (this.comparable(newLicenses, origLicenses)) {
            try {
                this.detectObjectChange(newLicenses, origLicenses);
                this.detectCollectionChange(newLicenses, origLicenses);
                for (int i = 0; i < origLicenses.size(); ++i) {
                    License newLicense = (License)newLicenses.get(i);
                    License origLicense = (License)origLicenses.get(i);
                    this.detectAttributeChange(newLicense.getName(), origLicense.getName());
                    this.detectAttributeChange(newLicense.getUrl(), origLicense.getUrl());
                    this.detectAttributeChange(newLicense.getDistribution(), origLicense.getDistribution());
                    this.detectAttributeChange(newLicense.getComments(), origLicense.getComments());
                }
            }
            catch (ShortCircuitException e) {
                this.fireProjectChangeEvent(newProject, LICENSES);
            }
        }
    }

    private void compareDependencies(Project newProject) {
        List origDependencies;
        List newDependencies = newProject.getDependencies();
        if (this.comparable(newDependencies, origDependencies = this.originalProject.getDependencies())) {
            try {
                this.detectObjectChange(newDependencies, origDependencies);
                this.detectCollectionChange(newDependencies, origDependencies);
                for (int i = 0; i < origDependencies.size(); ++i) {
                    Dependency newDependency = (Dependency)newDependencies.get(i);
                    Dependency origDependency = (Dependency)origDependencies.get(i);
                    this.detectAttributeChange(newDependency.getId(), origDependency.getId());
                    this.detectAttributeChange(newDependency.getName(), origDependency.getName());
                    this.detectAttributeChange(newDependency.getArtifactId(), origDependency.getArtifactId());
                    this.detectAttributeChange(newDependency.getGroupId(), origDependency.getGroupId());
                    this.detectAttributeChange(newDependency.getJar(), origDependency.getJar());
                    this.detectAttributeChange(newDependency.getType(), origDependency.getType());
                    this.detectAttributeChange(newDependency.getUrl(), origDependency.getUrl());
                    this.detectAttributeChange(newDependency.getVersion(), origDependency.getVersion());
                }
            }
            catch (ShortCircuitException e) {
                this.fireProjectChangeEvent(newProject, DEPENDENCIES);
            }
        }
    }

    private void compareBuild(Project newProject) {
        Build originalBuild;
        Build newBuild = newProject.getBuild();
        if (this.comparable(newBuild, originalBuild = this.originalProject.getBuild())) {
            try {
                this.detectObjectChange(newBuild, originalBuild);
                this.detectAttributeChange(newBuild.getSourceDirectory(), originalBuild.getSourceDirectory());
                this.detectAttributeChange(newBuild.getUnitTestSourceDirectory(), originalBuild.getUnitTestSourceDirectory());
                this.detectAttributeChange(newBuild.getAspectSourceDirectory(), originalBuild.getAspectSourceDirectory());
                this.compareSourceModifications(newBuild.getSourceModifications(), originalBuild.getSourceModifications());
                this.detectAttributeChange(newBuild.getNagEmailAddress(), originalBuild.getNagEmailAddress());
                this.compareUnitTest(newBuild, originalBuild, newProject);
                this.compareResources(newBuild.getResources(), originalBuild.getResources());
            }
            catch (ShortCircuitException e) {
                this.fireProjectChangeEvent(newProject, BUILD);
            }
        }
    }

    private void compareSourceModifications(List newSourceModifications, List origSourceModifications) throws ShortCircuitException {
        if (this.comparable(newSourceModifications, origSourceModifications)) {
            this.detectObjectChange(newSourceModifications, origSourceModifications);
            this.detectCollectionChange(newSourceModifications, origSourceModifications);
            for (int i = 0; i < origSourceModifications.size(); ++i) {
                SourceModification origSourceModification = (SourceModification)origSourceModifications.get(i);
                SourceModification newSourceModification = (SourceModification)newSourceModifications.get(i);
                this.compareSourceModification(origSourceModification, newSourceModification);
            }
        }
    }

    private void compareSourceModification(SourceModification origSourceModification, SourceModification newSourceModification) throws ShortCircuitException {
        if (this.comparable(newSourceModification, origSourceModification)) {
            this.detectObjectChange(newSourceModification, origSourceModification);
            this.detectAttributeChange(newSourceModification.getClassName(), origSourceModification.getClassName());
            this.compareResource((Resource)origSourceModification, (Resource)newSourceModification);
        }
    }

    private void compareUnitTest(Build newBuild, Build origBuild, Project newProject) {
        try {
            UnitTest origUnitTest = origBuild.getUnitTest();
            UnitTest newUnitTest = newBuild.getUnitTest();
            if (this.comparable(newUnitTest, origUnitTest)) {
                int j;
                this.detectObjectChange(newUnitTest, origUnitTest);
                this.detectObjectChange(newUnitTest.getIncludes(), origUnitTest.getIncludes());
                this.detectCollectionChange(newUnitTest.getIncludes(), origUnitTest.getIncludes());
                for (j = 0; j < newUnitTest.getIncludes().size(); ++j) {
                    this.detectAttributeChange(origUnitTest.getIncludes().get(j), newUnitTest.getIncludes().get(j));
                }
                this.detectObjectChange(newUnitTest.getExcludes(), origUnitTest.getExcludes());
                this.detectCollectionChange(newUnitTest.getExcludes(), origUnitTest.getExcludes());
                for (j = 0; j < origUnitTest.getExcludes().size(); ++j) {
                    this.detectAttributeChange(origUnitTest.getExcludes().get(j), newUnitTest.getExcludes().get(j));
                }
                this.compareResources(newUnitTest.getResources(), origUnitTest.getResources());
            }
        }
        catch (ShortCircuitException e) {
            this.fireProjectChangeEvent(newProject, UNIT_TESTS);
        }
    }

    private void compareResources(List newResources, List origResources) throws ShortCircuitException {
        if (this.comparable(newResources, origResources)) {
            this.detectObjectChange(newResources, origResources);
            this.detectCollectionChange(newResources, origResources);
            for (int i = 0; i < origResources.size(); ++i) {
                Resource origResource = (Resource)origResources.get(i);
                Resource newResource = (Resource)newResources.get(i);
                this.compareResource(origResource, newResource);
            }
        }
    }

    private void compareResource(Resource origResource, Resource newResource) throws ShortCircuitException {
        if (this.comparable(newResource, origResource)) {
            int j;
            this.detectObjectChange(newResource, origResource);
            this.detectAttributeChange(newResource.getDirectory(), origResource.getDirectory());
            this.detectAttributeChange(newResource.getTargetPath(), origResource.getTargetPath());
            this.detectAttributeChange(newResource.getFiltering(), origResource.getFiltering());
            this.detectObjectChange(newResource.getIncludes(), origResource.getIncludes());
            this.detectCollectionChange(newResource.getIncludes(), origResource.getIncludes());
            for (j = 0; j < origResource.getIncludes().size(); ++j) {
                this.detectAttributeChange(origResource.getIncludes().get(j), newResource.getIncludes().get(j));
            }
            this.detectObjectChange(newResource.getExcludes(), origResource.getExcludes());
            this.detectCollectionChange(newResource.getExcludes(), origResource.getExcludes());
            for (j = 0; j < origResource.getExcludes().size(); ++j) {
                this.detectAttributeChange(origResource.getExcludes().get(j), newResource.getExcludes().get(j));
            }
        }
    }

    private void compareReports(Project newProject) {
        List origReports;
        List newReports = newProject.getReports();
        if (this.comparable(newReports, origReports = this.originalProject.getReports())) {
            try {
                this.detectObjectChange(newReports, origReports);
                this.detectCollectionChange(newReports, origReports);
                for (int i = 0; i < origReports.size(); ++i) {
                    String origReport = (String)origReports.get(i);
                    String newReport = (String)newReports.get(i);
                    this.detectAttributeChange(newReport, origReport);
                }
            }
            catch (ShortCircuitException e) {
                this.fireProjectChangeEvent(newProject, REPORTS);
            }
        }
    }

    private void compareProperties(List newProps, List origProps) throws ShortCircuitException {
        if (this.comparable(newProps, origProps)) {
            this.detectObjectChange(newProps, origProps);
            this.detectCollectionChange(newProps, origProps);
            for (int i = 0; i < origProps.size(); ++i) {
                String origProp = (String)origProps.get(i);
                String newProp = (String)newProps.get(i);
                this.detectAttributeChange(newProp, origProp);
            }
        }
    }

    class ShortCircuitException
    extends Exception {
        ShortCircuitException() {
        }
    }
}

