/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.project;

import java.util.Hashtable;
import java.util.Map;
import org.apache.maven.project.Project;
import org.mevenide.project.ProjectComparator;

public class ProjectComparatorFactory {
    private static Map comparatorMap = new Hashtable();

    private ProjectComparatorFactory() {
    }

    public static ProjectComparator getComparator(Project project) {
        if (project == null) {
            return null;
        }
        ProjectComparator comparator = (ProjectComparator)comparatorMap.get(project);
        if (comparator == null) {
            comparator = new ProjectComparator(project);
            comparatorMap.put(project, comparator);
        }
        return comparator;
    }

    protected static void updateComparator(Project originalProject, Project newProject) {
        ProjectComparator comparator = ProjectComparatorFactory.getComparator(originalProject);
        if (comparator != null && newProject != null) {
            comparatorMap.remove(originalProject);
            comparatorMap.put(newProject, comparator);
        } else {
            ProjectComparatorFactory.getComparator(newProject);
        }
    }
}

