/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.project.dependency;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.project.Dependency;
import org.mevenide.environment.ConfigUtils;
import org.mevenide.project.dependency.IDependencyPathFinder;
import org.mevenide.properties.KeyValuePair;
import org.mevenide.properties.PropertyModel;
import org.mevenide.properties.PropertyModelFactory;

public class DefaultDependencyPathFinder
implements IDependencyPathFinder {
    private static final Log log = LogFactory.getLog((Class)DefaultDependencyPathFinder.class);
    private Dependency dependency;
    private File declaringPom;

    public DefaultDependencyPathFinder(Dependency d) {
        this(d, null);
    }

    public DefaultDependencyPathFinder(Dependency d, File pom) {
        this.dependency = d;
        this.declaringPom = pom;
    }

    public String resolve() {
        String path = null;
        if (this.getDeclaringPom() != null && this.isMavenOverrideOn()) {
            path = this.getPathOverride();
        }
        if (path == null) {
            path = this.buildArtifactPath(this.dependency.getVersion());
        }
        return path.replaceAll("\\\\", "/");
    }

    private String buildArtifactPath(String version) {
        String type = this.dependency.getType() == null ? "jar" : this.dependency.getType();
        File group = new File(ConfigUtils.getDefaultLocationFinder().getMavenLocalRepository(), this.dependency.getGroupId());
        return new File(group, type + "s/" + this.dependency.getArtifactId() + "-" + version + "." + type).getAbsolutePath();
    }

    private boolean isMavenOverrideOn() {
        PropertyModel model = this.getPropertyModel();
        if (model == null) {
            return false;
        }
        KeyValuePair pair = model.findByKey("maven.jar.override");
        return pair != null && pair.getValue() != null && (pair.getValue().equals("on") || pair.getValue().equals("1") || pair.getValue().equals("true"));
    }

    private PropertyModel getPropertyModel() {
        PropertyModel model = null;
        File projectProperties = new File(this.getDeclaringPom().getParentFile(), "project.properties");
        if (projectProperties.exists()) {
            PropertyModelFactory factory = PropertyModelFactory.getFactory();
            try {
                model = factory.newPropertyModel(projectProperties);
            }
            catch (IOException e) {
                log.error((Object)"Unable to mount project PropertyModel", (Throwable)e);
            }
        }
        return model;
    }

    private String getPathOverride() {
        String result = null;
        PropertyModel model = this.getPropertyModel();
        KeyValuePair kvp = model.findByKey("maven.jar." + this.dependency.getArtifactId());
        if (kvp != null) {
            String path;
            String value = kvp.getValue();
            result = new File(value).exists() ? value : (new File(path = this.buildArtifactPath(value)).exists() ? path : value);
        }
        return this.resolvePathOverride(result);
    }

    private String resolvePathOverride(String result) {
        if (result != null && !new File(result).isAbsolute()) {
            result = result.startsWith("{basedir}") ? result.replaceAll("{basedir}", this.getDeclaringPom().getParent()) : new File(this.getDeclaringPom().getParent(), result).getAbsolutePath();
        }
        return result;
    }

    private File getDeclaringPom() {
        return this.declaringPom;
    }
}

