/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.project.dependency;

import java.io.File;
import org.mevenide.project.dependency.DependencySplitter;
import org.mevenide.project.dependency.IDependencyResolver;
import org.mevenide.project.dependency.IDependencySplitter;

public class DefaultDependencyResolver
implements IDependencyResolver {
    private String artifact;
    private String fileName;
    private File file;
    private String artifactId;
    private String version;
    private String extension;
    private String groupId;
    private String type;
    private IDependencySplitter.DependencyParts dependencyParts;

    public void setFileName(String fName) {
        this.artifact = fName;
        this.file = new File(fName);
        this.fileName = this.file.getName();
        this.dependencyParts = new DependencySplitter(this.fileName).split();
        this.init();
    }

    private void init() {
        this.artifactId = null;
        this.version = null;
        this.extension = null;
        this.groupId = null;
        this.type = null;
        this.initArtifactId();
        this.initVersion();
        this.initExtension();
        this.initGroupId();
    }

    private void initArtifactId() {
        this.artifactId = this.dependencyParts.artifactId;
        if (this.artifactId == null && this.fileName.indexOf("SNAPSHOT") > 0) {
            this.artifactId = this.fileName.substring(0, this.fileName.indexOf("SNAPSHOT") - 1);
        }
    }

    private void initVersion() {
        this.version = this.dependencyParts.version;
        if (this.version == null && this.fileName.indexOf("SNAPSHOT") > 0) {
            this.version = "SNAPSHOT";
        }
    }

    private void initExtension() {
        File firstLevelParent = this.file.getParentFile();
        if (firstLevelParent.getName().endsWith("s")) {
            this.type = firstLevelParent.getName().substring(0, firstLevelParent.getName().length() - 1);
        }
        this.extension = this.type != null && this.fileName.endsWith(this.type) ? this.type : this.fileName.substring(this.fileName.lastIndexOf(46) + 1);
        if (this.type == null) {
            this.type = this.extension;
        }
    }

    private void initGroupId() {
        File firstLevelParent = this.file.getParentFile();
        if (firstLevelParent != null && firstLevelParent.getName().equalsIgnoreCase(this.guessExtension() + "s") && firstLevelParent.getParentFile() != null) {
            this.groupId = firstLevelParent.getParentFile().getName();
        }
    }

    public String guessArtifactId() {
        return this.artifactId != null ? this.artifactId : this.getShortName();
    }

    public String guessVersion() {
        return this.version;
    }

    public String guessExtension() {
        return this.extension;
    }

    public String guessGroupId() {
        return this.groupId;
    }

    public String guessType() {
        return this.type;
    }

    private String getShortName() {
        String shortFileName = new File(this.fileName).getName();
        if (shortFileName.lastIndexOf(46) >= 0) {
            return shortFileName.substring(0, shortFileName.lastIndexOf(46));
        }
        return shortFileName;
    }
}

