/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.project.dependency;

import java.io.File;
import org.apache.maven.project.Dependency;
import org.mevenide.project.dependency.DependencyResolverFactory;
import org.mevenide.project.dependency.IDependencyResolver;

public final class DependencyFactory {
    private static DependencyFactory factory = new DependencyFactory();

    private DependencyFactory() {
    }

    public static DependencyFactory getFactory() {
        return factory;
    }

    public Dependency getDependency(String absoluteFileName) throws Exception {
        IDependencyResolver dependencyResolver = DependencyResolverFactory.getFactory().newInstance(absoluteFileName);
        String groupId = dependencyResolver.guessGroupId();
        String artifactId = dependencyResolver.guessArtifactId();
        String version = dependencyResolver.guessVersion();
        String extension = dependencyResolver.guessExtension();
        Dependency dependency = new Dependency();
        if (groupId == null) {
            dependency.setId(artifactId);
        } else {
            dependency.setGroupId(groupId);
            dependency.setArtifactId(artifactId);
        }
        dependency.setVersion(version);
        dependency.setType(extension);
        String filename = new File(absoluteFileName).getName();
        if (!dependency.getArtifact().equals(filename)) {
            dependency.setJar(filename);
        }
        return dependency;
    }
}

