/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.project.dependency;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.project.Dependency;
import org.mevenide.context.IQueryContext;
import org.mevenide.project.dependency.IDependencyPattern;
import org.mevenide.project.dependency.IDependencyReplacer;
import org.mevenide.project.io.IContentProvider;
import org.mevenide.project.io.ProxyContentProvider;

public final class DependencyMatcher {
    public static IQueryContext[] matchingContexts(IQueryContext[] input, IDependencyPattern patern) {
        ArrayList<IQueryContext> toReturn = new ArrayList<IQueryContext>();
        for (int i = 0; i < input.length; ++i) {
            List dependencies = input[i].getPOMContext().getFinalProject().getDependencies();
            if (dependencies == null) continue;
            Iterator it = dependencies.iterator();
            while (it.hasNext()) {
                Dependency dep = (Dependency)it.next();
                if (!patern.matches(dep, input[i])) continue;
                toReturn.add(input[i]);
            }
        }
        IQueryContext[] contexts = new IQueryContext[toReturn.size()];
        contexts = toReturn.toArray(contexts);
        return contexts;
    }

    public static IContentProvider replace(IDependencyReplacer replacer, IContentProvider originalPom) {
        return new DependencyProxyContentProvider(originalPom, replacer);
    }

    private static class DependencyProxyContentProvider
    extends ProxyContentProvider {
        private IDependencyReplacer replacer;

        public DependencyProxyContentProvider(IContentProvider provider, IDependencyReplacer repl) {
            super(provider);
            this.replacer = repl;
        }

        public List getSubContentProviderList(String parentKey, String childKey) {
            ArrayList<IContentProvider> lst = super.getSubContentProviderList(parentKey, childKey);
            if (lst != null && "dependencies".equals(parentKey)) {
                ArrayList<IContentProvider> newOne = new ArrayList<IContentProvider>();
                Iterator it = lst.iterator();
                while (it.hasNext()) {
                    IContentProvider provider = (IContentProvider)it.next();
                    newOne.add(this.replacer.replace(provider));
                }
                lst = newOne;
            }
            return lst;
        }
    }
}

