/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.project.dependency;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mevenide.project.dependency.IDependencySplitter;

public class DependencySplitter
implements IDependencySplitter {
    private String fileName;

    public DependencySplitter(String fileNameToSplit) {
        this.fileName = fileNameToSplit;
    }

    public IDependencySplitter.DependencyParts split() {
        Pattern p = Pattern.compile("(.|(-\\D)*)-((\\d)+(.*))\\.(\\w+)");
        return this.applySplitStrategy(p, 3, 6);
    }

    private IDependencySplitter.DependencyParts applySplitStrategy(Pattern p, int expectedVersionIndex, int expectedExtensionIndex) {
        Matcher m = p.matcher(this.fileName);
        String[] allGroups = new String[m.groupCount() + 1];
        for (int i = 0; i < m.groupCount() + 1 && m.find(i); ++i) {
            allGroups[i] = m.group(i);
        }
        IDependencySplitter.DependencyParts dependencyParts = new IDependencySplitter.DependencyParts();
        dependencyParts.version = allGroups[expectedVersionIndex];
        dependencyParts.extension = allGroups[expectedExtensionIndex];
        if (dependencyParts.version != null) {
            dependencyParts.artifactId = this.fileName.substring(0, this.fileName.indexOf(dependencyParts.version) - 1);
        }
        return dependencyParts;
    }
}

