/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.project.dependency;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.project.Dependency;
import org.apache.maven.project.Project;
import org.mevenide.environment.ConfigUtils;
import org.mevenide.project.dependency.DependencyResolverFactory;
import org.mevenide.util.ResolverUtils;
import org.mevenide.util.StringUtils;

public final class DependencyUtil {
    private static Log log = LogFactory.getLog((Class)DependencyUtil.class);

    private DependencyUtil() {
    }

    public static boolean areEquals(Dependency d1, Dependency d2) {
        return d1 == null && d2 == null || d1 != null && d2 != null && DependencyUtil.areEquals(d1.getArtifactId(), d2.getArtifactId()) && DependencyUtil.areEquals(d1.getGroupId(), d2.getGroupId()) && DependencyUtil.areEquals(d1.getVersion(), d2.getVersion());
    }

    public static boolean areEquals(Project context, Dependency d1, Dependency d2) {
        return d1 == null && d2 == null || d1 != null && d2 != null && DependencyUtil.areEquals(ResolverUtils.getInstance().resolve(context, d1.getArtifactId()), ResolverUtils.getInstance().resolve(context, d2.getArtifactId())) && DependencyUtil.areEquals(ResolverUtils.getInstance().resolve(context, d1.getGroupId()), ResolverUtils.getInstance().resolve(context, d2.getGroupId())) && DependencyUtil.areEquals(ResolverUtils.getInstance().resolve(context, d1.getVersion()), ResolverUtils.getInstance().resolve(context, d2.getVersion()));
    }

    static boolean areEquals(String s1, String s2) {
        return s1 == null && s2 == null || s1 != null && s1.equals(s2);
    }

    public static boolean conflict(Dependency d1, Dependency d2) {
        if (d1 == null || d2 == null) {
            return false;
        }
        return DependencyUtil.areEquals(d1.getArtifactId(), d2.getArtifactId()) && DependencyUtil.areEquals(d1.getGroupId(), d2.getGroupId()) && !DependencyUtil.areEquals(d1.getVersion(), d2.getVersion());
    }

    public static boolean isValidGroupId(final String groupId) {
        File repo = new File(ConfigUtils.getDefaultLocationFinder().getMavenLocalRepository());
        File[] children = repo.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory() && pathname.getName().equals(groupId);
            }
        });
        return children != null && children.length != 0;
    }

    public static boolean isValid(Dependency d) {
        if (d == null) {
            log.debug((Object)"null dependency found");
            return false;
        }
        boolean valid = !StringUtils.isNull(d.getGroupId()) && !StringUtils.isNull(d.getArtifactId());
        return valid;
    }

    public static String toString(Dependency d) {
        return " <groupId=" + d.getGroupId() + ">, <artifactId=" + d.getArtifactId() + ">, <version=" + d.getVersion() + ">";
    }

    public static List getNonResolvedDependencies(List dependencies) {
        ArrayList temp = new ArrayList(dependencies);
        ArrayList<Dependency> nonResolvedDependencies = new ArrayList<Dependency>();
        for (int i = 0; i < temp.size(); ++i) {
            Dependency dependency = (Dependency)temp.get(i);
            if (DependencyUtil.isValid(dependency)) continue;
            dependencies.remove(dependency);
            nonResolvedDependencies.add(dependency);
        }
        return nonResolvedDependencies;
    }

    public static boolean isDependencyPresent(Project project, Dependency dependency) {
        log.debug((Object)("searched dependency : " + DependencyUtil.toString(dependency)));
        List dependencies = project.getDependencies();
        if (dependencies == null) {
            return false;
        }
        for (int i = 0; i < dependencies.size(); ++i) {
            Dependency declaredDependency = (Dependency)dependencies.get(i);
            String version = declaredDependency.getVersion();
            String artifactId = declaredDependency.getArtifactId();
            log.debug((Object)("found dependency : " + DependencyUtil.toString(declaredDependency)));
            if (artifactId == null || !artifactId.equals(dependency.getArtifactId()) || version == null || !version.equals(dependency.getVersion())) continue;
            return true;
        }
        return false;
    }

    public static void refreshGroupId(Dependency dependency) {
        try {
            if (dependency.getGroupId().equals("")) {
                dependency.setGroupId(DependencyResolverFactory.getFactory().newInstance(dependency.getArtifact()).guessGroupId());
            }
        }
        catch (Exception ex) {
            log.debug((Object)("Still unable to resolve groupId due to : " + ex));
        }
    }
}

