/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.project.dependency;

import org.mevenide.project.dependency.ExactDependencyPattern;
import org.mevenide.project.dependency.IDependencyReplacer;
import org.mevenide.project.io.IContentProvider;
import org.mevenide.project.io.ProxyContentProvider;

public class ExactDependencyReplacer
extends ExactDependencyPattern
implements IDependencyReplacer {
    private String artifact;
    private String group;
    private String version;
    private String newArtifact;
    private String newGroup;
    private String newVersion;

    public ExactDependencyReplacer(String artifactId, String groupId, String currentversion, String nArt, String nGrp, String nVer) {
        super(artifactId, groupId, currentversion);
        this.version = currentversion;
        this.artifact = artifactId;
        this.group = groupId;
        this.newArtifact = nArt;
        this.newGroup = nGrp;
        this.newVersion = nVer;
    }

    public IContentProvider replace(IContentProvider original) {
        String id = original.getValue("id");
        String art = original.getValue("artifactId");
        String gr = original.getValue("groupId");
        String ver = original.getValue("version");
        if (this.matchOne(this.version, ver) && (this.matchOne(this.artifact, art) && this.matchOne(this.group, gr) || this.matchOne(id, this.group + ":" + this.artifact))) {
            return new OneDepContent(original);
        }
        return original;
    }

    private class OneDepContent
    extends ProxyContentProvider {
        public OneDepContent(IContentProvider original) {
            super(original);
        }

        public String getValue(String key) {
            if ("artifactId".equals(key)) {
                return ExactDependencyReplacer.this.newArtifact;
            }
            if ("groupId".equals(key)) {
                return ExactDependencyReplacer.this.newGroup;
            }
            if ("version".equals(key)) {
                return ExactDependencyReplacer.this.newVersion;
            }
            if ("id".equals(key)) {
                return null;
            }
            return super.getValue(key);
        }
    }
}

