/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.project.dependency;

import java.net.URI;
import org.mevenide.project.dependency.DependencySplitter;
import org.mevenide.project.dependency.IDependencyResolver;
import org.mevenide.project.dependency.IDependencySplitter;

public class URIDependencyResolver
implements IDependencyResolver {
    private String artifact;
    private URI uri;
    private String fileName;
    private String artifactId;
    private String version;
    private String extension;
    private String groupId;
    private String type;
    private IDependencySplitter.DependencyParts dependencyParts;

    public void setURI(URI name) {
        this.artifact = name.getPath();
        this.uri = name;
        this.fileName = this.artifact.substring(this.artifact.lastIndexOf(47) + 1);
        this.dependencyParts = new DependencySplitter(this.fileName).split();
        this.init();
    }

    private void init() {
        this.artifactId = null;
        this.version = null;
        this.extension = null;
        this.groupId = null;
        this.type = null;
        this.initExtension();
        this.initGroupId();
        this.initArtifactIdAndVersion();
    }

    private void initArtifactIdAndVersion() {
        this.artifactId = this.dependencyParts.artifactId;
        if (this.artifactId == null && this.fileName.indexOf("SNAPSHOT") > 0) {
            this.artifactId = this.fileName.substring(0, this.fileName.indexOf("SNAPSHOT") - 1);
        }
        if (this.artifactId == null) {
            int ind = this.fileName.lastIndexOf(45);
            if (ind > 0) {
                this.artifactId = this.fileName.substring(0, ind);
                this.version = this.fileName.substring(ind + 1, this.fileName.length() - (this.extension != null ? this.extension.length() + 1 : 0));
            } else {
                this.artifactId = this.fileName;
                this.version = "<Unknown>";
            }
        } else if (this.extension != null && this.artifactId.length() < this.fileName.length()) {
            this.version = this.fileName.substring(this.artifactId.length() + 1, this.fileName.length() - this.extension.length() - 1);
        }
    }

    private void initExtension() {
        String firstLevelParentName = URIDependencyResolver.getName(URI.create(URIDependencyResolver.getParent(this.uri)));
        if (firstLevelParentName.endsWith("s")) {
            this.type = firstLevelParentName.substring(0, firstLevelParentName.length() - 1);
        }
        if (this.type != null && this.fileName.endsWith(this.type)) {
            this.extension = this.type;
        } else if (this.type != null && this.fileName.endsWith("tar.gz")) {
            this.extension = "tar.gz";
        } else {
            int ind = this.fileName.lastIndexOf(46);
            if (ind > -1) {
                this.extension = this.fileName.substring(this.fileName.lastIndexOf(46) + 1);
            }
        }
        if (this.type == null) {
            this.type = this.extension;
        }
    }

    private void initGroupId() {
        String secondParent;
        String firstLevelParent = URIDependencyResolver.getParent(this.uri);
        if (firstLevelParent != null && URIDependencyResolver.getName(URI.create(firstLevelParent)).equalsIgnoreCase(this.guessExtension() + "s") && URIDependencyResolver.getParent(URI.create(firstLevelParent)) != null && (secondParent = URIDependencyResolver.getParent(URI.create(firstLevelParent))) != null) {
            this.groupId = URIDependencyResolver.getName(URI.create(secondParent));
        }
    }

    public String guessArtifactId() {
        return this.artifactId != null ? this.artifactId : this.getShortName();
    }

    public String guessVersion() {
        return this.version;
    }

    public String guessExtension() {
        return this.extension;
    }

    public String guessGroupId() {
        return this.groupId;
    }

    public String guessType() {
        return this.type;
    }

    private String getShortName() {
        String shortFileName = this.fileName;
        if (shortFileName.lastIndexOf(46) >= 0) {
            return shortFileName.substring(0, shortFileName.length() - this.extension.length());
        }
        return shortFileName;
    }

    private static String getParent(URI uri) {
        int index = uri.getRawPath().lastIndexOf(47);
        if (index > 0) {
            String subPath = uri.getRawPath().substring(0, index);
            StringBuffer buf = new StringBuffer(uri.toString());
            int ind = uri.toString().indexOf(uri.getRawPath());
            buf.replace(ind, ind + uri.getRawPath().length(), subPath);
            return buf.toString();
        }
        return null;
    }

    private static String getName(URI uri) {
        int index = uri.getPath().lastIndexOf(47);
        if (index > -1 && index + 1 < uri.getPath().length()) {
            return uri.getPath().substring(index + 1);
        }
        return uri.getPath();
    }
}

