/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.project.io;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.project.io.IContentProvider;

public final class BeanContentProvider
implements IContentProvider {
    private static final Log log = LogFactory.getLog((Class)BeanContentProvider.class);
    private Object bean;

    public BeanContentProvider(Object obj) {
        this.bean = obj;
    }

    public IContentProvider getSubContentProvider(String key) {
        Object toReturn = this.retrieveValue(key);
        return toReturn != null ? new BeanContentProvider(toReturn) : null;
    }

    public List getSubContentProviderList(String parentKey, String childKey) {
        Object obj = this.retrieveValue(parentKey);
        if (obj != null && obj instanceof Collection) {
            Collection list = (Collection)obj;
            ArrayList<BeanContentProvider> toReturn = new ArrayList<BeanContentProvider>(list.size());
            Iterator it = list.iterator();
            while (it.hasNext()) {
                Object obj2 = it.next();
                toReturn.add(new BeanContentProvider(obj2));
            }
            return toReturn;
        }
        return null;
    }

    public String getValue(String key) {
        Object toReturn = this.retrieveValue(key);
        return toReturn != null ? toReturn.toString() : null;
    }

    private Object retrieveValue(String key) {
        if (this.bean == null) {
            return null;
        }
        try {
            Method method = this.bean.getClass().getMethod(this.createGetter(key), null);
            Object returned = method.invoke(this.bean, null);
            return returned;
        }
        catch (Exception exc) {
            String err = "Called " + this.createGetter(key) + " on " + this.bean.getClass().getName() + " and failed";
            log.error((Object)err, (Throwable)exc);
            return null;
        }
    }

    private String createGetter(String key) {
        return "get" + key.substring(0, 1).toUpperCase() + key.substring(1);
    }

    public List getValueList(String parentKey, String childKey) {
        Object toReturn = this.retrieveValue(parentKey);
        if (toReturn instanceof List) {
            return (List)toReturn;
        }
        if (toReturn != null) {
            log.error((Object)("Called " + this.createGetter(parentKey) + " on " + this.bean.getClass().getName() + " and failed returning " + toReturn.getClass()));
        }
        return null;
    }

    public List getProperties() {
        Object toReturn = this.retrieveValue("properties");
        if (toReturn instanceof List) {
            return (List)toReturn;
        }
        if (toReturn != null) {
            log.error((Object)("Called getProperties on " + this.bean.getClass().getName() + " and failed returning " + toReturn.getClass()));
        }
        return null;
    }
}

