/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.project.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.project.Project;
import org.jdom.Content;
import org.jdom.DefaultJDOMFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMFactory;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.mevenide.project.io.BeanContentProvider;
import org.mevenide.project.io.IContentProvider;
import org.mevenide.project.io.IProjectMarshaller;

public class CarefulProjectMarshaller
implements IProjectMarshaller {
    private static final Log log = LogFactory.getLog((Class)CarefulProjectMarshaller.class);
    private XMLOutputter outputter;
    private JDOMFactory factory;
    private SAXBuilder builder = new SAXBuilder();

    public CarefulProjectMarshaller() {
        this(Format.getPrettyFormat().setIndent("    ").setLineSeparator(System.getProperty("line.separator")));
    }

    public CarefulProjectMarshaller(Format format) {
        this.factory = new DefaultJDOMFactory();
        this.outputter = new XMLOutputter();
        this.outputter.setFormat(format);
    }

    public void marshall(Writer pom, Project project) throws Exception {
        log.debug((Object)"do Marshall()");
        Document originalDoc = this.factory.document(this.factory.element("project"));
        log.debug((Object)"  updating document");
        this.doUpdateDocument(originalDoc, new BeanContentProvider(project));
        log.debug((Object)"  saving document");
        this.saveDocument(pom, originalDoc);
    }

    public void marshall(Writer pom, Project project, InputStream source) throws Exception {
        log.debug((Object)"do Marshall2()");
        Document originalDoc = this.builder.build(source);
        log.debug((Object)"  updating document");
        this.doUpdateDocument(originalDoc, new BeanContentProvider(project));
        log.debug((Object)"  saving document");
        this.saveDocument(pom, originalDoc);
    }

    public void marshall(Writer pom, IContentProvider provider) throws Exception {
        log.debug((Object)"do Marshall()");
        Document originalDoc = this.factory.document(this.factory.element("project"));
        log.debug((Object)"  updating document");
        this.doUpdateDocument(originalDoc, provider);
        log.debug((Object)"  saving document");
        this.saveDocument(pom, originalDoc);
    }

    public void marshall(Writer pom, IContentProvider provider, Document originalDoc) throws Exception {
        log.debug((Object)"do Marshall2()");
        log.debug((Object)"  updating document");
        this.doUpdateDocument(originalDoc, provider);
        log.debug((Object)"  saving document");
        this.saveDocument(pom, originalDoc);
    }

    private void saveDocument(Writer pom, Document doc) throws Exception {
        this.outputter.output(doc, pom);
    }

    private void doUpdateDocument(Document document, IContentProvider project) throws Exception {
        Element root = document.getRootElement();
        if (!"project".equals(root.getName())) {
            throw new IOException("not a maven project xml");
        }
        Counter counter = new Counter();
        this.findAndReplaceSimpleElement(counter, root, "extend", project.getValue("extend"));
        this.findAndReplaceSimpleElement(counter, root, "pomVersion", project.getValue("pomVersion"));
        this.findAndReplaceSimpleElement(counter, root, "artifactId", project.getValue("artifactId"));
        this.findAndReplaceSimpleElement(counter, root, "name", project.getValue("name"));
        this.findAndReplaceSimpleElement(counter, root, "groupId", project.getValue("groupId"));
        this.findAndReplaceSimpleElement(counter, root, "currentVersion", project.getValue("currentVersion"));
        this.doUpdateOrganization(counter, root, project.getSubContentProvider("organization"));
        this.findAndReplaceSimpleElement(counter, root, "inceptionYear", project.getValue("inceptionYear"));
        this.findAndReplaceSimpleElement(counter, root, "package", project.getValue("package"));
        this.findAndReplaceSimpleElement(counter, root, "logo", project.getValue("logo"));
        this.findAndReplaceSimpleElement(counter, root, "gumpRepositoryId", project.getValue("gumpRepositoryId"));
        this.findAndReplaceSimpleElement(counter, root, "description", project.getValue("description"));
        this.findAndReplaceSimpleElement(counter, root, "shortDescription", project.getValue("shortDescription"));
        this.findAndReplaceSimpleElement(counter, root, "url", project.getValue("url"));
        this.findAndReplaceSimpleElement(counter, root, "issueTrackingUrl", project.getValue("issueTrackingUrl"));
        this.findAndReplaceSimpleElement(counter, root, "siteAddress", project.getValue("siteAddress"));
        this.findAndReplaceSimpleElement(counter, root, "siteDirectory", project.getValue("siteDirectory"));
        this.findAndReplaceSimpleElement(counter, root, "distributionSite", project.getValue("distributionSite"));
        this.findAndReplaceSimpleElement(counter, root, "distributionDirectory", project.getValue("distributionDirectory"));
        this.doUpdateRepository(counter, root, project.getSubContentProvider("repository"));
        this.doUpdateChildren(counter, root, project.getSubContentProviderList("versions", "version"), "versions", "version", "id");
        this.doUpdateChildren(counter, root, project.getSubContentProviderList("branches", "branch"), "branches", "branch", "tag");
        this.doUpdateChildren(counter, root, project.getSubContentProviderList("mailingLists", "mailingList"), "mailingLists", "mailingList", "name");
        this.doUpdateChildren(counter, root, project.getSubContentProviderList("developers", "developer"), "developers", "developer", "name");
        this.doUpdateChildren(counter, root, project.getSubContentProviderList("contributors", "contributor"), "contributors", "contributor", "name");
        this.doUpdateChildren(counter, root, project.getSubContentProviderList("licenses", "license"), "licenses", "license", "name");
        this.doUpdateDependencies(counter, root, project.getSubContentProviderList("dependencies", "dependency"));
        this.doUpdateBuild(counter, root, project.getSubContentProvider("build"));
        this.doUpdateSimpleChildren(counter, root, project.getValueList("reports", "report"), "reports", "report");
    }

    private void doUpdateOrganization(Counter counter, Element root, IContentProvider org) throws Exception {
        boolean shouldExist = org != null;
        Element orgElem = this.updateElement(counter, root, "organization", shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter();
            this.findAndReplaceSimpleElement(innerCount, orgElem, "name", org.getValue("name"));
            this.findAndReplaceSimpleElement(innerCount, orgElem, "url", org.getValue("url"));
            this.findAndReplaceSimpleElement(innerCount, orgElem, "logo", org.getValue("logo"));
        }
    }

    private void doUpdateRepository(Counter counter, Element root, IContentProvider repos) throws Exception {
        boolean shouldExist = repos != null;
        Element orgElem = this.updateElement(counter, root, "repository", shouldExist);
        if (shouldExist) {
            Counter innerCounter = new Counter();
            this.findAndReplaceSimpleElement(innerCounter, orgElem, "connection", repos.getValue("connection"));
            this.findAndReplaceSimpleElement(innerCounter, orgElem, "developerConnection", repos.getValue("developerConnection"));
            this.findAndReplaceSimpleElement(innerCounter, orgElem, "url", repos.getValue("url"));
        }
    }

    private void doUpdateChildren(Counter counter, Element root, List newValues, String parentName, String childName, String childKey) throws Exception {
        boolean shouldExist = newValues != null && !newValues.isEmpty();
        Element parentElement = this.updateElement(counter, root, parentName, shouldExist);
        if (shouldExist) {
            List currentChildren = parentElement.getContent((Filter)new ElementFilter(childName));
            ArrayList<Element> usedElems = new ArrayList<Element>();
            for (int i = 0; i < newValues.size(); ++i) {
                Element child;
                IContentProvider newValue = (IContentProvider)newValues.get(i);
                String id = newValue.getValue(childKey);
                List list = parentElement.getContent((Filter)new SpecificElementFilter(childName, childKey, id));
                if (list != null && !list.isEmpty()) {
                    if (list.size() > 1) {
                        log.info((Object)("filter returned multiple instances, the primary key is not unique - key=" + id));
                        continue;
                    }
                    child = (Element)list.get(0);
                    int pos = currentChildren.indexOf(child);
                    if (pos != i) {
                        currentChildren.remove(pos);
                        currentChildren.add(i, child);
                    }
                    this.doUpdateChild(child, newValue);
                    usedElems.add(child);
                    log.debug((Object)("updating element " + child.getChildText(childKey)));
                    continue;
                }
                child = this.factory.element(childName);
                this.doUpdateChild(child, newValue);
                usedElems.add(child);
                currentChildren.add(i, child);
                log.debug((Object)("creating new element " + child.getChildText(childKey)));
            }
            this.removeNonUsedSubelements(parentElement, childName, usedElems);
        }
    }

    private void doUpdateChild(Element child, IContentProvider newValue) throws Exception {
        if ("version".equals(child.getName())) {
            this.doUpdateSingleVersion(child, newValue);
        } else if ("branch".equals(child.getName())) {
            this.doUpdateSingleBranch(child, newValue);
        } else if ("mailingList".equals(child.getName())) {
            this.doUpdateSingleMailingList(child, newValue);
        } else if ("developer".equals(child.getName())) {
            this.doUpdateSingleDeveloper(child, newValue);
        } else if ("contributor".equals(child.getName())) {
            this.doUpdateSingleContributor(child, newValue);
        } else if ("license".equals(child.getName())) {
            this.doUpdateSingleLicense(child, newValue);
        }
    }

    private void doUpdateSingleVersion(Element versionElement, IContentProvider version) {
        Counter count = new Counter();
        this.findAndReplaceSimpleElement(count, versionElement, "id", version.getValue("id"));
        this.findAndReplaceSimpleElement(count, versionElement, "name", version.getValue("name"));
        this.findAndReplaceSimpleElement(count, versionElement, "tag", version.getValue("tag"));
    }

    private void doUpdateSingleBranch(Element branchElement, IContentProvider branch) {
        this.findAndReplaceSimpleElement(new Counter(), branchElement, "tag", branch.getValue("tag"));
    }

    private void doUpdateSingleMailingList(Element mailElement, IContentProvider mail) {
        Counter count = new Counter();
        this.findAndReplaceSimpleElement(count, mailElement, "name", mail.getValue("name"));
        this.findAndReplaceSimpleElement(count, mailElement, "subscribe", mail.getValue("subscribe"));
        this.findAndReplaceSimpleElement(count, mailElement, "unsubscribe", mail.getValue("unsubscribe"));
        this.findAndReplaceSimpleElement(count, mailElement, "archive", mail.getValue("archive"));
    }

    private void doUpdateSingleDeveloper(Element devElement, IContentProvider developer) throws Exception {
        Counter count = new Counter();
        this.findAndReplaceSimpleElement(count, devElement, "name", developer.getValue("name"));
        this.findAndReplaceSimpleElement(count, devElement, "id", developer.getValue("id"));
        this.findAndReplaceSimpleElement(count, devElement, "email", developer.getValue("email"));
        this.findAndReplaceSimpleElement(count, devElement, "organization", developer.getValue("organization"));
        this.findAndReplaceSimpleElement(count, devElement, "url", developer.getValue("url"));
        this.findAndReplaceSimpleElement(count, devElement, "timezone", developer.getValue("timezone"));
    }

    private void doUpdateSingleContributor(Element conElement, IContentProvider contributor) throws Exception {
        Counter count = new Counter();
        this.findAndReplaceSimpleElement(count, conElement, "name", contributor.getValue("name"));
        this.findAndReplaceSimpleElement(count, conElement, "email", contributor.getValue("email"));
        this.findAndReplaceSimpleElement(count, conElement, "organization", contributor.getValue("organization"));
        this.doUpdateRoles(count, conElement, contributor.getValueList("roles", "role"));
        this.findAndReplaceSimpleElement(count, conElement, "url", contributor.getValue("url"));
        this.findAndReplaceSimpleElement(count, conElement, "timezone", contributor.getValue("timezone"));
    }

    private void doUpdateRoles(Counter counter, Element root, Collection roles) throws Exception {
        boolean shouldExist = roles != null && !roles.isEmpty();
        Element rolesElem = this.updateElement(counter, root, "roles", shouldExist);
        if (shouldExist) {
            rolesElem.removeContent();
            Iterator it = roles.iterator();
            while (it.hasNext()) {
                String roleStr = (String)it.next();
                Element role = this.factory.element("role");
                role.setText(roleStr);
                rolesElem.addContent((Content)role);
            }
        }
    }

    private void doUpdateSingleLicense(Element licElement, IContentProvider license) {
        Counter count = new Counter();
        this.findAndReplaceSimpleElement(count, licElement, "name", license.getValue("name"));
        this.findAndReplaceSimpleElement(count, licElement, "url", license.getValue("url"));
        this.findAndReplaceSimpleElement(count, licElement, "distribution", license.getValue("distribution"));
        this.findAndReplaceSimpleElement(count, licElement, "comments", license.getValue("comments"));
    }

    private void doUpdateDependencies(Counter counter, Element root, List dependencies) throws Exception {
        boolean shouldExist = dependencies != null && !dependencies.isEmpty();
        Element dependenciesElem = this.updateElement(counter, root, "dependencies", shouldExist);
        if (shouldExist) {
            List currentChildren = dependenciesElem.getContent((Filter)new ElementFilter("dependency"));
            ArrayList<Element> usedElems = new ArrayList<Element>();
            for (int i = 0; i < dependencies.size(); ++i) {
                Element vElem;
                IContentProvider dep = (IContentProvider)dependencies.get(i);
                List list = dependenciesElem.getContent((Filter)new DependencyElementFilter(dep.getValue("id"), dep.getValue("artifactId"), dep.getValue("groupId"), dep.getValue("type")));
                if (list != null && !list.isEmpty()) {
                    if (list.size() > 1) {
                        log.info((Object)("filter returned multiple instances, the primary key is not unique - key=" + dep.getValue("id")));
                        continue;
                    }
                    vElem = (Element)list.get(0);
                    int pos = currentChildren.indexOf(vElem);
                    if (pos != i) {
                        currentChildren.remove(pos);
                        currentChildren.add(i, vElem);
                    }
                    this.doUpdateSingleDependency(vElem, dep);
                    usedElems.add(vElem);
                    log.debug((Object)("updating element " + vElem.getChildText("artifactId")));
                    continue;
                }
                vElem = this.factory.element("dependency");
                this.doUpdateSingleDependency(vElem, dep);
                usedElems.add(vElem);
                currentChildren.add(i, vElem);
                log.debug((Object)("creating new element " + vElem.getChildText("artifactId")));
            }
            this.removeNonUsedSubelements(dependenciesElem, "dependency", usedElems);
        }
    }

    private void doUpdateSingleDependency(Element depElement, IContentProvider dependency) throws Exception {
        Counter count = new Counter();
        this.findAndReplaceSimpleElement(count, depElement, "groupId", dependency.getValue("groupId"));
        this.findAndReplaceSimpleElement(count, depElement, "artifactId", dependency.getValue("artifactId"));
        this.findAndReplaceSimpleElement(count, depElement, "version", dependency.getValue("version"));
        this.findAndReplaceSimpleElement(count, depElement, "jar", dependency.getValue("jar"));
        this.findAndReplaceSimpleElement(count, depElement, "type", dependency.getValue("type"));
        this.findAndReplaceSimpleElement(count, depElement, "url", dependency.getValue("url"));
        this.doUpdateProperties(count, depElement, this.myResolveProperties(dependency.getProperties()));
    }

    private Map myResolveProperties(List propList) {
        TreeMap<String, String> toReturn = new TreeMap<String, String>();
        if (propList != null) {
            Iterator it = propList.iterator();
            while (it.hasNext()) {
                String prop = (String)it.next();
                int index = prop.indexOf(58);
                if (index > 0) {
                    toReturn.put(prop.substring(0, index), prop.substring(index + 1));
                    continue;
                }
                toReturn.put(prop, null);
            }
        }
        return toReturn;
    }

    private void doUpdateProperties(Counter counter, Element parent, Map props) {
        boolean shouldExist = props != null && !props.isEmpty();
        Element propsElem = this.updateElement(counter, parent, "properties", shouldExist);
        if (shouldExist) {
            ArrayList<Element> usedElems = new ArrayList<Element>();
            Iterator<Object> it = props.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                Element propEl = propsElem.getChild(key);
                if (propEl != null) {
                    propEl.setText((String)props.get(key));
                    usedElems.add(propEl);
                    continue;
                }
                propEl = this.factory.element(key);
                propEl.setText((String)props.get(key));
                usedElems.add(propEl);
                propsElem.addContent((Content)propEl);
            }
            it = propsElem.getChildren().iterator();
            while (it.hasNext()) {
                Element el = (Element)it.next();
                if (usedElems.contains(el)) continue;
                it.remove();
            }
        }
    }

    private void doUpdateBuild(Counter counter, Element root, IContentProvider build) throws Exception {
        boolean shouldExist = build != null;
        Element buildElem = this.updateElement(counter, root, "build", shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter();
            this.findAndReplaceSimpleElement(innerCount, buildElem, "nagEmailAddress", build.getValue("nagEmailAddress"));
            this.findAndReplaceSimpleElement(innerCount, buildElem, "sourceDirectory", build.getValue("sourceDirectory"));
            this.findAndReplaceSimpleElement(innerCount, buildElem, "unitTestSourceDirectory", build.getValue("unitTestSourceDirectory"));
            this.findAndReplaceSimpleElement(innerCount, buildElem, "integrationUnitTestSourceDirectory", build.getValue("integrationUnitTestSourceDirectory"));
            this.findAndReplaceSimpleElement(innerCount, buildElem, "aspectSourceDirectory", build.getValue("aspectSourceDirectory"));
            this.doUpdateUnitTest(innerCount, buildElem, build.getSubContentProvider("unitTest"));
            this.doUpdateResources(innerCount, buildElem, build.getSubContentProviderList("resources", "resource"));
            this.doUpdateSourceModifications(innerCount, buildElem, build.getSubContentProviderList("sourceModifications", "sourceModification"));
        }
    }

    private void doUpdateUnitTest(Counter counter, Element parent, IContentProvider test) throws Exception {
        boolean shouldExist = test != null;
        Element testElem = this.updateElement(counter, parent, "unitTest", shouldExist);
        if (shouldExist) {
            Counter innerCount = new Counter();
            this.doUpdateSimpleChildren(innerCount, testElem, test.getValueList("includes", "include"), "includes", "include");
            this.doUpdateSimpleChildren(innerCount, testElem, test.getValueList("excludes", "exclude"), "excludes", "exclude");
            this.doUpdateResources(innerCount, testElem, test.getSubContentProviderList("resources", "resource"));
        }
    }

    private void doUpdateResources(Counter counter, Element root, List resources) throws Exception {
        boolean shouldExist = resources != null && !resources.isEmpty();
        Element resourcesElem = this.updateElement(counter, root, "resources", shouldExist);
        if (shouldExist) {
            List children = resourcesElem.getContent((Filter)new ElementFilter("resource"));
            Iterator tgtIterator = children.iterator();
            Iterator srcIterator = resources.iterator();
            while (tgtIterator.hasNext() && srcIterator.hasNext()) {
                Element el = (Element)tgtIterator.next();
                IContentProvider res = (IContentProvider)srcIterator.next();
                this.doUpdateSingleResource(el, res);
                log.debug((Object)("updating element " + el.getChildText("directory")));
            }
            while (tgtIterator.hasNext()) {
                tgtIterator.next();
                tgtIterator.remove();
            }
            while (srcIterator.hasNext()) {
                IContentProvider res = (IContentProvider)srcIterator.next();
                Element newEl = this.factory.element("resource");
                this.doUpdateSingleResource(newEl, res);
                children.add(newEl);
            }
        }
    }

    private void doUpdateSourceModifications(Counter counter, Element root, List sourceModifications) throws Exception {
        boolean shouldExist = sourceModifications != null && !sourceModifications.isEmpty();
        Element sourcesModificationsElem = this.updateElement(counter, root, "sourceModifications", shouldExist);
        if (shouldExist) {
            List children = sourcesModificationsElem.getContent((Filter)new ElementFilter("sourceModification"));
            Iterator tgtIterator = children.iterator();
            Iterator srcIterator = sourceModifications.iterator();
            while (tgtIterator.hasNext() && srcIterator.hasNext()) {
                Element el = (Element)tgtIterator.next();
                IContentProvider res = (IContentProvider)srcIterator.next();
                this.doUpdateSingleSourceModification(el, res);
            }
            while (tgtIterator.hasNext()) {
                tgtIterator.next();
                tgtIterator.remove();
            }
            while (srcIterator.hasNext()) {
                IContentProvider res = (IContentProvider)srcIterator.next();
                Element newEl = this.factory.element("sourceModification");
                this.doUpdateSingleSourceModification(newEl, res);
                children.add(newEl);
            }
        }
    }

    private void doUpdateSingleResource(Element resElem, IContentProvider resource) throws Exception {
        Counter innerCount = new Counter();
        this.findAndReplaceSimpleElement(innerCount, resElem, "directory", resource.getValue("directory"));
        this.findAndReplaceSimpleElement(innerCount, resElem, "targetPath", resource.getValue("targetPath"));
        this.doUpdateSimpleChildren(innerCount, resElem, resource.getValueList("includes", "include"), "includes", "include");
        this.doUpdateSimpleChildren(innerCount, resElem, resource.getValueList("excludes", "exclude"), "excludes", "exclude");
        this.findAndReplaceSimpleElement(innerCount, resElem, "filtering", resource.getValue("filtering"));
    }

    private void doUpdateSingleSourceModification(Element resElem, IContentProvider resource) throws Exception {
        Counter innerCount = new Counter();
        this.findAndReplaceSimpleElement(innerCount, resElem, "className", resource.getValue("className"));
        this.doUpdateSimpleChildren(innerCount, resElem, resource.getValueList("includes", "include"), "includes", "include");
        this.doUpdateSimpleChildren(innerCount, resElem, resource.getValueList("excludes", "exclude"), "excludes", "exclude");
    }

    private void doUpdateSimpleChildren(Counter counter, Element root, List newValues, String parentName, String childName) {
        boolean shouldExist = newValues != null && !newValues.isEmpty();
        Element cludeElem = this.updateElement(counter, root, parentName, shouldExist);
        if (shouldExist) {
            Element child;
            List children = cludeElem.getContent((Filter)new ElementFilter(childName));
            Iterator tgtIterator = children.iterator();
            Iterator srcIterator = newValues.iterator();
            while (tgtIterator.hasNext() && srcIterator.hasNext()) {
                child = (Element)tgtIterator.next();
                child.setText((String)srcIterator.next());
            }
            while (tgtIterator.hasNext()) {
                tgtIterator.next();
                tgtIterator.remove();
            }
            while (srcIterator.hasNext()) {
                child = this.factory.element(childName);
                child.setText((String)srcIterator.next());
                children.add(child);
            }
        }
    }

    private Element findAndReplaceSimpleElement(Counter counter, Element parent, String name, String text) {
        boolean shouldExist = text != null && text.trim().length() > 0;
        Element element = this.updateElement(counter, parent, name, shouldExist);
        if (shouldExist) {
            element.setText(text);
        }
        return element;
    }

    private Element updateElement(Counter counter, Element parent, String name, boolean shouldExist) {
        Element element = parent.getChild(name);
        if (element != null && shouldExist && parent.getChildren().indexOf(element) <= counter.getCurrentIndex()) {
            counter.increaseCount();
        }
        if (element == null && shouldExist) {
            element = this.factory.element(name);
            this.insertAtPrefferedLocation(parent, element, counter);
            counter.increaseCount();
        }
        if (!shouldExist && element != null) {
            parent.removeChild(name);
        }
        return element;
    }

    private void insertAtPrefferedLocation(Element parent, Element child, Counter counter) {
        List children = parent.getChildren();
        int count = children.size();
        if (counter.getCurrentIndex() >= count) {
            parent.addContent((Content)child);
        } else {
            log.debug((Object)("inserting " + child.getName() + " with pref loc=" + counter.getCurrentIndex()));
            children.add(counter.getCurrentIndex(), child);
        }
    }

    private void removeNonUsedSubelements(Element parent, String subElemName, List preserveList) {
        List currList = subElemName != null ? parent.getChildren(subElemName) : parent.getChildren();
        currList = new ArrayList(currList);
        Iterator it = currList.iterator();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            if (preserveList.contains(el)) continue;
            parent.removeContent((Content)el);
            log.debug((Object)("removing not used element " + el));
        }
    }

    private static class Counter {
        int currentIndex = 0;

        public void increaseCount() {
            ++this.currentIndex;
        }

        public int getCurrentIndex() {
            return this.currentIndex;
        }
    }

    private static class DependencyElementFilter
    implements Filter {
        private String id;
        private String artifactId;
        private String groupId;
        private String type;

        public DependencyElementFilter(String id, String artifactId, String groupId) {
            this(id, artifactId, groupId, null);
        }

        public DependencyElementFilter(String id, String artifactId, String groupId, String type) {
            this.id = id;
            this.artifactId = artifactId;
            this.groupId = groupId;
            this.type = type == null ? "jar" : type;
        }

        public boolean canRemove(Object obj) {
            return true;
        }

        public boolean canAdd(Object obj) {
            return true;
        }

        public boolean matches(Object obj) {
            Element elem;
            if (obj instanceof Element && (elem = (Element)obj).getName().equals("dependency")) {
                String elId = elem.getChildText("id");
                String elGroupId = elem.getChildText("groupId");
                String elArtifactId = elem.getChildText("artifactId");
                String elType = elem.getChildText("type");
                if (elType == null) {
                    elType = "jar";
                }
                if (elId != null && elId.equals(this.id)) {
                    return elType != null && elType.equals(this.type);
                }
                if (elGroupId != null && elArtifactId != null && elGroupId.equals(this.groupId) && elArtifactId.equals(this.artifactId)) {
                    return elType != null && elType.equals(this.type);
                }
            }
            return false;
        }
    }

    private static class SpecificElementFilter
    implements Filter {
        private String elemName;
        private String keyElem;
        private String keyVal;

        public SpecificElementFilter(String elementName, String keyElement, String keyValue) {
            this.elemName = elementName;
            this.keyElem = keyElement;
            this.keyVal = keyValue;
        }

        public boolean canRemove(Object obj) {
            return true;
        }

        public boolean canAdd(Object obj) {
            return true;
        }

        public boolean matches(Object obj) {
            String key;
            Element elem;
            return obj instanceof Element && (elem = (Element)obj).getName().equals(this.elemName) && (key = elem.getChildText(this.keyElem)) != null && key.equals(this.keyVal);
        }
    }
}

