/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.project.io;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Element;
import org.mevenide.project.io.IContentProvider;

public final class ElementContentProvider
implements IContentProvider {
    private static final Log log = LogFactory.getLog((Class)ElementContentProvider.class);
    private Element element;

    public ElementContentProvider(Element parent) {
        this.element = parent;
    }

    public IContentProvider getSubContentProvider(String key) {
        Element child = this.element.getChild(key);
        return child != null ? new ElementContentProvider(child) : null;
    }

    public String getValue(String key) {
        Element child = this.element.getChild(key);
        return child != null ? child.getText() : null;
    }

    public List getSubContentProviderList(String parentKey, String childKey) {
        List list;
        Element parent = this.element.getChild(parentKey);
        if (parent != null && (list = parent.getChildren(childKey)).size() > 0) {
            ArrayList<ElementContentProvider> toReturn = new ArrayList<ElementContentProvider>(list.size());
            Iterator it = list.iterator();
            while (it.hasNext()) {
                Element obj2 = (Element)it.next();
                toReturn.add(new ElementContentProvider(obj2));
            }
            return toReturn;
        }
        return null;
    }

    public List getValueList(String parentKey, String childKey) {
        List list;
        Element parent = this.element.getChild(parentKey);
        if (parent != null && (list = parent.getChildren(childKey)).size() > 0) {
            ArrayList<String> toReturn = new ArrayList<String>(list.size());
            Iterator it = list.iterator();
            while (it.hasNext()) {
                Element obj2 = (Element)it.next();
                toReturn.add(obj2.getText());
            }
            return toReturn;
        }
        return null;
    }

    public List getProperties() {
        Element props = this.element.getChild("properties");
        if (props != null) {
            ArrayList<String> toReturn = new ArrayList<String>();
            List childs = props.getChildren();
            Iterator it = childs.iterator();
            while (it.hasNext()) {
                Element el = (Element)it.next();
                String value = el.getText();
                String str = el.getName() + ":" + value;
                toReturn.add(str);
            }
            return toReturn;
        }
        return null;
    }
}

