/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.project.io;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.project.Dependency;
import org.apache.maven.project.Project;
import org.mevenide.context.IQueryContext;
import org.mevenide.environment.ILocationFinder;
import org.mevenide.environment.LocationFinderAggregator;
import org.mevenide.properties.IPropertyResolver;
import org.mevenide.properties.resolver.PropertyResolverFactory;
import org.mevenide.util.StringUtils;

public final class JarOverrideReader2 {
    private static Log log = LogFactory.getLog((Class)JarOverrideReader2.class);
    private static JarOverrideReader2 instance;

    JarOverrideReader2() {
    }

    public static JarOverrideReader2 getInstance() {
        if (instance == null) {
            instance = new JarOverrideReader2();
        }
        return instance;
    }

    public void processOverride(Project project, IPropertyResolver resolver, ILocationFinder finder) {
        List deps = project.getDependencies();
        if (deps != null) {
            Iterator it = deps.iterator();
            while (it.hasNext()) {
                Dependency dep = (Dependency)it.next();
                String override = this.processOverride(dep, resolver, finder);
                if (override == null) continue;
                dep.setJar(override);
            }
        }
    }

    public void processOverride(Project project, IQueryContext context) {
        IPropertyResolver resolver = PropertyResolverFactory.getFactory().createContextBasedResolver(context);
        LocationFinderAggregator finder = new LocationFinderAggregator(context);
        this.processOverride(project, resolver, (ILocationFinder)finder);
    }

    public String processOverride(Dependency dependency, IQueryContext context) {
        IPropertyResolver resolver = PropertyResolverFactory.getFactory().createContextBasedResolver(context);
        LocationFinderAggregator finder = new LocationFinderAggregator(context);
        return this.processOverride(dependency, resolver, (ILocationFinder)finder);
    }

    public String processOverride(Dependency dependency, IPropertyResolver resolver, ILocationFinder finder) {
        boolean isJarOverrideOn = this.isJarOverrideOn(resolver);
        log.debug((Object)("jar override " + (isJarOverrideOn ? " on " : " off")));
        if (isJarOverrideOn) {
            String dependencyOverrideValue = this.getOverrideValue(dependency, resolver, finder);
            log.debug((Object)("overriding jar for dep : " + dependency.getId() + " : " + dependencyOverrideValue));
            return dependencyOverrideValue;
        }
        return null;
    }

    private String getOverrideValue(Dependency dependency, IPropertyResolver resolver, ILocationFinder finder) {
        String versionOverrideValue;
        String key = "maven.jar." + dependency.getArtifactId();
        String dependencyOverrideValue = resolver.getResolvedValue(key);
        if (!StringUtils.isNull(dependencyOverrideValue) && (versionOverrideValue = this.checkVersionOverrideValue(dependency, dependencyOverrideValue.trim(), resolver, finder)) != null) {
            dependencyOverrideValue = versionOverrideValue;
        }
        return dependencyOverrideValue;
    }

    private String checkVersionOverrideValue(Dependency dependency, String dependencyOverrideValue, IPropertyResolver resolver, ILocationFinder finder) {
        if (Character.isDigit(dependencyOverrideValue.charAt(0))) {
            File artifactGroupPath = new File(finder.getMavenLocalRepository(), dependency.getGroupId());
            File artifactTypePath = new File(artifactGroupPath, "jars");
            File artifactPath = new File(artifactTypePath, dependency.getArtifactId() + "-" + dependencyOverrideValue + ".jar");
            return artifactPath.getAbsolutePath();
        }
        return null;
    }

    private boolean isJarOverrideOn(IPropertyResolver resolver) {
        String prop = resolver.getResolvedValue("maven.jar.override");
        return prop != null && ("on".equalsIgnoreCase(prop = prop.trim()) || "1".equals(prop) || "true".equalsIgnoreCase(prop));
    }
}

